/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import android.content.SharedPreferences;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lleakcanary/OncePerPeriodInterceptor;", "Lleakcanary/HeapAnalysisInterceptor;", "application", "Landroid/app/Application;", "periodMillis", "", "(Landroid/app/Application;J)V", "preference", "Landroid/content/SharedPreferences;", "getPreference", "()Landroid/content/SharedPreferences;", "preference$delegate", "Lkotlin/Lazy;", "forget", "", "intercept", "Lleakcanary/HeapAnalysisJob$Result;", "chain", "Lleakcanary/HeapAnalysisInterceptor$Chain;", "Companion", "leakcanary-android-release_release"})
public final class OncePerPeriodInterceptor
implements HeapAnalysisInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long periodMillis;
    @NotNull
    private final Lazy preference$delegate;
    @NotNull
    private static final String LAST_START_TIMESTAMP_KEY = "last_start_timestamp";

    public OncePerPeriodInterceptor(@NotNull Application application, long periodMillis) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.periodMillis = periodMillis;
        this.preference$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(application){
            final /* synthetic */ Application $application;
            {
                this.$application = $application;
                super(0);
            }

            @NotNull
            public final SharedPreferences invoke() {
                SharedPreferences sharedPreferences = this.$application.getSharedPreferences("OncePerPeriodInterceptor", 0);
                Intrinsics.checkNotNull((Object)sharedPreferences);
                return sharedPreferences;
            }
        }));
    }

    public /* synthetic */ OncePerPeriodInterceptor(Application application, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = TimeUnit.DAYS.toMillis(1L);
        }
        this(application, l);
    }

    private final SharedPreferences getPreference() {
        Lazy lazy = this.preference$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result intercept(@NotNull HeapAnalysisInterceptor.Chain chain) {
        HeapAnalysisJob.Result result;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        long lastStartTimestamp = this.getPreference().getLong(LAST_START_TIMESTAMP_KEY, 0L);
        long now = System.currentTimeMillis();
        long elapsedMillis = now - lastStartTimestamp;
        if (elapsedMillis < this.periodMillis) {
            chain.getJob().cancel("not enough time elapsed since last analysis: elapsed " + elapsedMillis + " ms < period " + this.periodMillis + " ms");
        }
        HeapAnalysisJob.Result $this$intercept_u24lambda_u240 = result = chain.proceed();
        boolean bl = false;
        if ($this$intercept_u24lambda_u240 instanceof HeapAnalysisJob.Result.Done) {
            this.getPreference().edit().putLong(LAST_START_TIMESTAMP_KEY, now).apply();
        }
        return result;
    }

    public final void forget() {
        this.getPreference().edit().clear().apply();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lleakcanary/OncePerPeriodInterceptor$Companion;", "", "()V", "LAST_START_TIMESTAMP_KEY", "", "leakcanary-android-release_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

