/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.os.Debug;
import android.os.SystemClock;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import leakcanary.HeapAnalysisConfig;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import leakcanary.JobContext;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.CloseableHeapGraph;
import shark.ConstantMemoryMetricsDualSourceProvider;
import shark.DualSourceProvider;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HprofHeapGraph;
import shark.HprofPrimitiveArrayStripper;
import shark.OnAnalysisProgressListener;
import shark.RandomAccessSource;
import shark.SharkLog;
import shark.StreamingSourceProvider;
import shark.ThrowingCancelableFileSourceProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0002EFB1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000200H\u0016J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000200H\u0002J\b\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u0002032\u0006\u00101\u001a\u00020\u0005H\u0002J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016J\b\u0010>\u001a\u000203H\u0002J\u0010\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005H\u0002R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006G"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob;", "Lleakcanary/HeapAnalysisJob;", "Lleakcanary/HeapAnalysisInterceptor$Chain;", "heapDumpDirectoryProvider", "Lkotlin/Function0;", "Ljava/io/File;", "config", "Lleakcanary/HeapAnalysisConfig;", "interceptors", "", "Lleakcanary/HeapAnalysisInterceptor;", "context", "Lleakcanary/JobContext;", "(Lkotlin/jvm/functions/Function0;Lleakcanary/HeapAnalysisConfig;Ljava/util/List;Lleakcanary/JobContext;)V", "_canceled", "Ljava/util/concurrent/atomic/AtomicReference;", "Lleakcanary/HeapAnalysisJob$Result$Canceled;", "_executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "analysisStep", "Lshark/OnAnalysisProgressListener$Step;", "canceled", "", "getCanceled", "()Z", "getContext", "()Lleakcanary/JobContext;", "executed", "getExecuted", "executionThread", "Ljava/lang/Thread;", "heapDumpDirectory", "getHeapDumpDirectory", "()Ljava/io/File;", "heapDumpDirectory$delegate", "Lkotlin/Lazy;", "interceptorIndex", "", "job", "getJob", "()Lleakcanary/HeapAnalysisJob;", "analyzeHeap", "Lshark/HeapAnalysis;", "analyzedHeapDumpFile", "graph", "Lshark/CloseableHeapGraph;", "analyzeHeapWithStats", "Lkotlin/Pair;", "", "heapDumpFile", "cancel", "", "cancelReason", "checkStopAnalysis", "step", "dumpAndAnalyzeHeap", "Lleakcanary/HeapAnalysisJob$Result$Done;", "dumpHeap", "enqueueReferences", "execute", "Lleakcanary/HeapAnalysisJob$Result;", "proceed", "runGc", "saveHeapDumpTime", "heapDumpUptimeMillis", "", "stripHeapDump", "sourceHeapDumpFile", "strippedHeapDumpFile", "Companion", "StopAnalysis", "leakcanary-android-release_release"})
@SourceDebugExtension(value={"SMAP\nRealHeapAnalysisJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealHeapAnalysisJob.kt\nleakcanary/internal/RealHeapAnalysisJob\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SharkLog.kt\nshark/SharkLog\n+ 4 Friendly.kt\nleakcanary/internal/friendly/leakcanary-android-release_Friendly\n+ 5 Timing.kt\nleakcanary/internal/TimingKt\n*L\n1#1,339:1\n1#2:340\n34#3,3:341\n46#3,3:348\n34#3,3:351\n34#3,3:354\n14#4:344\n9#5,3:345\n*S KotlinDebug\n*F\n+ 1 RealHeapAnalysisJob.kt\nleakcanary/internal/RealHeapAnalysisJob\n*L\n67#1:341,3\n217#1:348,3\n250#1:351,3\n306#1:354,3\n133#1:344\n133#1:345,3\n*E\n"})
public final class RealHeapAnalysisJob
implements HeapAnalysisJob,
HeapAnalysisInterceptor.Chain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> heapDumpDirectoryProvider;
    @NotNull
    private final HeapAnalysisConfig config;
    @NotNull
    private final List<HeapAnalysisInterceptor> interceptors;
    @NotNull
    private final JobContext context;
    @NotNull
    private final Lazy heapDumpDirectory$delegate;
    @NotNull
    private final AtomicReference<HeapAnalysisJob.Result.Canceled> _canceled;
    @NotNull
    private final AtomicBoolean _executed;
    private Thread executionThread;
    private int interceptorIndex;
    @Nullable
    private OnAnalysisProgressListener.Step analysisStep;
    @NotNull
    public static final String HPROF_PREFIX = "heap-";
    @NotNull
    public static final String HPROF_SUFFIX = ".hprof";

    public RealHeapAnalysisJob(@NotNull Function0<? extends File> heapDumpDirectoryProvider, @NotNull HeapAnalysisConfig config, @NotNull List<? extends HeapAnalysisInterceptor> interceptors, @NotNull JobContext context) {
        Intrinsics.checkNotNullParameter(heapDumpDirectoryProvider, (String)"heapDumpDirectoryProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.heapDumpDirectoryProvider = heapDumpDirectoryProvider;
        this.config = config;
        this.interceptors = interceptors;
        this.context = context;
        this.heapDumpDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ RealHeapAnalysisJob this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return (File)RealHeapAnalysisJob.access$getHeapDumpDirectoryProvider$p(this.this$0).invoke();
            }
        }));
        this._canceled = new AtomicReference();
        this._executed = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public JobContext getContext() {
        return this.context;
    }

    private final File getHeapDumpDirectory() {
        Lazy lazy = this.heapDumpDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    public boolean getExecuted() {
        return this._executed.get();
    }

    @Override
    public boolean getCanceled() {
        return this._canceled.get() != null;
    }

    @Override
    @NotNull
    public HeapAnalysisJob getJob() {
        return this;
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result execute() {
        if (!this._executed.compareAndSet(false, true)) {
            boolean $i$a$-check-RealHeapAnalysisJob$execute$22 = false;
            String $i$a$-check-RealHeapAnalysisJob$execute$22 = "HeapAnalysisJob can only be executed once";
            throw new IllegalStateException($i$a$-check-RealHeapAnalysisJob$execute$22.toString());
        }
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger != null) {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            logger2.d("Starting heap analysis job");
        }
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
        this.executionThread = thread;
        return this.proceed();
    }

    @Override
    public void cancel(@NotNull String cancelReason) {
        Intrinsics.checkNotNullParameter((Object)cancelReason, (String)"cancelReason");
        this._canceled.compareAndSet(null, new HeapAnalysisJob.Result.Canceled(cancelReason));
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result proceed() {
        Throwable cause;
        Thread thread = Thread.currentThread();
        Thread thread2 = this.executionThread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executionThread");
            thread2 = null;
        }
        if (!Intrinsics.areEqual((Object)thread, (Object)thread2)) {
            boolean $i$a$-check-RealHeapAnalysisJob$proceed$32 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Interceptor.Chain.proceed() called from unexpected thread ").append(Thread.currentThread()).append(" instead of ");
            Thread thread3 = this.executionThread;
            if (thread3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executionThread");
                thread3 = null;
            }
            String $i$a$-check-RealHeapAnalysisJob$proceed$32 = stringBuilder.append(thread3).toString();
            throw new IllegalStateException($i$a$-check-RealHeapAnalysisJob$proceed$32.toString());
        }
        if (!(this.interceptorIndex <= this.interceptors.size())) {
            boolean $i$a$-check-RealHeapAnalysisJob$proceed$42 = false;
            String $i$a$-check-RealHeapAnalysisJob$proceed$42 = "Interceptor.Chain.proceed() should be called max once per interceptor";
            throw new IllegalStateException($i$a$-check-RealHeapAnalysisJob$proceed$42.toString());
        }
        HeapAnalysisJob.Result.Canceled canceled = this._canceled.get();
        if (canceled != null) {
            HeapAnalysisJob.Result.Canceled it = canceled;
            boolean bl = false;
            this.interceptorIndex = this.interceptors.size() + 1;
            return it;
        }
        if (this.interceptorIndex < this.interceptors.size()) {
            HeapAnalysisInterceptor currentInterceptor = this.interceptors.get(this.interceptorIndex);
            int $i$a$-check-RealHeapAnalysisJob$proceed$42 = this.interceptorIndex;
            this.interceptorIndex = $i$a$-check-RealHeapAnalysisJob$proceed$42 + 1;
            return currentInterceptor.intercept(this);
        }
        int currentInterceptor = this.interceptorIndex;
        this.interceptorIndex = currentInterceptor + 1;
        HeapAnalysisJob.Result.Done result = this.dumpAndAnalyzeHeap();
        HeapAnalysis analysis = result.getAnalysis();
        analysis.getHeapDumpFile().delete();
        if (analysis instanceof HeapAnalysisFailure && (cause = ((HeapAnalysisFailure)analysis).getException().getCause()) instanceof StopAnalysis) {
            HeapAnalysisJob.Result.Canceled canceled2 = this._canceled.get();
            Intrinsics.checkNotNull((Object)canceled2);
            HeapAnalysisJob.Result.Canceled $this$proceed_u24lambda_u245 = canceled2;
            boolean bl = false;
            return $this$proceed_u24lambda_u245.copy($this$proceed_u24lambda_u245.getCancelReason() + " (stopped at " + ((StopAnalysis)cause).getStep() + ')');
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeapAnalysisJob.Result.Done dumpAndAnalyzeHeap() {
        File file;
        File filesDir = this.getHeapDumpDirectory();
        filesDir.mkdirs();
        String fileNameBase = HPROF_PREFIX + UUID.randomUUID();
        File $this$dumpAndAnalyzeHeap_u24lambda_u246 = file = new File(filesDir, fileNameBase + HPROF_SUFFIX);
        boolean bl = false;
        $this$dumpAndAnalyzeHeap_u24lambda_u246.deleteOnExit();
        File sensitiveHeapDumpFile = file;
        long heapDumpStart = SystemClock.uptimeMillis();
        this.saveHeapDumpTime(heapDumpStart);
        long dumpDurationMillis = 0L;
        dumpDurationMillis = -1L;
        long analysisDurationMillis = -1L;
        Object heapDumpFile = null;
        heapDumpFile = sensitiveHeapDumpFile;
        try {
            HeapAnalysisJob.Result.Done done;
            Long l;
            Object object;
            this.runGc();
            this.dumpHeap(sensitiveHeapDumpFile);
            dumpDurationMillis = SystemClock.uptimeMillis() - heapDumpStart;
            if (this.config.getStripHeapDump()) {
                Object strippedHeapDumpFile;
                boolean $i$f$measureDurationMillis = false;
                boolean $i$f$measureDurationMillis2 = false;
                long start$iv$iv = SystemClock.uptimeMillis();
                boolean bl2 = false;
                Object $this$dumpAndAnalyzeHeap_u24lambda_u248_u24lambda_u247 = object = new File(filesDir, fileNameBase + "-stripped.hprof");
                boolean bl3 = false;
                ((File)$this$dumpAndAnalyzeHeap_u24lambda_u248_u24lambda_u247).deleteOnExit();
                heapDumpFile = strippedHeapDumpFile = object;
                try {
                    this.stripHeapDump(sensitiveHeapDumpFile, (File)strippedHeapDumpFile);
                }
                finally {
                    sensitiveHeapDumpFile.delete();
                }
                l = SystemClock.uptimeMillis() - start$iv$iv;
            } else {
                l = null;
            }
            Long stripDurationMillis = l;
            Pair<HeapAnalysis, String> pair = this.analyzeHeapWithStats((File)heapDumpFile);
            boolean bl4 = false;
            HeapAnalysis heapAnalysis = (HeapAnalysis)pair.component1();
            String stats = (String)pair.component2();
            object = heapAnalysis;
            if (object instanceof HeapAnalysisSuccess) {
                Map metadata = MapsKt.toMutableMap((Map)((HeapAnalysisSuccess)heapAnalysis).getMetadata());
                metadata.put("Stats", stats);
                if (this.config.getStripHeapDump()) {
                    metadata.put("Hprof stripping duration", stripDurationMillis + " ms");
                }
                done = new HeapAnalysisJob.Result.Done((HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)heapAnalysis), null, (long)0L, (long)dumpDurationMillis, (long)0L, (Map)metadata, null, null, null, (int)235, null), stripDurationMillis);
            } else if (object instanceof HeapAnalysisFailure) {
                done = new HeapAnalysisJob.Result.Done((HeapAnalysis)HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis), null, (long)0L, (long)dumpDurationMillis, (long)(SystemClock.uptimeMillis() - heapDumpStart - dumpDurationMillis), null, (int)19, null), stripDurationMillis);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return done;
        }
        catch (Throwable throwable) {
            if (dumpDurationMillis == -1L) {
                dumpDurationMillis = SystemClock.uptimeMillis() - heapDumpStart;
            }
            if (analysisDurationMillis == -1L) {
                analysisDurationMillis = SystemClock.uptimeMillis() - heapDumpStart - dumpDurationMillis;
            }
            return new HeapAnalysisJob.Result.Done((HeapAnalysis)new HeapAnalysisFailure((File)heapDumpFile, System.currentTimeMillis(), dumpDurationMillis, analysisDurationMillis, new HeapAnalysisException(throwable)), null, 2, null);
        }
    }

    private final void runGc() {
        Runtime.getRuntime().gc();
        this.enqueueReferences();
        System.runFinalization();
    }

    private final void enqueueReferences() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    private final void saveHeapDumpTime(long heapDumpUptimeMillis) {
        block2: {
            try {
                Field field;
                Field $this$saveHeapDumpTime_u24lambda_u2410 = field = Class.forName("leakcanary.KeyedWeakReference").getDeclaredField("heapDumpUptimeMillis");
                boolean bl = false;
                $this$saveHeapDumpTime_u24lambda_u2410.setAccessible(true);
                field.set(null, heapDumpUptimeMillis);
            }
            catch (Throwable ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) break block2;
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = ignored;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "KeyedWeakReference.heapDumpUptimeMillis not updated";
                logger2.d(throwable, string);
            }
        }
    }

    private final void dumpHeap(File heapDumpFile) {
        Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
        if (!heapDumpFile.exists()) {
            boolean $i$a$-check-RealHeapAnalysisJob$dumpHeap$32 = false;
            String $i$a$-check-RealHeapAnalysisJob$dumpHeap$32 = "File does not exist after dump";
            throw new IllegalStateException($i$a$-check-RealHeapAnalysisJob$dumpHeap$32.toString());
        }
        if (!(heapDumpFile.length() > 0L)) {
            boolean bl = false;
            String string = "File has length " + heapDumpFile.length() + " after dump";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void stripHeapDump(File sourceHeapDumpFile, File strippedHeapDumpFile) {
        ThrowingCancelableFileSourceProvider sensitiveSourceProvider = new ThrowingCancelableFileSourceProvider(sourceHeapDumpFile, () -> RealHeapAnalysisJob.stripHeapDump$lambda$14(this));
        Ref.IntRef openCalls = new Ref.IntRef();
        StreamingSourceProvider deletingFileSourceProvider2 = () -> RealHeapAnalysisJob.stripHeapDump$lambda$17(openCalls, sensitiveSourceProvider, sourceHeapDumpFile);
        BufferedSink strippedHprofSink = Okio.buffer((Sink)Okio.sink((OutputStream)new FileOutputStream(strippedHeapDumpFile)));
        HprofPrimitiveArrayStripper stripper = new HprofPrimitiveArrayStripper();
        stripper.stripPrimitiveArrays(deletingFileSourceProvider2, strippedHprofSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<HeapAnalysis, String> analyzeHeapWithStats(File heapDumpFile) {
        Pair pair;
        long fileLength = heapDumpFile.length();
        ConstantMemoryMetricsDualSourceProvider analysisSourceProvider = new ConstantMemoryMetricsDualSourceProvider((DualSourceProvider)new ThrowingCancelableFileSourceProvider(heapDumpFile, () -> RealHeapAnalysisJob.analyzeHeapWithStats$lambda$18(this)));
        DualSourceProvider deletingFileSourceProvider2 = new DualSourceProvider(analysisSourceProvider, heapDumpFile){
            final /* synthetic */ ConstantMemoryMetricsDualSourceProvider $analysisSourceProvider;
            final /* synthetic */ File $heapDumpFile;
            {
                this.$analysisSourceProvider = $analysisSourceProvider;
                this.$heapDumpFile = $heapDumpFile;
            }

            @NotNull
            public BufferedSource openStreamingSource() {
                return this.$analysisSourceProvider.openStreamingSource();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public RandomAccessSource openRandomAccessSource() {
                void this_$iv;
                SharkLog sharkLog = SharkLog.INSTANCE;
                File file = this.$heapDumpFile;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger != null) {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    logger2.d("Deleting " + file + " eagerly");
                }
                sharkLog = this.$analysisSourceProvider.openRandomAccessSource();
                file = this.$heapDumpFile;
                SharkLog $this$openRandomAccessSource_u24lambda_u241 = sharkLog;
                boolean bl = false;
                file.delete();
                return sharkLog;
            }
        };
        Closeable closeable = (Closeable)HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (DualSourceProvider)deletingFileSourceProvider2, null, null, (int)3, null);
        Throwable throwable = null;
        try {
            CloseableHeapGraph graph = (CloseableHeapGraph)closeable;
            boolean bl = false;
            HeapAnalysis heapAnalysis = this.analyzeHeap(heapDumpFile, graph);
            Intrinsics.checkNotNull((Object)graph, (String)"null cannot be cast to non-null type shark.HprofHeapGraph");
            String lruCacheStats = ((HprofHeapGraph)graph).lruCacheStats();
            String randomAccessStats = "RandomAccess[bytes=" + analysisSourceProvider.getRandomAccessByteReads() + ",reads=" + analysisSourceProvider.getRandomAccessReadCount() + ",travel=" + analysisSourceProvider.getRandomAccessByteTravel() + ",range=" + analysisSourceProvider.getByteTravelRange() + ",size=" + fileLength + ']';
            String stats = lruCacheStats + ' ' + randomAccessStats;
            pair = TuplesKt.to((Object)heapAnalysis, (Object)stats);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return pair;
    }

    private final HeapAnalysis analyzeHeap(File analyzedHeapDumpFile, CloseableHeapGraph graph) {
        OnAnalysisProgressListener stepListener = arg_0 -> RealHeapAnalysisJob.analyzeHeap$lambda$21(this, arg_0);
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer(stepListener);
        return heapAnalyzer.analyze(analyzedHeapDumpFile, (HeapGraph)graph, this.config.getLeakingObjectFinder(), this.config.getReferenceMatchers(), this.config.getComputeRetainedHeapSize(), this.config.getObjectInspectors(), this.config.getMetadataExtractor());
    }

    private final void checkStopAnalysis(String step) {
        if (this._canceled.get() != null) {
            throw new StopAnalysis(step);
        }
    }

    private static final void stripHeapDump$lambda$14(RealHeapAnalysisJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.checkStopAnalysis("stripping heap dump");
    }

    private static final BufferedSource stripHeapDump$lambda$17(Ref.IntRef $openCalls, ThrowingCancelableFileSourceProvider $sensitiveSourceProvider, File $sourceHeapDumpFile) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$openCalls, (String)"$openCalls");
        Intrinsics.checkNotNullParameter((Object)$sensitiveSourceProvider, (String)"$sensitiveSourceProvider");
        Intrinsics.checkNotNullParameter((Object)$sourceHeapDumpFile, (String)"$sourceHeapDumpFile");
        int n = $openCalls.element;
        $openCalls.element = n + 1;
        BufferedSource $this$stripHeapDump_u24lambda_u2417_u24lambda_u2416 = bufferedSource = $sensitiveSourceProvider.openStreamingSource();
        boolean bl = false;
        if ($openCalls.element == 2) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl2 = false;
                logger2.d("Deleting " + $sourceHeapDumpFile + " eagerly");
            }
            $sourceHeapDumpFile.delete();
        }
        return bufferedSource;
    }

    private static final void analyzeHeapWithStats$lambda$18(RealHeapAnalysisJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.analysisStep;
        if (object == null || (object = object.name()) == null) {
            object = "Reading heap dump";
        }
        this$0.checkStopAnalysis((String)object);
    }

    private static final void analyzeHeap$lambda$21(RealHeapAnalysisJob this$0, OnAnalysisProgressListener.Step step) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this$0.analysisStep = step;
        this$0.checkStopAnalysis(step.name());
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger != null) {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            logger2.d("Analysis in progress, working on: " + step.name());
        }
    }

    public static final /* synthetic */ Function0 access$getHeapDumpDirectoryProvider$p(RealHeapAnalysisJob $this) {
        return $this.heapDumpDirectoryProvider;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob$Companion;", "", "()V", "HPROF_PREFIX", "", "HPROF_SUFFIX", "leakcanary-android-release_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob$StopAnalysis;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "step", "", "(Ljava/lang/String;)V", "getStep", "()Ljava/lang/String;", "fillInStackTrace", "", "leakcanary-android-release_release"})
    public static final class StopAnalysis
    extends Exception {
        @NotNull
        private final String step;

        public StopAnalysis(@NotNull String step) {
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            this.step = step;
        }

        @NotNull
        public final String getStep() {
            return this.step;
        }

        @Override
        @NotNull
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

