/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.LayoutInflater;
import android.widget.Toast;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.FutureResult;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class AndroidHeapDumper
implements HeapDumper {
    private static final String TAG = "AndroidHeapDumper";
    private final Context context;
    private final Handler mainHandler;

    public AndroidHeapDumper(Context context) {
        this.context = context.getApplicationContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public File dumpHeap() {
        File heapDumpFile;
        if (!LeakCanaryInternals.isExternalStorageWritable()) {
            Log.d((String)TAG, (String)"Could not dump heap, external storage not mounted.");
        }
        if ((heapDumpFile = this.getHeapDumpFile()).exists()) {
            Log.d((String)TAG, (String)"Could not dump heap, previous analysis still is in progress.");
            return NO_DUMP;
        }
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            Log.d((String)TAG, (String)"Did not dump heap, too much time waiting for Toast.");
            return NO_DUMP;
        }
        Toast toast = waitingForToast.get();
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            this.cancelToast(toast);
            return heapDumpFile;
        }
        catch (IOException e) {
            this.cleanup();
            Log.e((String)TAG, (String)"Could not perform heap dump", (Throwable)e);
            return NO_DUMP;
        }
    }

    public void cleanup() {
        LeakCanaryInternals.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                File heapDumpFile;
                if (LeakCanaryInternals.isExternalStorageWritable()) {
                    Log.d((String)AndroidHeapDumper.TAG, (String)"Could not attempt cleanup, external storage not mounted.");
                }
                if ((heapDumpFile = AndroidHeapDumper.this.getHeapDumpFile()).exists()) {
                    Log.d((String)AndroidHeapDumper.TAG, (String)("Previous analysis did not complete correctly, cleaning: " + heapDumpFile));
                    heapDumpFile.delete();
                }
            }
        });
    }

    private File getHeapDumpFile() {
        return new File(LeakCanaryInternals.storageDirectory(), "suspected_leak_heapdump.hprof");
    }

    private void showToast(final FutureResult<Toast> waitingForToast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                final Toast toast = new Toast(AndroidHeapDumper.this.context);
                toast.setGravity(16, 0, 0);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.this.context);
                toast.setView(inflater.inflate(R.layout.__leak_canary_heap_dump_toast, null));
                toast.show();
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        waitingForToast.set(toast);
                        return false;
                    }
                });
            }
        });
    }

    private void cancelToast(final Toast toast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                toast.cancel();
            }
        });
    }
}

