/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.os.Build;
import com.squareup.leakcanary.ExcludedRefs;

public final class AndroidExcludedRefs {
    private static final String SAMSUNG = "samsung";
    private static final String MOTOROLA = "motorola";
    private static final String LG = "LGE";
    private static final String NVIDIA = "NVIDIA";
    private static final int LOLLIPOP_MR1 = 22;

    public static ExcludedRefs createAndroidDefaults() {
        ExcludedRefs excluded = new ExcludedRefs();
        excluded.thread("FinalizerWatchdogDaemon");
        excluded.thread("main");
        excluded.thread("LeakCanary-Heap-Dump");
        return excluded;
    }

    public static ExcludedRefs createAppDefaults() {
        ExcludedRefs excluded = AndroidExcludedRefs.createAndroidDefaults();
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21) {
            excluded.instanceField("android.app.ActivityThread$ActivityClientRecord", "nextIdle");
        }
        if (Build.VERSION.SDK_INT <= 19) {
            excluded.instanceField("android.widget.Editor$EasyEditSpanController", "this$0");
            excluded.instanceField("android.widget.Editor$SpanController", "this$0");
        }
        if (Build.VERSION.SDK_INT == 21) {
            excluded.staticField("android.media.session.MediaSessionLegacyHelper", "sInstance");
        }
        if (Build.VERSION.SDK_INT < 22) {
            excluded.staticField("android.text.TextLine", "sCached");
        }
        if (Build.VERSION.SDK_INT < 21) {
            excluded.instanceField("android.os.Message", "obj");
            excluded.instanceField("android.os.Message", "next");
            excluded.instanceField("android.os.Message", "target");
        }
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 22) {
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mNextServedView");
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mServedView");
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mServedInputConnection");
        }
        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 22) {
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mCurRootView");
        }
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT <= 22) {
            excluded.instanceField("android.animation.LayoutTransition$1", "val$parent");
        }
        if (MOTOROLA.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.instanceField("android.app.admin.DevicePolicyManager$SettingsObserver", "this$0");
        }
        if (SAMSUNG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.staticField("com.samsung.android.smartclip.SpenGestureManager", "mContext");
        }
        if (SAMSUNG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21) {
            excluded.staticField("android.sec.clipboard.ClipboardUIManager", "sInstance");
        }
        if (LG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21) {
            excluded.staticField("android.widget.BubblePopupHelper", "sHelper");
        }
        if (SAMSUNG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.staticField("com.android.org.chromium.android_webview.AwResource", "sResources");
        }
        if (NVIDIA.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.instanceField("com.nvidia.ControllerMapper.MapperClient$ServiceClient", "this$0");
        }
        if (SAMSUNG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.staticField("android.widget.TextView", "mLastHoveredView");
        }
        if (MOTOROLA.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 16) {
            excluded.instanceField("android.view.textservice.SpellCheckerSession", "mSpellCheckerSessionListener");
        }
        if (SAMSUNG.equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
            excluded.instanceField("android.os.PersonaManager", "mContext");
        }
        return excluded;
    }

    private AndroidExcludedRefs() {
        throw new AssertionError();
    }
}

