/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.os.Debug;
import android.util.Log;
import com.squareup.leakcanary.HeapDumper;
import java.io.File;
import java.io.IOException;

public final class AndroidHeapDumper
implements HeapDumper {
    private final File heapDumpFile;

    public AndroidHeapDumper(Context context) {
        this.heapDumpFile = new File(context.getFilesDir(), "suspected_leak_heapdump.hprof");
    }

    public File dumpHeap() {
        if (this.heapDumpFile.exists()) {
            Log.d((String)"AndroidHeapDumper", (String)"Could not dump heap, previous analysis still is in progress.");
            return null;
        }
        try {
            Debug.dumpHprofData((String)this.heapDumpFile.getAbsolutePath());
            return this.heapDumpFile;
        }
        catch (IOException e) {
            this.cleanup();
            Log.e((String)"AndroidHeapDumper", (String)"Could not perform heap dump", (Throwable)e);
            return null;
        }
    }

    public void cleanup() {
        if (this.heapDumpFile.exists()) {
            Log.d((String)"AndroidHeapDumper", (String)("Previous analysis did not complete correctly, cleaning: " + this.heapDumpFile));
            this.heapDumpFile.delete();
        }
    }
}

