/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.ActivityManager;
import android.app.Application;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.ActivityRefWatcher;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AndroidDebuggerControl;
import com.squareup.leakcanary.AndroidHeapDumper;
import com.squareup.leakcanary.AndroidWatchExecutor;
import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.DisplayLeakService;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.ServiceHeapDumpListener;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.HeapAnalyzerService;
import java.util.concurrent.Executor;

public final class LeakCanary {
    public static RefWatcher install(Application application) {
        return LeakCanary.install(application, DisplayLeakService.class);
    }

    public static RefWatcher install(Application application, Class<? extends AbstractAnalysisResultService> listenerServiceClass) {
        if (LeakCanary.isInAnalyzerProcess((Context)application)) {
            return RefWatcher.DISABLED;
        }
        LeakCanary.enableDisplayLeakActivity((Context)application);
        ServiceHeapDumpListener heapDumpListener = new ServiceHeapDumpListener((Context)application, listenerServiceClass);
        RefWatcher refWatcher = LeakCanary.androidWatcher(application, heapDumpListener);
        ActivityRefWatcher.installOnIcsPlus(application, refWatcher);
        return refWatcher;
    }

    public static RefWatcher androidWatcher(Application app, HeapDump.Listener heapDumpListener) {
        AndroidDebuggerControl debuggerControl = new AndroidDebuggerControl();
        AndroidHeapDumper heapDumper = new AndroidHeapDumper((Context)app);
        heapDumper.cleanup();
        return new RefWatcher((Executor)new AndroidWatchExecutor(), (DebuggerControl)debuggerControl, GcTrigger.DEFAULT, (HeapDumper)heapDumper, heapDumpListener);
    }

    public static void enableDisplayLeakActivity(Context context) {
        LeakCanary.setEnabled(context, DisplayLeakActivity.class, true);
    }

    public static String leakInfo(Context context, HeapDump heapDump, AnalysisResult result) {
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        String versionName = packageInfo.versionName;
        int versionCode = packageInfo.versionCode;
        String info = "In " + packageName + ":" + versionName + ":" + versionCode + ".\n";
        if (result.leakFound) {
            if (result.excludedLeak) {
                info = info + "* LEAK CAN BE IGNORED.\n";
            }
            info = info + "* " + result.className;
            if (!heapDump.referenceName.equals("")) {
                info = info + " (" + heapDump.referenceName + ")";
            }
            info = info + " has leaked:\n" + result.leakTrace.toString() + "\n";
        } else {
            info = result.failure != null ? info + "* FAILURE:\n" + Log.getStackTraceString((Throwable)result.failure) + "\n" : info + "* NO LEAK FOUND.\n\n";
        }
        info = info + "* Reference Key: " + heapDump.referenceKey + "\n" + "* Device: " + Build.MANUFACTURER + " " + Build.BRAND + " " + Build.MODEL + " " + Build.PRODUCT + "\n" + "* Android Version: " + Build.VERSION.RELEASE + " API: " + Build.VERSION.SDK_INT + "\n" + "* Durations: watch=" + heapDump.watchDurationMs + "ms, gc=" + heapDump.gcDurationMs + "ms, heap dump=" + heapDump.heapDumpDurationMs + "ms, analysis=" + result.analysisDurationMs + "ms" + "\n";
        return info;
    }

    public static boolean isInAnalyzerProcess(Context context) {
        return LeakCanary.isInServiceProcess(context, HeapAnalyzerService.class);
    }

    private static boolean isInServiceProcess(Context context, Class<? extends Service> serviceClass) {
        ServiceInfo serviceInfo;
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4);
        }
        catch (Exception e) {
            Log.e((String)"AndroidUtils", (String)("Could not get package info for " + context.getPackageName()), (Throwable)e);
            return false;
        }
        String mainProcess = packageInfo.applicationInfo.processName;
        ComponentName component = new ComponentName(context, serviceClass);
        try {
            serviceInfo = packageManager.getServiceInfo(component, 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return false;
        }
        if (serviceInfo.processName.equals(mainProcess)) {
            Log.e((String)"AndroidUtils", (String)("Did not expect service " + serviceClass + " to run in main process " + mainProcess));
            return false;
        }
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningAppProcessInfo myProcess = null;
        for (ActivityManager.RunningAppProcessInfo process : activityManager.getRunningAppProcesses()) {
            if (process.pid != myPid) continue;
            myProcess = process;
            break;
        }
        if (myProcess == null) {
            Log.e((String)"AndroidUtils", (String)("Could not find running process for " + myPid));
            return false;
        }
        return myProcess.processName.equals(serviceInfo.processName);
    }

    static void setEnabled(Context context, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(context, componentClass);
        PackageManager packageManager = context.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    private LeakCanary() {
        throw new AssertionError();
    }
}

