/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.Preconditions;
import com.squareup.leakcanary.internal.HeapAnalyzerService;

public final class ServiceHeapDumpListener
implements HeapDump.Listener {
    private final Context context;
    private final Class<? extends AbstractAnalysisResultService> listenerServiceClass;

    public ServiceHeapDumpListener(Context context, Class<? extends AbstractAnalysisResultService> listenerServiceClass) {
        LeakCanary.setEnabled(context, listenerServiceClass, true);
        LeakCanary.setEnabled(context, HeapAnalyzerService.class, true);
        this.listenerServiceClass = (Class)Preconditions.checkNotNull(listenerServiceClass, (String)"listenerServiceClass");
        this.context = ((Context)Preconditions.checkNotNull((Object)context, (String)"context")).getApplicationContext();
    }

    public void analyze(HeapDump heapDump) {
        Preconditions.checkNotNull((Object)heapDump, (String)"heapDump");
        HeapAnalyzerService.runAnalysis(this.context, heapDump, this.listenerServiceClass);
    }
}

