/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;

public final class DisplayLeakConnectorView
extends View {
    static final int LIGHT_GREY = -4539718;
    static final int ROOT_COLOR = -8083771;
    static final int LEAK_COLOR = -5155506;
    private final Paint iconPaint = new Paint();
    private final Paint clearPaint;
    private final Paint rootPaint;
    private final Paint leakPaint;
    private final float strokeSize;
    private Type type;
    private Bitmap cache;

    public DisplayLeakConnectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.iconPaint.setColor(-4539718);
        this.strokeSize = DisplayLeakConnectorView.dpToPixel(4.0f, this.getResources());
        this.iconPaint.setStrokeWidth(this.strokeSize);
        this.iconPaint.setAntiAlias(true);
        this.clearPaint = new Paint();
        this.clearPaint.setColor(0);
        this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.clearPaint.setAntiAlias(true);
        this.rootPaint = new Paint();
        this.rootPaint.setColor(-8083771);
        this.rootPaint.setAntiAlias(true);
        this.rootPaint.setStrokeWidth(this.strokeSize);
        this.leakPaint = new Paint();
        this.leakPaint.setColor(-5155506);
        this.leakPaint.setAntiAlias(true);
        this.type = Type.NODE;
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.cache != null && (this.cache.getWidth() != width || this.cache.getHeight() != height)) {
            this.cache.recycle();
            this.cache = null;
        }
        if (this.cache == null) {
            this.cache = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas cacheCanvas = new Canvas(this.cache);
            float halfWidth = (float)width / 2.0f;
            float halfHeight = (float)height / 2.0f;
            float thirdWidth = width / 3;
            if (this.type == Type.NODE) {
                cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, (float)height, this.iconPaint);
                cacheCanvas.drawCircle(halfWidth, halfHeight, halfWidth, this.iconPaint);
                cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, this.clearPaint);
            } else if (this.type == Type.START) {
                float radiusClear = halfWidth - this.strokeSize / 2.0f;
                cacheCanvas.drawRect(0.0f, 0.0f, (float)width, radiusClear, this.rootPaint);
                cacheCanvas.drawCircle(0.0f, radiusClear, radiusClear, this.clearPaint);
                cacheCanvas.drawCircle((float)width, radiusClear, radiusClear, this.clearPaint);
                cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, halfHeight, this.rootPaint);
                cacheCanvas.drawLine(halfWidth, halfHeight, halfWidth, (float)height, this.iconPaint);
                cacheCanvas.drawCircle(halfWidth, halfHeight, halfWidth, this.iconPaint);
                cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, this.clearPaint);
            } else {
                cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, halfHeight, this.iconPaint);
                cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, this.leakPaint);
            }
        }
        canvas.drawBitmap(this.cache, 0.0f, 0.0f, null);
    }

    public void setType(Type type) {
        if (type != this.type) {
            this.type = type;
            if (this.cache != null) {
                this.cache.recycle();
                this.cache = null;
            }
            this.invalidate();
        }
    }

    static float dpToPixel(float dp, Resources resources) {
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static enum Type {
        START,
        NODE,
        END;

    }
}

