/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;

public final class MoreDetailsView
extends View {
    private final Paint iconPaint;
    private boolean opened;

    public MoreDetailsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        float strokeSize = MoreDetailsView.dpToPixel(2.0f, this.getResources());
        this.iconPaint = new Paint();
        this.iconPaint.setColor(-8083771);
        this.iconPaint.setStrokeWidth(strokeSize);
        this.iconPaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfHeight = height / 2;
        int halfWidth = width / 2;
        if (this.opened) {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, this.iconPaint);
        } else {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, this.iconPaint);
            canvas.drawLine((float)halfWidth, 0.0f, (float)halfWidth, (float)height, this.iconPaint);
        }
    }

    public void setOpened(boolean opened) {
        if (opened != this.opened) {
            this.opened = opened;
            this.invalidate();
        }
    }

    static float dpToPixel(float dp, Resources resources) {
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }
}

