/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.os.Build;
import com.squareup.leakcanary.ExcludedRefs;
import java.lang.ref.PhantomReference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;

public enum AndroidExcludedRefs {
    ACTIVITY_CLIENT_RECORD__NEXT_IDLE(Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.app.ActivityThread$ActivityClientRecord", "nextIdle");
        }
    }
    ,
    SPAN_CONTROLLER(Build.VERSION.SDK_INT <= 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.widget.Editor$EasyEditSpanController", "this$0");
            excluded.instanceField("android.widget.Editor$SpanController", "this$0");
        }
    }
    ,
    MEDIA_SESSION_LEGACY_HELPER__SINSTANCE(Build.VERSION.SDK_INT == 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("android.media.session.MediaSessionLegacyHelper", "sInstance");
        }
    }
    ,
    TEXT_LINE__SCACHED(Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("android.text.TextLine", "sCached");
        }
    }
    ,
    BLOCKING_QUEUE(Build.VERSION.SDK_INT < 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.os.Message", "obj");
            excluded.instanceField("android.os.Message", "next");
            excluded.instanceField("android.os.Message", "target");
        }
    }
    ,
    INPUT_METHOD_MANAGER__SERVED_VIEW(Build.VERSION.SDK_INT >= 15 && Build.VERSION.SDK_INT <= 23){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mNextServedView");
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mServedView");
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mServedInputConnection");
        }
    }
    ,
    INPUT_METHOD_MANAGER__ROOT_VIEW(Build.VERSION.SDK_INT >= 15 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.view.inputmethod.InputMethodManager", "mCurRootView");
        }
    }
    ,
    LAYOUT_TRANSITION(Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.animation.LayoutTransition$1", "val$parent");
        }
    }
    ,
    SPELL_CHECKER_SESSION(Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.view.textservice.SpellCheckerSession$1", "this$0");
        }
    }
    ,
    ACTIVITY_CHOOSE_MODEL(Build.VERSION.SDK_INT > 14 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.support.v7.internal.widget.ActivityChooserModel", "mActivityChoserModelPolicy");
            excluded.instanceField("android.widget.ActivityChooserModel", "mActivityChoserModelPolicy");
        }
    }
    ,
    SPEECH_RECOGNIZER(Build.VERSION.SDK_INT < 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.speech.SpeechRecognizer$InternalListener", "this$0");
        }
    }
    ,
    ACCOUNT_MANAGER(Build.VERSION.SDK_INT > 5 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.accounts.AccountManager$AmsTask$Response", "this$1");
        }
    }
    ,
    MEDIA_SCANNER_CONNECTION(Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.media.MediaScannerConnection", "mContext");
        }
    }
    ,
    USER_MANAGER__SINSTANCE(Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.os.UserManager", "mContext");
        }
    }
    ,
    APP_WIDGET_HOST_CALLBACKS(Build.VERSION.SDK_INT < 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.appwidget.AppWidgetHost$Callbacks", "this$0");
        }
    }
    ,
    DEVICE_POLICY_MANAGER__SETTINGS_OBSERVER("motorola".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            if ("motorola".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19) {
                excluded.instanceField("android.app.admin.DevicePolicyManager$SettingsObserver", "this$0");
            }
        }
    }
    ,
    SPEN_GESTURE_MANAGER("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("com.samsung.android.smartclip.SpenGestureManager", "mContext");
        }
    }
    ,
    CLIPBOARD_UI_MANAGER__SINSTANCE("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.sec.clipboard.ClipboardUIManager", "mContext");
        }
    }
    ,
    BUBBLE_POPUP_HELPER__SHELPER("LGE".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("android.widget.BubblePopupHelper", "sHelper");
        }
    }
    ,
    AW_RESOURCE__SRESOURCES("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("com.android.org.chromium.android_webview.AwResource", "sResources");
        }
    }
    ,
    MAPPER_CLIENT("NVIDIA".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("com.nvidia.ControllerMapper.MapperClient$ServiceClient", "this$0");
        }
    }
    ,
    TEXT_VIEW__MLAST_HOVERED_VIEW("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT <= 21){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("android.widget.TextView", "mLastHoveredView");
        }
    }
    ,
    PERSONA_MANAGER("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.os.PersonaManager", "mContext");
        }
    }
    ,
    RESOURCES__MCONTEXT("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.content.res.Resources", "mContext");
        }
    }
    ,
    VIEW_CONFIGURATION__MCONTEXT("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.view.ViewConfiguration", "mContext");
        }
    }
    ,
    AUDIO_MANAGER__MCONTEXT_STATIC("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT == 19){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.staticField("android.media.AudioManager", "mContext_static");
        }
    }
    ,
    SERVICE_BINDER{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.rootSuperClass("android.os.Binder", true);
        }
    }
    ,
    SOFT_REFERENCES{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.clazz(WeakReference.class.getName(), true);
            excluded.clazz(SoftReference.class.getName(), true);
            excluded.clazz(PhantomReference.class.getName(), true);
            excluded.clazz("java.lang.ref.Finalizer", true);
            excluded.clazz("java.lang.ref.FinalizerReference", true);
        }
    }
    ,
    AUDIO_MANAGER(Build.VERSION.SDK_INT <= 22){

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.media.AudioManager$1", "this$0");
        }
    }
    ,
    FINALIZER_WATCHDOG_DAEMON{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.thread("FinalizerWatchdogDaemon", true);
        }
    }
    ,
    MAIN{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.thread("main", true);
        }
    }
    ,
    LEAK_CANARY_THREAD{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.thread("LeakCanary-Heap-Dump", true);
        }
    }
    ,
    EVENT_RECEIVER__MMESSAGE_QUEUE{

        @Override
        void add(ExcludedRefs.Builder excluded) {
            excluded.instanceField("android.view.Choreographer$FrameDisplayEventReceiver", "mMessageQueue", true);
        }
    };

    final boolean applies;

    public static ExcludedRefs.Builder createAndroidDefaults() {
        return AndroidExcludedRefs.createBuilder(EnumSet.of(SOFT_REFERENCES, new AndroidExcludedRefs[]{FINALIZER_WATCHDOG_DAEMON, MAIN, LEAK_CANARY_THREAD, EVENT_RECEIVER__MMESSAGE_QUEUE, SERVICE_BINDER}));
    }

    public static ExcludedRefs.Builder createAppDefaults() {
        return AndroidExcludedRefs.createBuilder(EnumSet.allOf(AndroidExcludedRefs.class));
    }

    public static ExcludedRefs.Builder createBuilder(EnumSet<AndroidExcludedRefs> refs) {
        ExcludedRefs.Builder excluded = new ExcludedRefs.Builder();
        for (AndroidExcludedRefs ref : refs) {
            if (!ref.applies) continue;
            ref.add(excluded);
        }
        return excluded;
    }

    private AndroidExcludedRefs() {
        this(true);
    }

    private AndroidExcludedRefs(boolean applies) {
        this.applies = applies;
    }

    abstract void add(ExcludedRefs.Builder var1);
}

