/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.widget.Toast;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.FutureResult;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class AndroidHeapDumper
implements HeapDumper {
    private static final String HEAPDUMP_FILE = "suspected_leak_heapdump.hprof";
    final Context context;
    final LeakDirectoryProvider leakDirectoryProvider;
    private final Handler mainHandler;

    public AndroidHeapDumper(Context context, LeakDirectoryProvider leakDirectoryProvider) {
        this.leakDirectoryProvider = leakDirectoryProvider;
        this.context = context.getApplicationContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public File dumpHeap() {
        boolean fileCreated;
        if (!this.leakDirectoryProvider.isLeakStorageWritable()) {
            CanaryLog.d("Could not write to leak storage to dump heap.", new Object[0]);
            this.leakDirectoryProvider.requestWritePermission();
            return NO_DUMP;
        }
        File heapDumpFile = this.getHeapDumpFile();
        try {
            fileCreated = heapDumpFile.createNewFile();
        }
        catch (IOException e) {
            this.cleanup();
            CanaryLog.d(e, "Could not check if heap dump file exists", new Object[0]);
            return NO_DUMP;
        }
        if (!fileCreated) {
            CanaryLog.d("Could not dump heap, previous analysis still is in progress.", new Object[0]);
            return NO_DUMP;
        }
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            CanaryLog.d("Did not dump heap, too much time waiting for Toast.", new Object[0]);
            return NO_DUMP;
        }
        Toast toast = waitingForToast.get();
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            this.cancelToast(toast);
            return heapDumpFile;
        }
        catch (Exception e) {
            this.cleanup();
            CanaryLog.d(e, "Could not perform heap dump", new Object[0]);
            return NO_DUMP;
        }
    }

    public void cleanup() {
        LeakCanaryInternals.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                if (!AndroidHeapDumper.this.leakDirectoryProvider.isLeakStorageWritable()) {
                    CanaryLog.d("Could not attempt cleanup, leak storage not writable.", new Object[0]);
                    return;
                }
                File heapDumpFile = AndroidHeapDumper.this.getHeapDumpFile();
                if (heapDumpFile.exists()) {
                    CanaryLog.d("Previous analysis did not complete correctly, cleaning: %s", heapDumpFile);
                    boolean success = heapDumpFile.delete();
                    if (!success) {
                        CanaryLog.d("Could not delete file %s", heapDumpFile.getPath());
                    }
                }
            }
        });
    }

    File getHeapDumpFile() {
        return new File(this.leakDirectoryProvider.leakDirectory(), HEAPDUMP_FILE);
    }

    private void showToast(final FutureResult<Toast> waitingForToast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                final Toast toast = new Toast(AndroidHeapDumper.this.context);
                toast.setGravity(16, 0, 0);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.this.context);
                toast.setView(inflater.inflate(R.layout.leak_canary_heap_dump_toast, null));
                toast.show();
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        waitingForToast.set(toast);
                        return false;
                    }
                });
            }
        });
    }

    private void cancelToast(final Toast toast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                toast.cancel();
            }
        });
    }
}

