/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import java.util.concurrent.Executor;

public final class AndroidWatchExecutor
implements Executor {
    static final String LEAK_CANARY_THREAD_NAME = "LeakCanary-Heap-Dump";
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    final Handler backgroundHandler;
    final long delayMillis;

    public AndroidWatchExecutor(int delayMillis) {
        HandlerThread handlerThread = new HandlerThread(LEAK_CANARY_THREAD_NAME);
        handlerThread.start();
        this.backgroundHandler = new Handler(handlerThread.getLooper());
        this.delayMillis = delayMillis;
    }

    @Override
    public void execute(final Runnable command) {
        if (this.isOnMainThread()) {
            this.executeDelayedAfterIdleUnsafe(command);
        } else {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidWatchExecutor.this.executeDelayedAfterIdleUnsafe(command);
                }
            });
        }
    }

    private boolean isOnMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    void executeDelayedAfterIdleUnsafe(final Runnable runnable) {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                AndroidWatchExecutor.this.backgroundHandler.postDelayed(runnable, AndroidWatchExecutor.this.delayMillis);
                return false;
            }
        });
    }
}

