/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.squareup.leakcanary.internal.LeakCanaryUi;

public final class DisplayLeakConnectorView
extends View {
    private static final Paint iconPaint = new Paint(1);
    private static final Paint rootPaint = new Paint(1);
    private static final Paint leakPaint = new Paint(1);
    private static final Paint clearPaint = new Paint(1);
    private Type type = Type.NODE;
    private Bitmap cache;

    public DisplayLeakConnectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.cache != null && (this.cache.getWidth() != width || this.cache.getHeight() != height)) {
            this.cache.recycle();
            this.cache = null;
        }
        if (this.cache == null) {
            this.cache = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas cacheCanvas = new Canvas(this.cache);
            float halfWidth = (float)width / 2.0f;
            float halfHeight = (float)height / 2.0f;
            float thirdWidth = (float)width / 3.0f;
            float strokeSize = LeakCanaryUi.dpToPixel(4.0f, this.getResources());
            iconPaint.setStrokeWidth(strokeSize);
            rootPaint.setStrokeWidth(strokeSize);
            switch (this.type) {
                case NODE: {
                    cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, (float)height, iconPaint);
                    cacheCanvas.drawCircle(halfWidth, halfHeight, halfWidth, iconPaint);
                    cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, clearPaint);
                    break;
                }
                case START: {
                    float radiusClear = halfWidth - strokeSize / 2.0f;
                    cacheCanvas.drawRect(0.0f, 0.0f, (float)width, radiusClear, rootPaint);
                    cacheCanvas.drawCircle(0.0f, radiusClear, radiusClear, clearPaint);
                    cacheCanvas.drawCircle((float)width, radiusClear, radiusClear, clearPaint);
                    cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, halfHeight, rootPaint);
                    cacheCanvas.drawLine(halfWidth, halfHeight, halfWidth, (float)height, iconPaint);
                    cacheCanvas.drawCircle(halfWidth, halfHeight, halfWidth, iconPaint);
                    cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, clearPaint);
                    break;
                }
                default: {
                    cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, halfHeight, iconPaint);
                    cacheCanvas.drawCircle(halfWidth, halfHeight, thirdWidth, leakPaint);
                }
            }
        }
        canvas.drawBitmap(this.cache, 0.0f, 0.0f, null);
    }

    public void setType(Type type) {
        if (type != this.type) {
            this.type = type;
            if (this.cache != null) {
                this.cache.recycle();
                this.cache = null;
            }
            this.invalidate();
        }
    }

    static {
        iconPaint.setColor(-4539718);
        rootPaint.setColor(-8083771);
        leakPaint.setColor(-5155506);
        clearPaint.setColor(0);
        clearPaint.setXfermode((Xfermode)LeakCanaryUi.CLEAR_XFER_MODE);
    }

    public static enum Type {
        START,
        NODE,
        END;

    }
}

