/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Process;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.LeakCanarySingleThreadFactory;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class LeakCanaryInternals {
    public static final int LOLLIPOP_MR1 = 22;
    public static final String SAMSUNG = "samsung";
    public static final String MOTOROLA = "motorola";
    public static final String LG = "LGE";
    public static final String NVIDIA = "NVIDIA";
    private static final Executor fileIoExecutor = LeakCanaryInternals.newSingleThreadExecutor("File-IO");

    public static void executeOnFileIoThread(Runnable runnable) {
        fileIoExecutor.execute(runnable);
    }

    public static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    public static void setEnabled(Context context, final Class<?> componentClass, final boolean enabled) {
        final Context appContext = context.getApplicationContext();
        LeakCanaryInternals.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                LeakCanaryInternals.setEnabledBlocking(appContext, componentClass, enabled);
            }
        });
    }

    public static void setEnabledBlocking(Context appContext, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(appContext, componentClass);
        PackageManager packageManager = appContext.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    public static boolean isInServiceProcess(Context context, Class<? extends Service> serviceClass) {
        ServiceInfo serviceInfo;
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4);
        }
        catch (Exception e) {
            CanaryLog.d(e, "Could not get package info for %s", context.getPackageName());
            return false;
        }
        String mainProcess = packageInfo.applicationInfo.processName;
        ComponentName component = new ComponentName(context, serviceClass);
        try {
            serviceInfo = packageManager.getServiceInfo(component, 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return false;
        }
        if (serviceInfo.processName.equals(mainProcess)) {
            CanaryLog.d("Did not expect service %s to run in main process %s", serviceClass, mainProcess);
            return false;
        }
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningAppProcessInfo myProcess = null;
        for (ActivityManager.RunningAppProcessInfo process : activityManager.getRunningAppProcesses()) {
            if (process.pid != myPid) continue;
            myProcess = process;
            break;
        }
        if (myProcess == null) {
            CanaryLog.d("Could not find running process for %d", myPid);
            return false;
        }
        return myProcess.processName.equals(serviceInfo.processName);
    }

    @TargetApi(value=11)
    public static void showNotification(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent pendingIntent) {
        Notification notification;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT < 11) {
            notification = new Notification();
            notification.icon = R.drawable.leak_canary_notification;
            notification.when = System.currentTimeMillis();
            notification.flags |= 0x10;
            try {
                Method method = Notification.class.getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                method.invoke((Object)notification, context, contentTitle, contentText, pendingIntent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            Notification.Builder builder = new Notification.Builder(context).setSmallIcon(R.drawable.leak_canary_notification).setWhen(System.currentTimeMillis()).setContentTitle(contentTitle).setContentText(contentText).setAutoCancel(true).setContentIntent(pendingIntent);
            notification = Build.VERSION.SDK_INT < 16 ? builder.getNotification() : builder.build();
        }
        notificationManager.notify(-558907665, notification);
    }

    public static Executor newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new LeakCanarySingleThreadFactory(threadName));
    }

    private LeakCanaryInternals() {
        throw new AssertionError();
    }
}

