/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import com.squareup.leakcanary.internal.RequestStoragePermissionActivity;
import java.io.File;

public final class DefaultLeakDirectoryProvider
implements LeakDirectoryProvider {
    private final Context context;

    public DefaultLeakDirectoryProvider(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public File leakDirectory() {
        File downloadsDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        File directory = new File(downloadsDirectory, "leakcanary-" + this.context.getPackageName());
        boolean success = directory.mkdirs();
        if (!success && !directory.exists()) {
            throw new UnsupportedOperationException("Could not create leak directory " + directory.getPath());
        }
        return directory;
    }

    @Override
    public void requestWritePermission() {
        if (this.hasStoragePermission()) {
            return;
        }
        PendingIntent pendingIntent = RequestStoragePermissionActivity.createPendingIntent(this.context);
        String contentTitle = this.context.getString(R.string.leak_canary_permission_notification_title);
        String packageName = this.context.getPackageName();
        String contentText = this.context.getString(R.string.leak_canary_permission_notification_text, new Object[]{packageName});
        LeakCanaryInternals.showNotification(this.context, contentTitle, contentText, pendingIntent);
    }

    @Override
    public boolean isLeakStorageWritable() {
        if (!this.hasStoragePermission()) {
            return false;
        }
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    @TargetApi(value=23)
    private boolean hasStoragePermission() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return this.context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }
}

