/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.text.format.Formatter;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class DisplayLeakService
extends AbstractAnalysisResultService {
    @Override
    protected final void onHeapAnalyzed(HeapDump heapDump, AnalysisResult result) {
        PendingIntent pendingIntent;
        String contentText;
        String contentTitle;
        boolean shouldSaveResult;
        String leakInfo = LeakCanary.leakInfo((Context)this, heapDump, result, true);
        CanaryLog.d(leakInfo, new Object[0]);
        boolean resultSaved = false;
        boolean bl = shouldSaveResult = result.leakFound || result.failure != null;
        if (shouldSaveResult) {
            heapDump = this.renameHeapdump(heapDump);
            resultSaved = this.saveResult(heapDump, result);
        }
        if (!shouldSaveResult) {
            contentTitle = this.getString(R.string.leak_canary_no_leak_title);
            contentText = this.getString(R.string.leak_canary_no_leak_text);
            pendingIntent = null;
        } else if (resultSaved) {
            pendingIntent = DisplayLeakActivity.createPendingIntent((Context)this, heapDump.referenceKey);
            if (result.failure == null) {
                String size = Formatter.formatShortFileSize((Context)this, (long)result.retainedHeapSize);
                String className = LeakCanaryInternals.classSimpleName(result.className);
                contentTitle = result.excludedLeak ? this.getString(R.string.leak_canary_leak_excluded, new Object[]{className, size}) : this.getString(R.string.leak_canary_class_has_leaked, new Object[]{className, size});
            } else {
                contentTitle = this.getString(R.string.leak_canary_analysis_failed);
            }
            contentText = this.getString(R.string.leak_canary_notification_message);
        } else {
            contentTitle = this.getString(R.string.leak_canary_could_not_save_title);
            contentText = this.getString(R.string.leak_canary_could_not_save_text);
            pendingIntent = null;
        }
        LeakCanaryInternals.showNotification((Context)this, contentTitle, contentText, pendingIntent);
        this.afterDefaultHandling(heapDump, result, leakInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveResult(HeapDump heapDump, AnalysisResult result) {
        File resultFile = new File(heapDump.heapDumpFile.getParentFile(), heapDump.heapDumpFile.getName() + ".result");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resultFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(heapDump);
            oos.writeObject(result);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CanaryLog.d(e, "Could not save leak analysis result to disk.", new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private HeapDump renameHeapdump(HeapDump heapDump) {
        String fileName = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS'.hprof'", Locale.US).format(new Date());
        File newFile = new File(heapDump.heapDumpFile.getParent(), fileName);
        boolean renamed = heapDump.heapDumpFile.renameTo(newFile);
        if (!renamed) {
            CanaryLog.d("Could not rename heap dump file %s to %s", heapDump.heapDumpFile.getPath(), newFile.getPath());
        }
        heapDump = new HeapDump(newFile, heapDump.referenceKey, heapDump.referenceName, heapDump.excludedRefs, heapDump.watchDurationMs, heapDump.gcDurationMs, heapDump.heapDumpDurationMs);
        Resources resources = this.getResources();
        int maxStoredHeapDumps = Math.max(resources.getInteger(R.integer.leak_canary_max_stored_leaks), 1);
        File[] hprofFiles = heapDump.heapDumpFile.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".hprof");
            }
        });
        if (hprofFiles.length > maxStoredHeapDumps) {
            Arrays.sort(hprofFiles, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    return Long.valueOf(lhs.lastModified()).compareTo(rhs.lastModified());
                }
            });
            boolean deleted = hprofFiles[0].delete();
            if (!deleted) {
                CanaryLog.d("Could not delete old hprof file %s", hprofFiles[0].getPath());
            }
        }
        return heapDump;
    }

    protected void afterDefaultHandling(HeapDump heapDump, AnalysisResult result, String leakInfo) {
    }
}

