/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.text.format.Formatter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.DefaultLeakDirectoryProvider;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakAdapter;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;

@TargetApi(value=11)
public final class DisplayLeakActivity
extends Activity {
    private static LeakDirectoryProvider leakDirectoryProvider = null;
    private static final String SHOW_LEAK_EXTRA = "show_latest";
    List<Leak> leaks;
    String visibleLeakRefKey;
    private ListView listView;
    private TextView failureView;
    private Button actionButton;

    public static PendingIntent createPendingIntent(Context context) {
        return DisplayLeakActivity.createPendingIntent(context, null);
    }

    public static PendingIntent createPendingIntent(Context context, String referenceKey) {
        Intent intent = new Intent(context, DisplayLeakActivity.class);
        intent.putExtra(SHOW_LEAK_EXTRA, referenceKey);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }

    public static void setLeakDirectoryProvider(LeakDirectoryProvider leakDirectoryProvider) {
        DisplayLeakActivity.leakDirectoryProvider = leakDirectoryProvider;
    }

    static File getLeakDirectory(Context context) {
        LeakDirectoryProvider leakDirectoryProvider = DisplayLeakActivity.leakDirectoryProvider;
        if (leakDirectoryProvider != null) {
            return leakDirectoryProvider.leakDirectory();
        }
        return new DefaultLeakDirectoryProvider(context).leakDirectory();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.visibleLeakRefKey = savedInstanceState.getString("visibleLeakRefKey");
        } else {
            Intent intent = this.getIntent();
            if (intent.hasExtra(SHOW_LEAK_EXTRA)) {
                this.visibleLeakRefKey = intent.getStringExtra(SHOW_LEAK_EXTRA);
            }
        }
        this.leaks = (List)this.getLastNonConfigurationInstance();
        this.setContentView(R.layout.leak_canary_display_leak);
        this.listView = (ListView)this.findViewById(R.id.__leak_canary_display_leak_list);
        this.failureView = (TextView)this.findViewById(R.id.__leak_canary_display_leak_failure);
        this.actionButton = (Button)this.findViewById(R.id.__leak_canary_action);
        this.updateUi();
    }

    public Object onRetainNonConfigurationInstance() {
        return this.leaks;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("visibleLeakRefKey", this.visibleLeakRefKey);
    }

    protected void onResume() {
        super.onResume();
        LoadLeaks.load(this);
    }

    public void setTheme(int resid) {
        if (resid != R.style.leak_canary_LeakCanary_Base) {
            return;
        }
        super.setTheme(resid);
    }

    protected void onDestroy() {
        super.onDestroy();
        LoadLeaks.forgetActivity();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        Leak visibleLeak = this.getVisibleLeak();
        if (visibleLeak != null) {
            menu.add(R.string.leak_canary_share_leak).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DisplayLeakActivity.this.shareLeak();
                    return true;
                }
            });
            if (visibleLeak.heapDump.heapDumpFile.exists()) {
                menu.add(R.string.leak_canary_share_heap_dump).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem item) {
                        DisplayLeakActivity.this.shareHeapDump();
                        return true;
                    }
                });
            }
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.visibleLeakRefKey = null;
            this.updateUi();
        }
        return true;
    }

    public void onBackPressed() {
        if (this.visibleLeakRefKey != null) {
            this.visibleLeakRefKey = null;
            this.updateUi();
        } else {
            super.onBackPressed();
        }
    }

    void shareLeak() {
        Leak visibleLeak = this.getVisibleLeak();
        String leakInfo = LeakCanary.leakInfo((Context)this, visibleLeak.heapDump, visibleLeak.result, true);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", leakInfo);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.leak_canary_share_with)));
    }

    void shareHeapDump() {
        Leak visibleLeak = this.getVisibleLeak();
        File heapDumpFile = visibleLeak.heapDump.heapDumpFile;
        heapDumpFile.setReadable(true, false);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)heapDumpFile));
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.leak_canary_share_with)));
    }

    void deleteVisibleLeak() {
        boolean heapDumpDeleted;
        Leak visibleLeak = this.getVisibleLeak();
        File heapDumpFile = visibleLeak.heapDump.heapDumpFile;
        File resultFile = visibleLeak.resultFile;
        boolean resultDeleted = resultFile.delete();
        if (!resultDeleted) {
            CanaryLog.d("Could not delete result file %s", resultFile.getPath());
        }
        if (!(heapDumpDeleted = heapDumpFile.delete())) {
            CanaryLog.d("Could not delete heap dump file %s", heapDumpFile.getPath());
        }
        this.visibleLeakRefKey = null;
        this.leaks.remove(visibleLeak);
        this.updateUi();
    }

    void deleteAllLeaks() {
        File leakDirectory = DisplayLeakActivity.getLeakDirectory((Context)this);
        File[] files = leakDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean deleted = file.delete();
                if (deleted) continue;
                CanaryLog.d("Could not delete file %s", file.getPath());
            }
        }
        this.leaks = Collections.emptyList();
        this.updateUi();
    }

    void updateUi() {
        Leak visibleLeak;
        if (this.leaks == null) {
            this.setTitle("Loading leaks...");
            return;
        }
        if (this.leaks.isEmpty()) {
            this.visibleLeakRefKey = null;
        }
        if ((visibleLeak = this.getVisibleLeak()) == null) {
            this.visibleLeakRefKey = null;
        }
        ListAdapter listAdapter = this.listView.getAdapter();
        this.listView.setVisibility(0);
        this.failureView.setVisibility(8);
        if (visibleLeak != null) {
            AnalysisResult result = visibleLeak.result;
            if (result.failure != null) {
                this.listView.setVisibility(8);
                this.failureView.setVisibility(0);
                this.failureView.setText((CharSequence)(this.getString(R.string.leak_canary_failure_report) + Log.getStackTraceString((Throwable)result.failure)));
                this.setTitle(R.string.leak_canary_analysis_failed);
                this.invalidateOptionsMenu();
                this.getActionBar().setDisplayHomeAsUpEnabled(true);
                this.actionButton.setVisibility(0);
                this.actionButton.setText(R.string.leak_canary_delete);
                this.actionButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DisplayLeakActivity.this.deleteVisibleLeak();
                    }
                });
                this.listView.setAdapter(null);
            } else {
                DisplayLeakAdapter adapter;
                if (listAdapter instanceof DisplayLeakAdapter) {
                    adapter = (DisplayLeakAdapter)listAdapter;
                } else {
                    adapter = new DisplayLeakAdapter();
                    this.listView.setAdapter((ListAdapter)adapter);
                    this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            adapter.toggleRow(position);
                        }
                    });
                    this.invalidateOptionsMenu();
                    this.getActionBar().setDisplayHomeAsUpEnabled(true);
                    this.actionButton.setVisibility(0);
                    this.actionButton.setText(R.string.leak_canary_delete);
                    this.actionButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            DisplayLeakActivity.this.deleteVisibleLeak();
                        }
                    });
                }
                HeapDump heapDump = visibleLeak.heapDump;
                adapter.update(result.leakTrace, heapDump.referenceKey, heapDump.referenceName);
                String size = Formatter.formatShortFileSize((Context)this, (long)result.retainedHeapSize);
                String className = DisplayLeakActivity.classSimpleName(result.className);
                this.setTitle(this.getString(R.string.leak_canary_class_has_leaked, new Object[]{className, size}));
            }
        } else {
            if (listAdapter instanceof LeakListAdapter) {
                ((LeakListAdapter)listAdapter).notifyDataSetChanged();
            } else {
                LeakListAdapter adapter = new LeakListAdapter();
                this.listView.setAdapter((ListAdapter)adapter);
                this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        DisplayLeakActivity.this.visibleLeakRefKey = DisplayLeakActivity.this.leaks.get((int)position).heapDump.referenceKey;
                        DisplayLeakActivity.this.updateUi();
                    }
                });
                this.invalidateOptionsMenu();
                this.setTitle(this.getString(R.string.leak_canary_leak_list_title, new Object[]{this.getPackageName()}));
                this.getActionBar().setDisplayHomeAsUpEnabled(false);
                this.actionButton.setText(R.string.leak_canary_delete_all);
                this.actionButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DisplayLeakActivity.this.deleteAllLeaks();
                    }
                });
            }
            this.actionButton.setVisibility(this.leaks.size() == 0 ? 8 : 0);
        }
    }

    Leak getVisibleLeak() {
        if (this.leaks == null) {
            return null;
        }
        for (Leak leak : this.leaks) {
            if (!leak.heapDump.referenceKey.equals(this.visibleLeakRefKey)) continue;
            return leak;
        }
        return null;
    }

    static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    static class LoadLeaks
    implements Runnable {
        static final List<LoadLeaks> inFlight = new ArrayList<LoadLeaks>();
        static final Executor backgroundExecutor = LeakCanaryInternals.newSingleThreadExecutor("LoadLeaks");
        DisplayLeakActivity activityOrNull;
        private final File leakDirectory;
        private final Handler mainHandler;

        static void load(DisplayLeakActivity activity) {
            LoadLeaks loadLeaks = new LoadLeaks(activity);
            inFlight.add(loadLeaks);
            backgroundExecutor.execute(loadLeaks);
        }

        static void forgetActivity() {
            for (LoadLeaks loadLeaks : inFlight) {
                loadLeaks.activityOrNull = null;
            }
            inFlight.clear();
        }

        LoadLeaks(DisplayLeakActivity activity) {
            this.activityOrNull = activity;
            this.leakDirectory = DisplayLeakActivity.getLeakDirectory((Context)activity);
            this.mainHandler = new Handler(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final ArrayList<Leak> leaks = new ArrayList<Leak>();
            File[] files = this.leakDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".result");
                }
            });
            if (files != null) {
                for (File resultFile : files) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(resultFile);
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        HeapDump heapDump = (HeapDump)ois.readObject();
                        AnalysisResult result = (AnalysisResult)ois.readObject();
                        leaks.add(new Leak(heapDump, result, resultFile));
                    }
                    catch (IOException | ClassNotFoundException e) {
                        boolean deleted = resultFile.delete();
                        if (deleted) {
                            CanaryLog.d(e, "Could not read result file %s, deleted it.", resultFile);
                            continue;
                        }
                        CanaryLog.d(e, "Could not read result file %s, could not delete it either.", resultFile);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                Collections.sort(leaks, new Comparator<Leak>(){

                    @Override
                    public int compare(Leak lhs, Leak rhs) {
                        return Long.valueOf(rhs.resultFile.lastModified()).compareTo(lhs.resultFile.lastModified());
                    }
                });
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    inFlight.remove(LoadLeaks.this);
                    if (LoadLeaks.this.activityOrNull != null) {
                        LoadLeaks.this.activityOrNull.leaks = leaks;
                        LoadLeaks.this.activityOrNull.updateUi();
                    }
                }
            });
        }
    }

    static class Leak {
        final HeapDump heapDump;
        final AnalysisResult result;
        final File resultFile;

        Leak(HeapDump heapDump, AnalysisResult result, File resultFile) {
            this.heapDump = heapDump;
            this.result = result;
            this.resultFile = resultFile;
        }
    }

    class LeakListAdapter
    extends BaseAdapter {
        LeakListAdapter() {
        }

        public int getCount() {
            return DisplayLeakActivity.this.leaks.size();
        }

        public Leak getItem(int position) {
            return DisplayLeakActivity.this.leaks.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            String title;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)DisplayLeakActivity.this).inflate(R.layout.leak_canary_leak_row, parent, false);
            }
            TextView titleView = (TextView)convertView.findViewById(R.id.__leak_canary_row_text);
            TextView timeView = (TextView)convertView.findViewById(R.id.__leak_canary_row_time);
            Leak leak = this.getItem(position);
            String index = DisplayLeakActivity.this.leaks.size() - position + ". ";
            if (leak.result.failure == null) {
                String className = DisplayLeakActivity.classSimpleName(leak.result.className);
                String size = Formatter.formatShortFileSize((Context)DisplayLeakActivity.this, (long)leak.result.retainedHeapSize);
                title = DisplayLeakActivity.this.getString(R.string.leak_canary_class_has_leaked, new Object[]{className, size});
                if (leak.result.excludedLeak) {
                    title = DisplayLeakActivity.this.getString(R.string.leak_canary_excluded_row, new Object[]{title});
                }
                title = index + title;
            } else {
                title = index + leak.result.failure.getClass().getSimpleName() + " " + leak.result.failure.getMessage();
            }
            titleView.setText((CharSequence)title);
            String time = DateUtils.formatDateTime((Context)DisplayLeakActivity.this, (long)leak.resultFile.lastModified(), (int)17);
            timeView.setText((CharSequence)time);
            return convertView;
        }
    }
}

