/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.LeakCanaryInternals;

@TargetApi(value=23)
public class RequestStoragePermissionActivity
extends Activity {
    public static PendingIntent createPendingIntent(Context context) {
        LeakCanaryInternals.setEnabledBlocking(context, RequestStoragePermissionActivity.class, true);
        Intent intent = new Intent(context, RequestStoragePermissionActivity.class);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (this.hasStoragePermission()) {
                this.finish();
                return;
            }
            String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
            this.requestPermissions(permissions, 42);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (!this.hasStoragePermission()) {
            Toast.makeText((Context)this.getApplication(), (int)R.string.leak_canary_permission_not_granted, (int)1).show();
        }
        this.finish();
    }

    private boolean hasStoragePermission() {
        return this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }
}

