/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.widget.Toast;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.FutureResult;
import java.io.File;
import java.util.concurrent.TimeUnit;

public final class AndroidHeapDumper
implements HeapDumper {
    private final Context context;
    private final LeakDirectoryProvider leakDirectoryProvider;
    private final Handler mainHandler;

    public AndroidHeapDumper(Context context, LeakDirectoryProvider leakDirectoryProvider) {
        this.leakDirectoryProvider = leakDirectoryProvider;
        this.context = context.getApplicationContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public File dumpHeap() {
        File heapDumpFile = this.leakDirectoryProvider.newHeapDumpFile();
        if (heapDumpFile == RETRY_LATER) {
            return RETRY_LATER;
        }
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            CanaryLog.d("Did not dump heap, too much time waiting for Toast.", new Object[0]);
            return RETRY_LATER;
        }
        Toast toast = waitingForToast.get();
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            this.cancelToast(toast);
            return heapDumpFile;
        }
        catch (Exception e) {
            CanaryLog.d(e, "Could not dump heap", new Object[0]);
            return RETRY_LATER;
        }
    }

    private void showToast(final FutureResult<Toast> waitingForToast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                final Toast toast = new Toast(AndroidHeapDumper.this.context);
                toast.setGravity(16, 0, 0);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.this.context);
                toast.setView(inflater.inflate(R.layout.leak_canary_heap_dump_toast, null));
                toast.show();
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        waitingForToast.set(toast);
                        return false;
                    }
                });
            }
        });
    }

    private void cancelToast(final Toast toast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                toast.cancel();
            }
        });
    }
}

