/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Application;
import android.content.Context;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.ActivityRefWatcher;
import com.squareup.leakcanary.AndroidDebuggerControl;
import com.squareup.leakcanary.AndroidExcludedRefs;
import com.squareup.leakcanary.AndroidHeapDumper;
import com.squareup.leakcanary.AndroidWatchExecutor;
import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.DefaultLeakDirectoryProvider;
import com.squareup.leakcanary.DisplayLeakService;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.RefWatcherBuilder;
import com.squareup.leakcanary.ServiceHeapDumpListener;
import com.squareup.leakcanary.WatchExecutor;
import java.util.concurrent.TimeUnit;

public final class AndroidRefWatcherBuilder
extends RefWatcherBuilder<AndroidRefWatcherBuilder> {
    private static final long DEFAULT_WATCH_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private final Context context;

    AndroidRefWatcherBuilder(Context context) {
        this.context = context.getApplicationContext();
    }

    public AndroidRefWatcherBuilder listenerServiceClass(Class<? extends AbstractAnalysisResultService> listenerServiceClass) {
        return (AndroidRefWatcherBuilder)this.heapDumpListener(new ServiceHeapDumpListener(this.context, listenerServiceClass));
    }

    public AndroidRefWatcherBuilder watchDelay(long delay, TimeUnit unit) {
        return (AndroidRefWatcherBuilder)this.watchExecutor(new AndroidWatchExecutor(unit.toMillis(delay)));
    }

    public AndroidRefWatcherBuilder maxStoredHeapDumps(int maxStoredHeapDumps) {
        DefaultLeakDirectoryProvider leakDirectoryProvider = new DefaultLeakDirectoryProvider(this.context, maxStoredHeapDumps);
        LeakCanary.setDisplayLeakActivityDirectoryProvider(leakDirectoryProvider);
        return (AndroidRefWatcherBuilder)this.heapDumper(new AndroidHeapDumper(this.context, leakDirectoryProvider));
    }

    public RefWatcher buildAndInstall() {
        RefWatcher refWatcher = this.build();
        if (refWatcher != RefWatcher.DISABLED) {
            LeakCanary.enableDisplayLeakActivity(this.context);
            ActivityRefWatcher.installOnIcsPlus((Application)this.context, refWatcher);
        }
        return refWatcher;
    }

    protected boolean isDisabled() {
        return LeakCanary.isInAnalyzerProcess(this.context);
    }

    protected HeapDumper defaultHeapDumper() {
        DefaultLeakDirectoryProvider leakDirectoryProvider = new DefaultLeakDirectoryProvider(this.context);
        return new AndroidHeapDumper(this.context, leakDirectoryProvider);
    }

    protected DebuggerControl defaultDebuggerControl() {
        return new AndroidDebuggerControl();
    }

    protected HeapDump.Listener defaultHeapDumpListener() {
        return new ServiceHeapDumpListener(this.context, DisplayLeakService.class);
    }

    protected ExcludedRefs defaultExcludedRefs() {
        return AndroidExcludedRefs.createAppDefaults().build();
    }

    protected WatchExecutor defaultWatchExecutor() {
        return new AndroidWatchExecutor(DEFAULT_WATCH_DELAY_MILLIS);
    }
}

