/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.ContextCompat;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.ForegroundService;
import java.io.Serializable;

public abstract class AbstractAnalysisResultService
extends ForegroundService {
    private static final String HEAP_DUMP_EXTRA = "heap_dump_extra";
    private static final String RESULT_EXTRA = "result_extra";

    public static void sendResultToListener(Context context, String listenerServiceClassName, HeapDump heapDump, AnalysisResult result) {
        Class<?> listenerServiceClass;
        try {
            listenerServiceClass = Class.forName(listenerServiceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Intent intent = new Intent(context, listenerServiceClass);
        intent.putExtra(HEAP_DUMP_EXTRA, (Serializable)heapDump);
        intent.putExtra(RESULT_EXTRA, (Serializable)result);
        ContextCompat.startForegroundService((Context)context, (Intent)intent);
    }

    public AbstractAnalysisResultService() {
        super(AbstractAnalysisResultService.class.getName(), R.string.leak_canary_notification_reporting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onHandleIntentInForeground(Intent intent) {
        HeapDump heapDump = (HeapDump)intent.getSerializableExtra(HEAP_DUMP_EXTRA);
        AnalysisResult result = (AnalysisResult)intent.getSerializableExtra(RESULT_EXTRA);
        try {
            this.onHeapAnalyzed(heapDump, result);
        }
        finally {
            heapDump.heapDumpFile.delete();
        }
    }

    protected abstract void onHeapAnalyzed(HeapDump var1, AnalysisResult var2);
}

