/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.app.IntentService;
import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.LeakCanaryInternals;

public abstract class ForegroundService
extends IntentService {
    private final int notificationContentTitleResId;
    private final int notificationId;

    public ForegroundService(String name, int notificationContentTitleResId) {
        super(name);
        this.notificationContentTitleResId = notificationContentTitleResId;
        this.notificationId = (int)SystemClock.uptimeMillis();
    }

    public void onCreate() {
        super.onCreate();
        this.showForegroundNotification(100, 0, true, this.getString(R.string.leak_canary_notification_foreground_text));
    }

    protected void showForegroundNotification(int max, int progress, boolean indeterminate, String contentText) {
        Notification.Builder builder = new Notification.Builder((Context)this).setContentTitle((CharSequence)this.getString(this.notificationContentTitleResId)).setContentText((CharSequence)contentText).setProgress(max, progress, indeterminate);
        Notification notification = LeakCanaryInternals.buildNotification((Context)this, builder);
        this.startForeground(this.notificationId, notification);
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        this.onHandleIntentInForeground(intent);
    }

    protected abstract void onHandleIntentInForeground(@Nullable Intent var1);

    public void onDestroy() {
        super.onDestroy();
        this.stopForeground(true);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

