/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AnalyzedHeap;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.ForegroundService;
import java.io.File;

public abstract class AbstractAnalysisResultService
extends ForegroundService {
    private static final String ANALYZED_HEAP_PATH_EXTRA = "analyzed_heap_path_extra";

    public static void sendResultToListener(@NonNull Context context, @NonNull String listenerServiceClassName, @NonNull HeapDump heapDump, @NonNull AnalysisResult result) {
        Class<?> listenerServiceClass;
        try {
            listenerServiceClass = Class.forName(listenerServiceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Intent intent = new Intent(context, listenerServiceClass);
        File analyzedHeapFile = AnalyzedHeap.save(heapDump, result);
        if (analyzedHeapFile != null) {
            intent.putExtra(ANALYZED_HEAP_PATH_EXTRA, analyzedHeapFile.getAbsolutePath());
        }
        ContextCompat.startForegroundService((Context)context, (Intent)intent);
    }

    public AbstractAnalysisResultService() {
        super(AbstractAnalysisResultService.class.getName(), R.string.leak_canary_notification_reporting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onHandleIntentInForeground(@Nullable Intent intent) {
        if (intent == null) {
            CanaryLog.d("AbstractAnalysisResultService received a null intent, ignoring.", new Object[0]);
            return;
        }
        if (!intent.hasExtra(ANALYZED_HEAP_PATH_EXTRA)) {
            this.onAnalysisResultFailure(this.getString(R.string.leak_canary_result_failure_no_disk_space));
            return;
        }
        File analyzedHeapFile = new File(intent.getStringExtra(ANALYZED_HEAP_PATH_EXTRA));
        AnalyzedHeap analyzedHeap = AnalyzedHeap.load(analyzedHeapFile);
        if (analyzedHeap == null) {
            this.onAnalysisResultFailure(this.getString(R.string.leak_canary_result_failure_no_file));
            return;
        }
        try {
            this.onHeapAnalyzed(analyzedHeap);
        }
        finally {
            analyzedHeap.heapDump.heapDumpFile.delete();
            analyzedHeap.selfFile.delete();
        }
    }

    protected void onHeapAnalyzed(@NonNull AnalyzedHeap analyzedHeap) {
        this.onHeapAnalyzed(analyzedHeap.heapDump, analyzedHeap.result);
    }

    @Deprecated
    protected void onHeapAnalyzed(@NonNull HeapDump heapDump, @NonNull AnalysisResult result) {
    }

    protected void onAnalysisResultFailure(String failureMessage) {
        CanaryLog.d(failureMessage, new Object[0]);
    }
}

