/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class AnalyzedHeap {
    @NonNull
    public final HeapDump heapDump;
    @NonNull
    public final AnalysisResult result;
    @NonNull
    public final File selfFile;
    public final boolean heapDumpFileExists;
    public final long selfLastModified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File save(@NonNull HeapDump heapDump, @NonNull AnalysisResult result) {
        File analyzedHeapfile = new File(heapDump.heapDumpFile.getParentFile(), heapDump.heapDumpFile.getName() + ".result");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(analyzedHeapfile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(heapDump);
            oos.writeObject(result);
            File file = analyzedHeapfile;
            return file;
        }
        catch (IOException e) {
            CanaryLog.d(e, "Could not save leak analysis result to disk.", new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static AnalyzedHeap load(@NonNull File resultFile) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(resultFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            HeapDump heapDump = (HeapDump)ois.readObject();
            AnalysisResult result = (AnalysisResult)ois.readObject();
            AnalyzedHeap analyzedHeap = new AnalyzedHeap(heapDump, result, resultFile);
            return analyzedHeap;
        }
        catch (IOException | ClassNotFoundException e) {
            boolean deleted = resultFile.delete();
            if (deleted) {
                CanaryLog.d(e, "Could not read result file %s, deleted it.", resultFile);
            } else {
                CanaryLog.d(e, "Could not read result file %s, could not delete it either.", resultFile);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public AnalyzedHeap(@NonNull HeapDump heapDump, @NonNull AnalysisResult result, @NonNull File analyzedHeapFile) {
        this.heapDump = heapDump;
        this.result = result;
        this.selfFile = analyzedHeapFile;
        this.heapDumpFileExists = heapDump.heapDumpFile.exists();
        this.selfLastModified = analyzedHeapFile.lastModified();
    }
}

