/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import android.support.annotation.NonNull;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.ActivityRefWatcher;
import com.squareup.leakcanary.AndroidDebuggerControl;
import com.squareup.leakcanary.AndroidExcludedRefs;
import com.squareup.leakcanary.AndroidHeapDumper;
import com.squareup.leakcanary.AndroidReachabilityInspectors;
import com.squareup.leakcanary.AndroidWatchExecutor;
import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.DefaultLeakDirectoryProvider;
import com.squareup.leakcanary.DisplayLeakService;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.Reachability;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.RefWatcherBuilder;
import com.squareup.leakcanary.ServiceHeapDumpListener;
import com.squareup.leakcanary.WatchExecutor;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.FragmentRefWatcher;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class AndroidRefWatcherBuilder
extends RefWatcherBuilder<AndroidRefWatcherBuilder> {
    private static final long DEFAULT_WATCH_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private final Context context;
    private boolean watchActivities = true;
    private boolean watchFragments = true;

    AndroidRefWatcherBuilder(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    @NonNull
    public AndroidRefWatcherBuilder listenerServiceClass(@NonNull Class<? extends AbstractAnalysisResultService> listenerServiceClass) {
        return (AndroidRefWatcherBuilder)this.heapDumpListener(new ServiceHeapDumpListener(this.context, listenerServiceClass));
    }

    @NonNull
    public AndroidRefWatcherBuilder watchDelay(long delay, @NonNull TimeUnit unit) {
        return (AndroidRefWatcherBuilder)this.watchExecutor(new AndroidWatchExecutor(unit.toMillis(delay)));
    }

    @NonNull
    public AndroidRefWatcherBuilder watchActivities(boolean watchActivities) {
        this.watchActivities = watchActivities;
        return this;
    }

    @NonNull
    public AndroidRefWatcherBuilder watchFragments(boolean watchFragments) {
        this.watchFragments = watchFragments;
        return this;
    }

    @NonNull
    public AndroidRefWatcherBuilder maxStoredHeapDumps(int maxStoredHeapDumps) {
        DefaultLeakDirectoryProvider leakDirectoryProvider = new DefaultLeakDirectoryProvider(this.context, maxStoredHeapDumps);
        LeakCanary.setLeakDirectoryProvider(leakDirectoryProvider);
        return (AndroidRefWatcherBuilder)this.self();
    }

    @NonNull
    public RefWatcher buildAndInstall() {
        if (LeakCanaryInternals.installedRefWatcher != null) {
            throw new UnsupportedOperationException("buildAndInstall() should only be called once.");
        }
        RefWatcher refWatcher = this.build();
        if (refWatcher != RefWatcher.DISABLED) {
            LeakCanaryInternals.setEnabledAsync(this.context, DisplayLeakActivity.class, true);
            if (this.watchActivities) {
                ActivityRefWatcher.install(this.context, refWatcher);
            }
            if (this.watchFragments) {
                FragmentRefWatcher.Helper.install(this.context, refWatcher);
            }
        }
        LeakCanaryInternals.installedRefWatcher = refWatcher;
        return refWatcher;
    }

    protected boolean isDisabled() {
        return LeakCanary.isInAnalyzerProcess(this.context);
    }

    @NonNull
    protected HeapDumper defaultHeapDumper() {
        LeakDirectoryProvider leakDirectoryProvider = LeakCanaryInternals.getLeakDirectoryProvider(this.context);
        return new AndroidHeapDumper(this.context, leakDirectoryProvider);
    }

    @NonNull
    protected DebuggerControl defaultDebuggerControl() {
        return new AndroidDebuggerControl();
    }

    @NonNull
    protected HeapDump.Listener defaultHeapDumpListener() {
        return new ServiceHeapDumpListener(this.context, DisplayLeakService.class);
    }

    @NonNull
    protected ExcludedRefs defaultExcludedRefs() {
        return AndroidExcludedRefs.createAppDefaults().build();
    }

    @NonNull
    protected WatchExecutor defaultWatchExecutor() {
        return new AndroidWatchExecutor(DEFAULT_WATCH_DELAY_MILLIS);
    }

    @NonNull
    protected List<Class<? extends Reachability.Inspector>> defaultReachabilityInspectorClasses() {
        return AndroidReachabilityInspectors.defaultAndroidInspectors();
    }
}

