/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.ColorRes;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.squareup.leakcanary.Exclusion;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.Reachability;
import com.squareup.leakcanary.internal.DisplayLeakConnectorView;
import com.squareup.leakcanary.internal.MoreDetailsView;
import com.squareup.leakcanary.internal.SquigglySpan;

final class DisplayLeakAdapter
extends BaseAdapter {
    private static final int TOP_ROW = 0;
    private static final int NORMAL_ROW = 1;
    private boolean[] opened = new boolean[0];
    private LeakTrace leakTrace = null;
    private String referenceKey;
    private String referenceName = "";
    private final String classNameColorHexString;
    private final String leakColorHexString;
    private final String referenceColorHexString;
    private final String extraColorHexString;
    private final String helpColorHexString;

    DisplayLeakAdapter(Resources resources) {
        this.classNameColorHexString = DisplayLeakAdapter.hexStringColor(resources, R.color.leak_canary_class_name);
        this.leakColorHexString = DisplayLeakAdapter.hexStringColor(resources, R.color.leak_canary_leak);
        this.referenceColorHexString = DisplayLeakAdapter.hexStringColor(resources, R.color.leak_canary_reference);
        this.extraColorHexString = DisplayLeakAdapter.hexStringColor(resources, R.color.leak_canary_extra);
        this.helpColorHexString = DisplayLeakAdapter.hexStringColor(resources, R.color.leak_canary_help);
    }

    private static String hexStringColor(Resources resources, @ColorRes int colorResId) {
        return String.format("#%06X", 0xFFFFFF & resources.getColor(colorResId));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Context context = parent.getContext();
        if (this.getItemViewType(position) == 0) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.leak_canary_ref_top_row, parent, false);
            }
            TextView textView = (TextView)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_text);
            textView.setText((CharSequence)context.getPackageName());
        } else {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.leak_canary_ref_row, parent, false);
            }
            TextView titleView = (TextView)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_title);
            TextView detailView = (TextView)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_details);
            DisplayLeakConnectorView connector = (DisplayLeakConnectorView)((Object)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_connector));
            MoreDetailsView moreDetailsView = (MoreDetailsView)((Object)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_more));
            connector.setType(this.getConnectorType(position));
            moreDetailsView.setOpened(this.opened[position]);
            if (this.opened[position]) {
                detailView.setVisibility(0);
            } else {
                detailView.setVisibility(8);
            }
            Resources resources = convertView.getResources();
            if (position == 1) {
                titleView.setText((CharSequence)Html.fromHtml((String)("<font color='" + this.helpColorHexString + "'><b>" + resources.getString(R.string.leak_canary_help_title) + "</b></font>")));
                SpannableStringBuilder detailText = (SpannableStringBuilder)Html.fromHtml((String)resources.getString(R.string.leak_canary_help_detail));
                SquigglySpan.replaceUnderlineSpans(detailText, resources);
                detailView.setText((CharSequence)detailText);
            } else {
                Reachability nextReachability;
                boolean isLeakingInstance = position == this.getCount() - 1;
                LeakTraceElement element = this.getItem(position);
                Reachability reachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position));
                boolean maybeLeakCause = isLeakingInstance || reachability == Reachability.UNREACHABLE ? false : (nextReachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position + 1))) != Reachability.REACHABLE;
                Spanned htmlTitle = this.htmlTitle(element, maybeLeakCause, resources);
                titleView.setText((CharSequence)htmlTitle);
                if (this.opened[position]) {
                    Spanned htmlDetail = this.htmlDetails(isLeakingInstance, element);
                    detailView.setText((CharSequence)htmlDetail);
                }
            }
        }
        return convertView;
    }

    private Spanned htmlTitle(LeakTraceElement element, boolean maybeLeakCause, Resources resources) {
        String htmlString = "";
        String simpleName = element.getSimpleClassName();
        simpleName = simpleName.replace("[]", "[ ]");
        String styledClassName = "<font color='" + this.classNameColorHexString + "'>" + simpleName + "</font>";
        if (element.reference != null) {
            String referenceName = element.reference.getDisplayName().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            referenceName = maybeLeakCause ? "<u><font color='" + this.leakColorHexString + "'>" + referenceName + "</font></u>" : "<font color='" + this.referenceColorHexString + "'>" + referenceName + "</font>";
            if (element.reference.type == LeakTraceElement.Type.STATIC_FIELD) {
                referenceName = "<i>" + referenceName + "</i>";
            }
            String classAndReference = styledClassName + "." + referenceName;
            if (maybeLeakCause) {
                classAndReference = "<b>" + classAndReference + "</b>";
            }
            htmlString = htmlString + classAndReference;
        } else {
            htmlString = htmlString + styledClassName;
        }
        Exclusion exclusion = element.exclusion;
        if (exclusion != null) {
            htmlString = htmlString + " (excluded)";
        }
        SpannableStringBuilder builder = (SpannableStringBuilder)Html.fromHtml((String)htmlString);
        if (maybeLeakCause) {
            SquigglySpan.replaceUnderlineSpans(builder, resources);
        }
        return builder;
    }

    private Spanned htmlDetails(boolean isLeakingInstance, LeakTraceElement element) {
        Exclusion exclusion;
        String htmlString = "";
        if (element.extra != null) {
            htmlString = htmlString + " <font color='" + this.extraColorHexString + "'>" + element.extra + "</font>";
        }
        if ((exclusion = element.exclusion) != null) {
            htmlString = htmlString + "<br/><br/>Excluded by rule";
            if (exclusion.name != null) {
                htmlString = htmlString + " <font color='#ffffff'>" + exclusion.name + "</font>";
            }
            htmlString = htmlString + " matching <font color='#f3cf83'>" + exclusion.matching + "</font>";
            if (exclusion.reason != null) {
                htmlString = htmlString + " because <font color='#f3cf83'>" + exclusion.reason + "</font>";
            }
        }
        htmlString = htmlString + "<br><font color='" + this.extraColorHexString + "'>" + element.toDetailedString().replace("\n", "<br>") + "</font>";
        if (isLeakingInstance && !this.referenceName.equals("")) {
            htmlString = htmlString + " <font color='" + this.extraColorHexString + "'>" + this.referenceName + "</font>";
        }
        return Html.fromHtml((String)htmlString);
    }

    private DisplayLeakConnectorView.Type getConnectorType(int position) {
        boolean isLeakingInstance;
        if (position == 1) {
            return DisplayLeakConnectorView.Type.HELP;
        }
        if (position == 2) {
            Reachability nextReachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position + 1));
            if (nextReachability != Reachability.REACHABLE) {
                return DisplayLeakConnectorView.Type.START_LAST_REACHABLE;
            }
            return DisplayLeakConnectorView.Type.START;
        }
        boolean bl = isLeakingInstance = position == this.getCount() - 1;
        if (isLeakingInstance) {
            Reachability previousReachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position - 1));
            if (previousReachability != Reachability.UNREACHABLE) {
                return DisplayLeakConnectorView.Type.END_FIRST_UNREACHABLE;
            }
            return DisplayLeakConnectorView.Type.END;
        }
        Reachability reachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position));
        switch (reachability) {
            case UNKNOWN: {
                return DisplayLeakConnectorView.Type.NODE_UNKNOWN;
            }
            case REACHABLE: {
                Reachability nextReachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position + 1));
                if (nextReachability != Reachability.REACHABLE) {
                    return DisplayLeakConnectorView.Type.NODE_LAST_REACHABLE;
                }
                return DisplayLeakConnectorView.Type.NODE_REACHABLE;
            }
            case UNREACHABLE: {
                Reachability previousReachability = (Reachability)this.leakTrace.expectedReachability.get(this.elementIndex(position - 1));
                if (previousReachability != Reachability.UNREACHABLE) {
                    return DisplayLeakConnectorView.Type.NODE_FIRST_UNREACHABLE;
                }
                return DisplayLeakConnectorView.Type.NODE_UNREACHABLE;
            }
        }
        throw new IllegalStateException("Unknown value: " + reachability);
    }

    public void update(LeakTrace leakTrace, String referenceKey, String referenceName) {
        if (referenceKey.equals(this.referenceKey)) {
            return;
        }
        this.referenceKey = referenceKey;
        this.referenceName = referenceName;
        this.leakTrace = leakTrace;
        this.opened = new boolean[2 + leakTrace.elements.size()];
        this.notifyDataSetChanged();
    }

    public void toggleRow(int position) {
        this.opened[position] = !this.opened[position];
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.leakTrace == null) {
            return 2;
        }
        return 2 + this.leakTrace.elements.size();
    }

    public LeakTraceElement getItem(int position) {
        if (this.getItemViewType(position) == 0) {
            return null;
        }
        if (position == 1) {
            return null;
        }
        return (LeakTraceElement)this.leakTrace.elements.get(this.elementIndex(position));
    }

    private int elementIndex(int position) {
        return position - 2;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return 0;
        }
        return 1;
    }

    public long getItemId(int position) {
        return position;
    }

    private static <T extends View> T findById(View view, int id2) {
        return (T)view.findViewById(id2);
    }
}

