/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.squareup.leakcanary.R;

public final class DisplayLeakConnectorView
extends View {
    private static final float SQRT_TWO = (float)Math.sqrt(2.0);
    private static final PorterDuffXfermode CLEAR_XFER_MODE = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    private final Paint classNamePaint;
    private final Paint leakPaint;
    private final Paint clearPaint;
    private final Paint referencePaint;
    private final float strokeSize;
    private final float circleY;
    private Type type;
    private Bitmap cache;

    public DisplayLeakConnectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.type = Type.NODE_UNKNOWN;
        this.circleY = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_center_y);
        this.strokeSize = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_stroke_size);
        this.classNamePaint = new Paint(1);
        this.classNamePaint.setColor(resources.getColor(R.color.leak_canary_class_name));
        this.classNamePaint.setStrokeWidth(this.strokeSize);
        this.leakPaint = new Paint(1);
        this.leakPaint.setColor(resources.getColor(R.color.leak_canary_leak));
        this.leakPaint.setStyle(Paint.Style.STROKE);
        this.leakPaint.setStrokeWidth(this.strokeSize);
        float pathLines = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_leak_dash_line);
        float pathGaps = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_leak_dash_gap);
        this.leakPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{pathLines, pathGaps}, 0.0f));
        this.clearPaint = new Paint(1);
        this.clearPaint.setColor(0);
        this.clearPaint.setXfermode((Xfermode)CLEAR_XFER_MODE);
        this.referencePaint = new Paint(1);
        this.referencePaint.setColor(resources.getColor(R.color.leak_canary_reference));
        this.referencePaint.setStrokeWidth(this.strokeSize);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.cache != null && (this.cache.getWidth() != width || this.cache.getHeight() != height)) {
            this.cache.recycle();
            this.cache = null;
        }
        if (this.cache == null) {
            this.cache = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas cacheCanvas = new Canvas(this.cache);
            switch (this.type) {
                case NODE_UNKNOWN: {
                    this.drawItems(cacheCanvas, this.leakPaint, this.leakPaint);
                    break;
                }
                case NODE_UNREACHABLE: 
                case NODE_REACHABLE: {
                    this.drawItems(cacheCanvas, this.referencePaint, this.referencePaint);
                    break;
                }
                case NODE_FIRST_UNREACHABLE: {
                    this.drawItems(cacheCanvas, this.leakPaint, this.referencePaint);
                    break;
                }
                case NODE_LAST_REACHABLE: {
                    this.drawItems(cacheCanvas, this.referencePaint, this.leakPaint);
                    break;
                }
                case START: {
                    this.drawStartLine(cacheCanvas);
                    this.drawItems(cacheCanvas, null, this.referencePaint);
                    break;
                }
                case START_LAST_REACHABLE: {
                    this.drawStartLine(cacheCanvas);
                    this.drawItems(cacheCanvas, null, this.leakPaint);
                    break;
                }
                case END: {
                    this.drawItems(cacheCanvas, this.referencePaint, null);
                    break;
                }
                case END_FIRST_UNREACHABLE: {
                    this.drawItems(cacheCanvas, this.leakPaint, null);
                    break;
                }
                case HELP: {
                    this.drawRoot(cacheCanvas);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type " + (Object)((Object)this.type));
                }
            }
        }
        canvas.drawBitmap(this.cache, 0.0f, 0.0f, null);
    }

    private void drawStartLine(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        float halfWidth = (float)width / 2.0f;
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, this.circleY, this.classNamePaint);
    }

    private void drawRoot(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        float halfWidth = (float)width / 2.0f;
        float radiusClear = halfWidth - this.strokeSize / 2.0f;
        cacheCanvas.drawRect(0.0f, 0.0f, (float)width, radiusClear, this.classNamePaint);
        cacheCanvas.drawCircle(0.0f, radiusClear, radiusClear, this.clearPaint);
        cacheCanvas.drawCircle((float)width, radiusClear, radiusClear, this.clearPaint);
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, (float)height, this.classNamePaint);
    }

    private void drawItems(Canvas cacheCanvas, Paint arrowHeadPaint, Paint nextArrowPaint) {
        if (arrowHeadPaint != null) {
            this.drawArrowHead(cacheCanvas, arrowHeadPaint);
        }
        if (nextArrowPaint != null) {
            this.drawNextArrowLine(cacheCanvas, nextArrowPaint);
        }
        this.drawInstanceCircle(cacheCanvas);
    }

    private void drawArrowHead(Canvas cacheCanvas, Paint paint) {
        float halfWidth;
        int width = this.getMeasuredWidth();
        float centerX = halfWidth = (float)width / 2.0f;
        float circleRadius = (float)width / 3.0f;
        float arrowSideLength = halfWidth;
        float arrowHeight = arrowSideLength / 2.0f * SQRT_TWO;
        float halfStrokeSize = this.strokeSize / 2.0f;
        float translateY = this.circleY - arrowHeight - circleRadius * 2.0f - this.strokeSize;
        float lineYEnd = this.circleY - circleRadius - this.strokeSize / 2.0f;
        cacheCanvas.drawLine(centerX, 0.0f, centerX, lineYEnd, paint);
        cacheCanvas.translate(centerX, translateY);
        cacheCanvas.rotate(45.0f);
        cacheCanvas.drawLine(0.0f, arrowSideLength, arrowSideLength + halfStrokeSize, arrowSideLength, paint);
        cacheCanvas.drawLine(arrowSideLength, 0.0f, arrowSideLength, arrowSideLength, paint);
        cacheCanvas.rotate(-45.0f);
        cacheCanvas.translate(-centerX, -translateY);
    }

    private void drawNextArrowLine(Canvas cacheCanvas, Paint paint) {
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        float centerX = (float)width / 2.0f;
        cacheCanvas.drawLine(centerX, this.circleY, centerX, (float)height, paint);
    }

    private void drawInstanceCircle(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        float circleX = (float)width / 2.0f;
        float circleRadius = (float)width / 3.0f;
        cacheCanvas.drawCircle(circleX, this.circleY, circleRadius, this.classNamePaint);
    }

    public void setType(Type type) {
        if (type != this.type) {
            this.type = type;
            if (this.cache != null) {
                this.cache.recycle();
                this.cache = null;
            }
            this.invalidate();
        }
    }

    public static enum Type {
        HELP,
        START,
        START_LAST_REACHABLE,
        NODE_UNKNOWN,
        NODE_FIRST_UNREACHABLE,
        NODE_UNREACHABLE,
        NODE_REACHABLE,
        NODE_LAST_REACHABLE,
        END,
        END_FIRST_UNREACHABLE;

    }
}

