/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.internal.ActivityLifecycleCallbacksAdapter;
import com.squareup.leakcanary.internal.AndroidOFragmentRefWatcher;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public interface FragmentRefWatcher {
    public void watchFragments(Activity var1);

    public static final class Helper {
        private static final String SUPPORT_FRAGMENT_REF_WATCHER_CLASS_NAME = "com.squareup.leakcanary.internal.SupportFragmentRefWatcher";
        private final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new ActivityLifecycleCallbacksAdapter(){

            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                for (FragmentRefWatcher watcher : Helper.this.fragmentRefWatchers) {
                    watcher.watchFragments(activity);
                }
            }
        };
        private final List<FragmentRefWatcher> fragmentRefWatchers;

        public static void install(Context context, RefWatcher refWatcher) {
            ArrayList<FragmentRefWatcher> fragmentRefWatchers = new ArrayList<FragmentRefWatcher>();
            if (Build.VERSION.SDK_INT >= 26) {
                fragmentRefWatchers.add(new AndroidOFragmentRefWatcher(refWatcher));
            }
            try {
                Class<?> fragmentRefWatcherClass = Class.forName(SUPPORT_FRAGMENT_REF_WATCHER_CLASS_NAME);
                Constructor<?> constructor = fragmentRefWatcherClass.getDeclaredConstructor(RefWatcher.class);
                FragmentRefWatcher supportFragmentRefWatcher = (FragmentRefWatcher)constructor.newInstance(refWatcher);
                fragmentRefWatchers.add(supportFragmentRefWatcher);
            }
            catch (Exception fragmentRefWatcherClass) {
                // empty catch block
            }
            if (fragmentRefWatchers.size() == 0) {
                return;
            }
            Helper helper = new Helper(fragmentRefWatchers);
            Application application = (Application)context.getApplicationContext();
            application.registerActivityLifecycleCallbacks(helper.activityLifecycleCallbacks);
        }

        private Helper(List<FragmentRefWatcher> fragmentRefWatchers) {
            this.fragmentRefWatchers = fragmentRefWatchers;
        }
    }
}

