/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.squareup.leakcanary.R;

public class RowElementLayout
extends ViewGroup {
    private final int connectorWidth;
    private final int rowMargins;
    private final int moreSize;
    private final int minHeight;
    private final int titleMarginTop;
    private final int moreMarginTop;
    private View connector;
    private View moreButton;
    private View title;
    private View details;

    public RowElementLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.connectorWidth = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_width);
        this.rowMargins = resources.getDimensionPixelSize(R.dimen.leak_canary_row_margins);
        this.moreSize = resources.getDimensionPixelSize(R.dimen.leak_canary_more_size);
        this.minHeight = resources.getDimensionPixelSize(R.dimen.leak_canary_row_min);
        this.titleMarginTop = resources.getDimensionPixelSize(R.dimen.leak_canary_row_title_margin_top);
        this.moreMarginTop = resources.getDimensionPixelSize(R.dimen.leak_canary_more_margin_top);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.connector = this.findViewById(R.id.leak_canary_row_connector);
        this.moreButton = this.findViewById(R.id.leak_canary_row_more);
        this.title = this.findViewById(R.id.leak_canary_row_title);
        this.details = this.findViewById(R.id.leak_canary_row_details);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int availableWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int titleWidth = availableWidth - this.connectorWidth - this.moreSize - 4 * this.rowMargins;
        int titleWidthSpec = View.MeasureSpec.makeMeasureSpec((int)titleWidth, (int)Integer.MIN_VALUE);
        int titleHeightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.title.measure(titleWidthSpec, titleHeightSpec);
        int moreSizeSpec = View.MeasureSpec.makeMeasureSpec((int)this.moreSize, (int)0x40000000);
        this.moreButton.measure(moreSizeSpec, moreSizeSpec);
        int totalHeight = this.titleMarginTop + this.title.getMeasuredHeight();
        int detailsWidth = availableWidth - this.connectorWidth - 3 * this.rowMargins;
        int detailsWidthSpec = View.MeasureSpec.makeMeasureSpec((int)detailsWidth, (int)Integer.MIN_VALUE);
        int detailsHeightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.details.measure(detailsWidthSpec, detailsHeightSpec);
        if (this.details.getVisibility() != 8) {
            totalHeight += this.details.getMeasuredHeight();
        }
        totalHeight = Math.max(totalHeight, this.minHeight);
        int connectorWidthSpec = View.MeasureSpec.makeMeasureSpec((int)this.connectorWidth, (int)0x40000000);
        int connectorHeightSpec = View.MeasureSpec.makeMeasureSpec((int)totalHeight, (int)0x40000000);
        this.connector.measure(connectorWidthSpec, connectorHeightSpec);
        this.setMeasuredDimension(availableWidth, totalHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getMeasuredWidth();
        int connectorRight = this.rowMargins + this.connector.getMeasuredWidth();
        this.connector.layout(this.rowMargins, 0, connectorRight, this.connector.getMeasuredHeight());
        this.moreButton.layout(width - this.rowMargins - this.moreSize, this.moreMarginTop, width - this.rowMargins, this.moreMarginTop + this.moreSize);
        int titleLeft = connectorRight + this.rowMargins;
        int titleBottom = this.titleMarginTop + this.title.getMeasuredHeight();
        this.title.layout(titleLeft, this.titleMarginTop, titleLeft + this.title.getMeasuredWidth(), titleBottom);
        if (this.details.getVisibility() != 8) {
            this.details.layout(titleLeft, titleBottom, width - this.rowMargins, titleBottom + this.details.getMeasuredHeight());
        }
    }
}

