/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.widget.Toast;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.ActivityLifecycleCallbacksAdapter;
import com.squareup.leakcanary.internal.FutureResult;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.util.concurrent.TimeUnit;

public final class AndroidHeapDumper
implements HeapDumper {
    private final Context context;
    private final LeakDirectoryProvider leakDirectoryProvider;
    private final Handler mainHandler;
    private Activity resumedActivity;

    public AndroidHeapDumper(@NonNull Context context, @NonNull LeakDirectoryProvider leakDirectoryProvider) {
        this.leakDirectoryProvider = leakDirectoryProvider;
        this.context = context.getApplicationContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
        Application application = (Application)context.getApplicationContext();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksAdapter(){

            @Override
            public void onActivityResumed(Activity activity) {
                AndroidHeapDumper.this.resumedActivity = activity;
            }

            @Override
            public void onActivityPaused(Activity activity) {
                if (AndroidHeapDumper.this.resumedActivity == activity) {
                    AndroidHeapDumper.this.resumedActivity = null;
                }
            }
        });
    }

    @Nullable
    public File dumpHeap() {
        File heapDumpFile = this.leakDirectoryProvider.newHeapDumpFile();
        if (heapDumpFile == RETRY_LATER) {
            return RETRY_LATER;
        }
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            CanaryLog.d("Did not dump heap, too much time waiting for Toast.", new Object[0]);
            return RETRY_LATER;
        }
        Notification.Builder builder = new Notification.Builder(this.context).setContentTitle((CharSequence)this.context.getString(R.string.leak_canary_notification_dumping));
        Notification notification = LeakCanaryInternals.buildNotification(this.context, builder);
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        int notificationId = (int)SystemClock.uptimeMillis();
        notificationManager.notify(notificationId, notification);
        Toast toast = waitingForToast.get();
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            this.cancelToast(toast);
            notificationManager.cancel(notificationId);
            return heapDumpFile;
        }
        catch (Exception e) {
            CanaryLog.d(e, "Could not dump heap", new Object[0]);
            return RETRY_LATER;
        }
    }

    private void showToast(final FutureResult<Toast> waitingForToast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AndroidHeapDumper.this.resumedActivity == null) {
                    waitingForToast.set(null);
                    return;
                }
                final Toast toast = new Toast((Context)AndroidHeapDumper.this.resumedActivity);
                toast.setGravity(16, 0, 0);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.this.resumedActivity);
                toast.setView(inflater.inflate(R.layout.leak_canary_heap_dump_toast, null));
                toast.show();
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        waitingForToast.set(toast);
                        return false;
                    }
                });
            }
        });
    }

    private void cancelToast(final Toast toast) {
        if (toast == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                toast.cancel();
            }
        });
    }
}

