/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.os.MessageQueue;
import android.support.annotation.NonNull;
import android.view.View;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.Reachability;
import java.util.ArrayList;
import java.util.List;

public enum AndroidReachabilityInspectors {
    VIEW(ViewInspector.class),
    ACTIVITY(ActivityInspector.class),
    DIALOG(DialogInspector.class),
    APPLICATION(ApplicationInspector.class),
    FRAGMENT(FragmentInspector.class),
    SUPPORT_FRAGMENT(SupportFragmentInspector.class),
    MESSAGE_QUEUE(MessageQueueInspector.class),
    MORTAR_PRESENTER(MortarPresenterInspector.class),
    VIEW_ROOT_IMPL(ViewImplInspector.class),
    MAIN_THEAD(MainThreadInspector.class),
    WINDOW(WindowInspector.class);

    private final Class<? extends Reachability.Inspector> inspectorClass;

    private AndroidReachabilityInspectors(Class<? extends Reachability.Inspector> inspectorClass) {
        this.inspectorClass = inspectorClass;
    }

    @NonNull
    public static List<Class<? extends Reachability.Inspector>> defaultAndroidInspectors() {
        ArrayList<Class<? extends Reachability.Inspector>> inspectorClasses = new ArrayList<Class<? extends Reachability.Inspector>>();
        for (AndroidReachabilityInspectors enumValue : AndroidReachabilityInspectors.values()) {
            inspectorClasses.add(enumValue.inspectorClass);
        }
        return inspectorClasses;
    }

    public static class WindowInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf("android.view.Window")) {
                return Reachability.UNKNOWN;
            }
            String mDestroyed = element.getFieldReferenceValue("mDestroyed");
            if (mDestroyed == null) {
                return Reachability.UNKNOWN;
            }
            return mDestroyed.equals("true") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class MainThreadInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(Thread.class)) {
                return Reachability.UNKNOWN;
            }
            String name = element.getFieldReferenceValue("name");
            if ("main".equals(name)) {
                return Reachability.REACHABLE;
            }
            return Reachability.UNKNOWN;
        }
    }

    public static class ViewImplInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf("android.view.ViewRootImpl")) {
                return Reachability.UNKNOWN;
            }
            String mView = element.getFieldReferenceValue("mView");
            if (mView == null) {
                return Reachability.UNKNOWN;
            }
            return mView.equals("null") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class MortarPresenterInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf("mortar.Presenter")) {
                return Reachability.UNKNOWN;
            }
            String view = element.getFieldReferenceValue("view");
            if ("null".equals(view)) {
                return Reachability.UNREACHABLE;
            }
            return Reachability.UNKNOWN;
        }
    }

    public static class MessageQueueInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(MessageQueue.class)) {
                return Reachability.UNKNOWN;
            }
            String mQuitting = element.getFieldReferenceValue("mQuitting");
            if ("true".equals(mQuitting)) {
                return Reachability.UNREACHABLE;
            }
            return Reachability.UNKNOWN;
        }
    }

    public static class SupportFragmentInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf("android.support.v4.app.Fragment")) {
                return Reachability.UNKNOWN;
            }
            String mDetached = element.getFieldReferenceValue("mDetached");
            if (mDetached == null) {
                return Reachability.UNKNOWN;
            }
            return mDetached.equals("true") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class FragmentInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(Fragment.class)) {
                return Reachability.UNKNOWN;
            }
            String mDetached = element.getFieldReferenceValue("mDetached");
            if (mDetached == null) {
                return Reachability.UNKNOWN;
            }
            return mDetached.equals("true") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class ApplicationInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (element.isInstanceOf(Application.class)) {
                return Reachability.REACHABLE;
            }
            return Reachability.UNKNOWN;
        }
    }

    public static class DialogInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(Dialog.class)) {
                return Reachability.UNKNOWN;
            }
            String mDecor = element.getFieldReferenceValue("mDecor");
            if (mDecor == null) {
                return Reachability.UNKNOWN;
            }
            return mDecor.equals("null") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class ActivityInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(Activity.class)) {
                return Reachability.UNKNOWN;
            }
            String mDestroyed = element.getFieldReferenceValue("mDestroyed");
            if (mDestroyed == null) {
                return Reachability.UNKNOWN;
            }
            return mDestroyed.equals("true") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }

    public static class ViewInspector
    implements Reachability.Inspector {
        @NonNull
        public Reachability expectedReachability(@NonNull LeakTraceElement element) {
            if (!element.isInstanceOf(View.class)) {
                return Reachability.UNKNOWN;
            }
            String mAttachInfo = element.getFieldReferenceValue("mAttachInfo");
            if (mAttachInfo == null) {
                return Reachability.UNKNOWN;
            }
            return mAttachInfo.equals("null") ? Reachability.UNREACHABLE : Reachability.REACHABLE;
        }
    }
}

