/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.PendingIntent;
import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.format.Formatter;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AnalyzedHeap;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DisplayLeakService
extends AbstractAnalysisResultService {
    @Override
    protected final void onHeapAnalyzed(@NonNull AnalyzedHeap analyzedHeap) {
        HeapDump heapDump = analyzedHeap.heapDump;
        AnalysisResult result = analyzedHeap.result;
        String leakInfo = LeakCanary.leakInfo((Context)this, heapDump, result, true);
        CanaryLog.d("%s", leakInfo);
        heapDump = this.renameHeapdump(heapDump);
        boolean resultSaved = this.saveResult(heapDump, result);
        if (resultSaved) {
            String contentTitle;
            PendingIntent pendingIntent = DisplayLeakActivity.createPendingIntent((Context)this, heapDump.referenceKey);
            if (result.failure != null) {
                contentTitle = this.getString(R.string.leak_canary_analysis_failed);
            } else {
                String className = LeakCanaryInternals.classSimpleName(result.className);
                if (result.leakFound) {
                    if (result.retainedHeapSize == -1L) {
                        contentTitle = result.excludedLeak ? this.getString(R.string.leak_canary_leak_excluded, new Object[]{className}) : this.getString(R.string.leak_canary_class_has_leaked, new Object[]{className});
                    } else {
                        String size = Formatter.formatShortFileSize((Context)this, (long)result.retainedHeapSize);
                        contentTitle = result.excludedLeak ? this.getString(R.string.leak_canary_leak_excluded_retaining, new Object[]{className, size}) : this.getString(R.string.leak_canary_class_has_leaked_retaining, new Object[]{className, size});
                    }
                } else {
                    contentTitle = this.getString(R.string.leak_canary_class_no_leak, new Object[]{className});
                }
            }
            String contentText = this.getString(R.string.leak_canary_notification_message);
            this.showNotification(pendingIntent, contentTitle, contentText);
        } else {
            this.onAnalysisResultFailure(this.getString(R.string.leak_canary_could_not_save_text));
        }
        this.afterDefaultHandling(heapDump, result, leakInfo);
    }

    @Override
    protected final void onAnalysisResultFailure(String failureMessage) {
        super.onAnalysisResultFailure(failureMessage);
        String failureTitle = this.getString(R.string.leak_canary_result_failure_title);
        this.showNotification(null, failureTitle, failureMessage);
    }

    private void showNotification(PendingIntent pendingIntent, String contentTitle, String contentText) {
        int notificationId = (int)(SystemClock.uptimeMillis() / 1000L);
        LeakCanaryInternals.showNotification((Context)this, contentTitle, contentText, pendingIntent, notificationId);
    }

    private boolean saveResult(HeapDump heapDump, AnalysisResult result) {
        File resultFile = AnalyzedHeap.save(heapDump, result);
        return resultFile != null;
    }

    private HeapDump renameHeapdump(HeapDump heapDump) {
        String fileName = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS'.hprof'", Locale.US).format(new Date());
        File newFile = new File(heapDump.heapDumpFile.getParent(), fileName);
        boolean renamed = heapDump.heapDumpFile.renameTo(newFile);
        if (!renamed) {
            CanaryLog.d("Could not rename heap dump file %s to %s", heapDump.heapDumpFile.getPath(), newFile.getPath());
        }
        return heapDump.buildUpon().heapDumpFile(newFile).build();
    }

    protected void afterDefaultHandling(@NonNull HeapDump heapDump, @NonNull AnalysisResult result, @NonNull String leakInfo) {
    }
}

