/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Process;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.DefaultLeakDirectoryProvider;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.internal.LeakCanarySingleThreadFactory;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class LeakCanaryInternals {
    public static final String SAMSUNG = "samsung";
    public static final String MOTOROLA = "motorola";
    public static final String LENOVO = "LENOVO";
    public static final String LG = "LGE";
    public static final String NVIDIA = "NVIDIA";
    public static final String MEIZU = "Meizu";
    public static final String HUAWEI = "HUAWEI";
    public static final String VIVO = "vivo";
    public static volatile RefWatcher installedRefWatcher;
    private static volatile LeakDirectoryProvider leakDirectoryProvider;
    private static final String NOTIFICATION_CHANNEL_ID = "leakcanary";
    public static volatile Boolean isInAnalyzerProcess;

    public static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    public static void setEnabledAsync(Context context, final Class<?> componentClass, final boolean enabled) {
        final Context appContext = context.getApplicationContext();
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                LeakCanaryInternals.setEnabledBlocking(appContext, componentClass, enabled);
            }
        });
    }

    public static void setEnabledBlocking(Context appContext, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(appContext, componentClass);
        PackageManager packageManager = appContext.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    public static boolean isInServiceProcess(Context context, Class<? extends Service> serviceClass) {
        List runningProcesses;
        ServiceInfo serviceInfo;
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4);
        }
        catch (Exception e) {
            CanaryLog.d(e, "Could not get package info for %s", context.getPackageName());
            return false;
        }
        String mainProcess = packageInfo.applicationInfo.processName;
        ComponentName component = new ComponentName(context, serviceClass);
        try {
            serviceInfo = packageManager.getServiceInfo(component, 512);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return false;
        }
        if (serviceInfo.processName.equals(mainProcess)) {
            CanaryLog.d("Did not expect service %s to run in main process %s", serviceClass, mainProcess);
            return false;
        }
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningAppProcessInfo myProcess = null;
        try {
            runningProcesses = activityManager.getRunningAppProcesses();
        }
        catch (SecurityException exception) {
            CanaryLog.d("Could not get running app processes %d", exception);
            return false;
        }
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo process : runningProcesses) {
                if (process.pid != myPid) continue;
                myProcess = process;
                break;
            }
        }
        if (myProcess == null) {
            CanaryLog.d("Could not find running process for %d", myPid);
            return false;
        }
        return myProcess.processName.equals(serviceInfo.processName);
    }

    public static void showNotification(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent pendingIntent, int notificationId) {
        Notification.Builder builder = new Notification.Builder(context).setContentText(contentText).setContentTitle(contentTitle).setAutoCancel(true).setContentIntent(pendingIntent);
        Notification notification = LeakCanaryInternals.buildNotification(context, builder);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(notificationId, notification);
    }

    public static Notification buildNotification(Context context, Notification.Builder builder) {
        builder.setSmallIcon(R.drawable.leak_canary_notification).setWhen(System.currentTimeMillis()).setOnlyAlertOnce(true);
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(NOTIFICATION_CHANNEL_ID);
            if (notificationChannel == null) {
                String channelName = context.getString(R.string.leak_canary_notification_channel);
                notificationChannel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)channelName, 3);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            builder.setChannelId(NOTIFICATION_CHANNEL_ID);
        }
        if (Build.VERSION.SDK_INT < 16) {
            return builder.getNotification();
        }
        return builder.build();
    }

    public static Executor newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new LeakCanarySingleThreadFactory(threadName));
    }

    public static void setLeakDirectoryProvider(LeakDirectoryProvider leakDirectoryProvider) {
        if (LeakCanaryInternals.leakDirectoryProvider != null) {
            throw new IllegalStateException("Cannot set the LeakDirectoryProvider after it has already been set. Try setting it before installing the RefWatcher.");
        }
        LeakCanaryInternals.leakDirectoryProvider = leakDirectoryProvider;
    }

    public static LeakDirectoryProvider getLeakDirectoryProvider(Context context) {
        LeakDirectoryProvider leakDirectoryProvider = LeakCanaryInternals.leakDirectoryProvider;
        if (leakDirectoryProvider == null) {
            leakDirectoryProvider = new DefaultLeakDirectoryProvider(context);
        }
        return leakDirectoryProvider;
    }

    private LeakCanaryInternals() {
        throw new AssertionError();
    }
}

