/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.squareup.leakcanary.CanaryLog;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.LeakDirectoryProvider;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.FutureResult;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.util.concurrent.TimeUnit;

public final class AndroidHeapDumper
implements HeapDumper {
    private final Context context;
    private final LeakDirectoryProvider leakDirectoryProvider;
    private final Handler mainHandler;

    public AndroidHeapDumper(Context context, LeakDirectoryProvider leakDirectoryProvider) {
        this.leakDirectoryProvider = leakDirectoryProvider;
        this.context = context.getApplicationContext();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public File dumpHeap() {
        File heapDumpFile = this.leakDirectoryProvider.newHeapDumpFile();
        if (heapDumpFile == RETRY_LATER) {
            return RETRY_LATER;
        }
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            CanaryLog.d("Did not dump heap, too much time waiting for Toast.", new Object[0]);
            return RETRY_LATER;
        }
        Notification.Builder builder = new Notification.Builder(this.context).setContentTitle((CharSequence)this.context.getString(R.string.leak_canary_notification_dumping));
        Notification notification = LeakCanaryInternals.buildNotification(this.context, builder);
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        int notificationId = (int)SystemClock.uptimeMillis();
        notificationManager.notify(notificationId, notification);
        Toast toast = waitingForToast.get();
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            this.cancelToast(toast);
            notificationManager.cancel(notificationId);
            return heapDumpFile;
        }
        catch (Exception e) {
            CanaryLog.d(e, "Could not dump heap", new Object[0]);
            return RETRY_LATER;
        }
    }

    private void showToast(final FutureResult<Toast> waitingForToast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                final Toast toast = new Toast(AndroidHeapDumper.this.context);
                toast.setGravity(16, 0, 0);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.this.context);
                toast.setView(inflater.inflate(R.layout.leak_canary_heap_dump_toast, null));
                AndroidHeapDumper.this.show(toast);
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        waitingForToast.set(toast);
                        return false;
                    }
                });
            }
        });
    }

    private void cancelToast(final Toast toast) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                AndroidHeapDumper.this.hide(toast);
            }
        });
    }

    private void show(Toast toast) {
        View view = toast.getView();
        Context context = toast.getView().getContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Configuration config = view.getContext().getResources().getConfiguration();
        int gravity = toast.getGravity();
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)config.getLayoutDirection());
        }
        WindowManager.LayoutParams params = this.buildLayoutParams();
        params.gravity = gravity;
        if ((gravity & 7) == 7) {
            params.horizontalWeight = 1.0f;
        }
        if ((gravity & 0x70) == 112) {
            params.verticalWeight = 1.0f;
        }
        params.x = toast.getXOffset();
        params.y = toast.getYOffset();
        params.verticalMargin = toast.getVerticalMargin();
        params.horizontalMargin = toast.getHorizontalMargin();
        params.packageName = context.getPackageName();
        try {
            windowManager.addView(view, (ViewGroup.LayoutParams)params);
        }
        catch (WindowManager.BadTokenException e) {
            CanaryLog.d(e, "Could not show leak toast, the window token has been canceled", new Object[0]);
            return;
        }
        this.trySendAccessibilityEvent(view);
    }

    private void hide(Toast toast) {
        View view = toast.getView();
        if (view.getParent() != null) {
            Context context = toast.getView().getContext();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.removeView(view);
        }
    }

    private WindowManager.LayoutParams buildLayoutParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.height = -2;
        params.width = -2;
        params.format = -3;
        params.windowAnimations = 16973828;
        params.type = 2005;
        params.setTitle((CharSequence)"Toast");
        params.flags = 152;
        return params;
    }

    private void trySendAccessibilityEvent(View view) {
        Context context = view.getContext();
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        if (!accessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)64);
        event.setClassName((CharSequence)this.getClass().getName());
        event.setPackageName((CharSequence)context.getPackageName());
        view.dispatchPopulateAccessibilityEvent(event);
        accessibilityManager.sendAccessibilityEvent(event);
    }
}

