/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.content.Intent;
import com.squareup.leakcanary.R;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.AnalyzerProgressListener;
import leakcanary.CanaryLog;
import leakcanary.HeapAnalysis;
import leakcanary.HeapAnalyzer;
import leakcanary.HeapDump;
import leakcanary.LeakCanary;
import leakcanary.internal.AnalysisResultService;
import leakcanary.internal.ForegroundService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lleakcanary/internal/HeapAnalyzerService;", "Lleakcanary/internal/ForegroundService;", "Lleakcanary/AnalyzerProgressListener;", "()V", "onHandleIntentInForeground", "", "intent", "Landroid/content/Intent;", "onProgressUpdate", "step", "Lleakcanary/AnalyzerProgressListener$Step;", "leakcanary-android_release"})
public final class HeapAnalyzerService
extends ForegroundService
implements AnalyzerProgressListener {
    protected void onHandleIntentInForeground(@Nullable Intent intent) {
        if (intent == null) {
            CanaryLog.INSTANCE.d("HeapAnalyzerService received a null intent, ignoring.", new Object[0]);
            return;
        }
        Serializable serializable = intent.getSerializableExtra("HEAPDUMP_EXTRA");
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type leakcanary.HeapDump");
        }
        HeapDump heapDump = (HeapDump)serializable;
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer((AnalyzerProgressListener)this);
        HeapAnalysis heapAnalysis = heapAnalyzer.checkForLeaks(heapDump, LeakCanary.INSTANCE.getConfig().getLabelers());
        AnalysisResultService.Companion.sendResult((Context)this, heapAnalysis);
    }

    public void onProgressUpdate(@NotNull AnalyzerProgressListener.Step step) {
        String string;
        String lowercase;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        int percent = (int)(100.0f * (float)step.ordinal() / (float)AnalyzerProgressListener.Step.values().length);
        CanaryLog.INSTANCE.d("Analysis in progress, working on: %s", new Object[]{step.name()});
        String string3 = string2 = StringsKt.replace$default((String)step.name(), (String)"_", (String)" ", (boolean)false, (int)4, null);
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = lowercase = string4;
        int n = 0;
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string8 = string5 = (string = string7);
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toUpperCase()");
        string = string9;
        string5 = lowercase;
        n = 1;
        stringBuilder = stringBuilder.append(string);
        String string10 = string5;
        if (string10 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string11 = string10.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
        string = string11;
        String message = stringBuilder.append(string).toString();
        this.showForegroundNotification(100, percent, false, message);
    }

    public HeapAnalyzerService() {
        String string2 = HeapAnalyzerService.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"HeapAnalyzerService::class.java.simpleName");
        super(string2, R.string.leak_canary_notification_analysing);
    }
}

