/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.deobfuscation;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\nR\u001e\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/squareup/leakcanary/deobfuscation/CopyObfuscationMappingFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "leakCanaryAssetsOutputFile", "Ljava/io/File;", "getLeakCanaryAssetsOutputFile", "()Ljava/io/File;", "mappingFile", "getMappingFile", "setMappingFile", "(Ljava/io/File;)V", "mergeAssetsDirectory", "getMergeAssetsDirectory", "setMergeAssetsDirectory", "variantName", "", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "copyObfuscationMappingFile", "", "validateMappingFile", "validateMergeAssetsDir", "leakcanary-deobfuscation-gradle-plugin"})
public class CopyObfuscationMappingFileTask
extends DefaultTask {
    @Input
    @NotNull
    private String variantName = "";
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Nullable
    private File mappingFile;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Nullable
    private File mergeAssetsDirectory;

    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    public final void setVariantName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @Nullable
    public final File getMappingFile() {
        return this.mappingFile;
    }

    public final void setMappingFile(@Nullable File file) {
        this.mappingFile = file;
    }

    @Nullable
    public final File getMergeAssetsDirectory() {
        return this.mergeAssetsDirectory;
    }

    public final void setMergeAssetsDirectory(@Nullable File file) {
        this.mergeAssetsDirectory = file;
    }

    @OutputFile
    @NotNull
    public final File getLeakCanaryAssetsOutputFile() {
        return new File(this.mergeAssetsDirectory, "leakCanaryObfuscationMapping.txt");
    }

    @TaskAction
    public final void copyObfuscationMappingFile() {
        File mapping = this.validateMappingFile();
        this.validateMergeAssetsDir();
        FilesKt.copyTo$default((File)mapping, (File)this.getLeakCanaryAssetsOutputFile(), (boolean)true, (int)0, (int)4, null);
    }

    private final File validateMappingFile() {
        File mapping = this.mappingFile;
        if (mapping == null || !mapping.exists()) {
            throw (Throwable)new GradleException("\n        The plugin was configured to be applied to a variant which doesn't define \n        an obfuscation mapping file: make sure that isMinified is true for variant: " + this.variantName + ".\n        ");
        }
        return mapping;
    }

    private final void validateMergeAssetsDir() {
        File file = this.mergeAssetsDirectory;
        if (file != null) {
            boolean mergeAssetsDirCreated;
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File mergeAssetsDir = file2;
            boolean bl3 = false;
            if (!mergeAssetsDir.exists() && !(mergeAssetsDirCreated = mergeAssetsDir.mkdirs())) {
                throw (Throwable)new GradleException("Obfuscation mapping destination dir doesn't exist and it's impossible to create it.");
            }
        } else {
            throw (Throwable)new GradleException("Obfuscation mapping is null.");
        }
    }

    public CopyObfuscationMappingFileTask() {
        this.setDescription("Puts obfuscation mapping file in assets directory.");
    }
}

