/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.deobfuscation;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/squareup/leakcanary/deobfuscation/CopyObfuscationMappingFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "leakCanaryAssetsOutputFile", "Ljava/io/File;", "getLeakCanaryAssetsOutputFile", "()Ljava/io/File;", "mappingFile", "Lorg/gradle/api/provider/Property;", "getMappingFile", "()Lorg/gradle/api/provider/Property;", "mergeAssetsDirectory", "getMergeAssetsDirectory", "variantName", "", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "copyObfuscationMappingFile", "", "validateMappingFile", "validateMergeAssetsDir", "leakcanary-deobfuscation-gradle-plugin"})
public abstract class CopyObfuscationMappingFileTask
extends DefaultTask {
    @Input
    @NotNull
    private String variantName = "";

    public CopyObfuscationMappingFileTask() {
        this.setDescription("Puts obfuscation mapping file in assets directory.");
    }

    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    public final void setVariantName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract Property<File> getMappingFile();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract Property<File> getMergeAssetsDirectory();

    @OutputFile
    @NotNull
    public final File getLeakCanaryAssetsOutputFile() {
        return new File((File)this.getMergeAssetsDirectory().getOrNull(), "leakCanaryObfuscationMapping.txt");
    }

    @TaskAction
    public final void copyObfuscationMappingFile() {
        File mapping = this.validateMappingFile();
        this.validateMergeAssetsDir();
        FilesKt.copyTo$default((File)mapping, (File)this.getLeakCanaryAssetsOutputFile(), (boolean)true, (int)0, (int)4, null);
    }

    private final File validateMappingFile() {
        File mapping = (File)this.getMappingFile().getOrNull();
        if (mapping == null || !mapping.exists()) {
            throw new GradleException("\n        The plugin was configured to be applied to a variant which doesn't define\n        an obfuscation mapping file: make sure that isMinified is true for variant: " + this.variantName + ".\n        ");
        }
        return mapping;
    }

    private final void validateMergeAssetsDir() {
        Unit unit;
        File file = (File)this.getMergeAssetsDirectory().getOrNull();
        if (file != null) {
            boolean mergeAssetsDirCreated;
            File mergeAssetsDir = file;
            boolean bl = false;
            if (!mergeAssetsDir.exists() && !(mergeAssetsDirCreated = mergeAssetsDir.mkdirs())) {
                throw new GradleException("Obfuscation mapping destination dir doesn't exist and it's impossible to create it.");
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new GradleException("Obfuscation mapping is null.");
        }
    }
}

