/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RecentlyNonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import leakcanary.AppWatcher;
import leakcanary.ObjectWatcher;
import leakcanary.internal.AndroidOFragmentDestroyWatcher;
import leakcanary.internal.FragmentDestroyWatcher;
import leakcanary.internal.InternalAppWatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J<\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J$\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lleakcanary/internal/FragmentDestroyWatcher;", "", "()V", "ANDROIDX_FRAGMENT_CLASS_NAME", "", "ANDROIDX_FRAGMENT_DESTROY_WATCHER_CLASS_NAME", "ANDROID_SUPPORT_FRAGMENT_CLASS_NAME", "ANDROID_SUPPORT_FRAGMENT_DESTROY_WATCHER_CLASS_NAME", "classAvailable", "", "className", "getWatcherIfAvailable", "Lkotlin/Function1;", "Landroid/app/Activity;", "", "fragmentClassName", "watcherClassName", "objectWatcher", "Lleakcanary/ObjectWatcher;", "configProvider", "Lkotlin/Function0;", "Lleakcanary/AppWatcher$Config;", "install", "application", "Landroid/app/Application;", "leakcanary-object-watcher-android_release"})
public final class FragmentDestroyWatcher {
    private static final String ANDROIDX_FRAGMENT_CLASS_NAME = "androidx.fragment.app.Fragment";
    private static final String ANDROIDX_FRAGMENT_DESTROY_WATCHER_CLASS_NAME = "leakcanary.internal.AndroidXFragmentDestroyWatcher";
    private static final String ANDROID_SUPPORT_FRAGMENT_CLASS_NAME = "android.support.v4.app.Fragment";
    private static final String ANDROID_SUPPORT_FRAGMENT_DESTROY_WATCHER_CLASS_NAME = "leakcanary.internal.AndroidSupportFragmentDestroyWatcher";
    public static final FragmentDestroyWatcher INSTANCE;

    public final void install(@NotNull Application application, @NotNull ObjectWatcher objectWatcher2, @NotNull Function0<AppWatcher.Config> configProvider2) {
        Function1<Activity, Unit> it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)objectWatcher2, (String)"objectWatcher");
        Intrinsics.checkParameterIsNotNull(configProvider2, (String)"configProvider");
        boolean bl3 = false;
        List fragmentDestroyWatchers = new ArrayList();
        if (Build.VERSION.SDK_INT >= 26) {
            fragmentDestroyWatchers.add(new AndroidOFragmentDestroyWatcher(objectWatcher2, configProvider2));
        }
        Function1<Activity, Unit> function1 = this.getWatcherIfAvailable(ANDROIDX_FRAGMENT_CLASS_NAME, ANDROIDX_FRAGMENT_DESTROY_WATCHER_CLASS_NAME, objectWatcher2, configProvider2);
        if (function1 != null) {
            Function1<Activity, Unit> function12 = function1;
            bl2 = false;
            bl = false;
            it = function12;
            boolean bl4 = false;
            fragmentDestroyWatchers.add(it);
        }
        Function1<Activity, Unit> function13 = this.getWatcherIfAvailable(ANDROID_SUPPORT_FRAGMENT_CLASS_NAME, ANDROID_SUPPORT_FRAGMENT_DESTROY_WATCHER_CLASS_NAME, objectWatcher2, configProvider2);
        if (function13 != null) {
            Function1<Activity, Unit> function14 = function13;
            bl2 = false;
            bl = false;
            it = function14;
            boolean bl5 = false;
            fragmentDestroyWatchers.add(it);
        }
        if (fragmentDestroyWatchers.size() == 0) {
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(fragmentDestroyWatchers){
            private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
            final /* synthetic */ List $fragmentDestroyWatchers;

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                for (Function1 watcher : this.$fragmentDestroyWatchers) {
                    watcher.invoke((Object)activity);
                }
            }
            {
                Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
                this.$fragmentDestroyWatchers = $captured_local_variable$0;
                InternalAppWatcher internalAppWatcher = InternalAppWatcher.INSTANCE;
                install.3 var6_3 = this;
                boolean $i$f$noOpDelegate = false;
                Class<Application.ActivityLifecycleCallbacks> javaClass$iv = Application.ActivityLifecycleCallbacks.class;
                InvocationHandler noOpHandler$iv = InternalAppWatcher.noOpDelegate.noOpHandler.1.INSTANCE;
                Object object = Proxy.newProxyInstance(javaClass$iv.getClassLoader(), new Class[]{javaClass$iv}, noOpHandler$iv);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                }
                var6_3.$$delegate_0 = activityLifecycleCallbacks = (Application.ActivityLifecycleCallbacks)object;
            }

            public void onActivityDestroyed(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityDestroyed(p0);
            }

            public void onActivityPaused(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityPaused(p0);
            }

            public void onActivityResumed(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityResumed(p0);
            }

            public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
            }

            public void onActivityStarted(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStarted(p0);
            }

            public void onActivityStopped(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStopped(p0);
            }
        });
    }

    private final Function1<Activity, Unit> getWatcherIfAvailable(String fragmentClassName, String watcherClassName, ObjectWatcher objectWatcher2, Function0<AppWatcher.Config> configProvider2) {
        Function1 function1;
        if (this.classAvailable(fragmentClassName) && this.classAvailable(watcherClassName)) {
            Constructor<?> constructor = Class.forName(watcherClassName).getDeclaredConstructor(ObjectWatcher.class, Function0.class);
            Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"Class.forName(watcherCla\u2026a, Function0::class.java)");
            Constructor<?> watcherConstructor = constructor;
            Object obj = watcherConstructor.newInstance(objectWatcher2, configProvider2);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type (android.app.Activity) -> kotlin.Unit");
            }
            function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(obj, (int)1);
        } else {
            function1 = null;
        }
        return function1;
    }

    private final boolean classAvailable(String className) {
        boolean bl;
        try {
            Class.forName(className);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    private FragmentDestroyWatcher() {
    }

    static {
        FragmentDestroyWatcher fragmentDestroyWatcher;
        INSTANCE = fragmentDestroyWatcher = new FragmentDestroyWatcher();
    }
}

