/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.Clock;
import leakcanary.KeyedWeakReference;
import leakcanary.OnObjectRetainedListener;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020!J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u001eH\u0002J\u000e\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011J\b\u0010*\u001a\u00020!H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0001H\u0007J\u0016\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lleakcanary/ObjectWatcher;", "", "clock", "Lleakcanary/Clock;", "checkRetainedExecutor", "Ljava/util/concurrent/Executor;", "isEnabled", "Lkotlin/Function0;", "", "(Lleakcanary/Clock;Ljava/util/concurrent/Executor;Lkotlin/jvm/functions/Function0;)V", "hasRetainedObjects", "getHasRetainedObjects", "()Z", "hasWatchedObjects", "getHasWatchedObjects", "onObjectRetainedListeners", "", "Lleakcanary/OnObjectRetainedListener;", "queue", "Ljava/lang/ref/ReferenceQueue;", "retainedObjectCount", "", "getRetainedObjectCount", "()I", "retainedObjects", "", "getRetainedObjects", "()Ljava/util/List;", "watchedObjects", "", "", "Lleakcanary/KeyedWeakReference;", "addOnObjectRetainedListener", "", "listener", "clearObjectsWatchedBefore", "heapDumpUptimeMillis", "", "clearWatchedObjects", "moveToRetained", "key", "removeOnObjectRetainedListener", "removeWeaklyReachableObjects", "watch", "watchedObject", "description", "leakcanary-object-watcher"})
public final class ObjectWatcher {
    private final Set<OnObjectRetainedListener> onObjectRetainedListeners;
    private final Map<String, KeyedWeakReference> watchedObjects;
    private final ReferenceQueue<Object> queue;
    private final Clock clock;
    private final Executor checkRetainedExecutor;
    private final Function0<Boolean> isEnabled;

    public final synchronized boolean getHasRetainedObjects() {
        boolean bl;
        block3: {
            this.removeWeaklyReachableObjects();
            Map<String, KeyedWeakReference> $this$any$iv = this.watchedObjects;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Map<String, KeyedWeakReference> map = $this$any$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, KeyedWeakReference>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KeyedWeakReference> element$iv;
                    Map.Entry<String, KeyedWeakReference> it = element$iv = iterator.next();
                    boolean bl3 = false;
                    if (!(it.getValue().getRetainedUptimeMillis() != -1L)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int getRetainedObjectCount() {
        int n;
        this.removeWeaklyReachableObjects();
        Map<String, KeyedWeakReference> $this$count$iv = this.watchedObjects;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Map<String, KeyedWeakReference> map = $this$count$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, KeyedWeakReference>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, KeyedWeakReference> element$iv;
                Map.Entry<String, KeyedWeakReference> it = element$iv = iterator.next();
                boolean bl2 = false;
                if (!(it.getValue().getRetainedUptimeMillis() != -1L)) continue;
                ++count$iv;
            }
            n = var3_3;
        }
        return n;
    }

    public final synchronized boolean getHasWatchedObjects() {
        this.removeWeaklyReachableObjects();
        Map<String, KeyedWeakReference> map = this.watchedObjects;
        boolean bl = false;
        return !map.isEmpty();
    }

    @NotNull
    public final synchronized List<Object> getRetainedObjects() {
        this.removeWeaklyReachableObjects();
        boolean bl = false;
        List instances = new ArrayList();
        for (KeyedWeakReference weakReference : this.watchedObjects.values()) {
            Object instance;
            if (weakReference.getRetainedUptimeMillis() == -1L || (instance = weakReference.get()) == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public final synchronized void addOnObjectRetainedListener(@NotNull OnObjectRetainedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onObjectRetainedListeners.add(listener);
    }

    public final synchronized void removeOnObjectRetainedListener(@NotNull OnObjectRetainedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onObjectRetainedListeners.remove(listener);
    }

    @Deprecated(message="Add description parameter explaining why an object is watched to help understand leak traces.", replaceWith=@ReplaceWith(imports={}, expression="watch(watchedObject, \"Explain why this object should be garbage collected soon\")"))
    public final synchronized void watch(@NotNull Object watchedObject) {
        Intrinsics.checkParameterIsNotNull((Object)watchedObject, (String)"watchedObject");
        this.watch(watchedObject, "");
    }

    public final synchronized void watch(@NotNull Object watchedObject, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)watchedObject, (String)"watchedObject");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        if (!((Boolean)this.isEnabled.invoke()).booleanValue()) {
            return;
        }
        this.removeWeaklyReachableObjects();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID()\n        .toString()");
        String key = string;
        long watchUptimeMillis = this.clock.uptimeMillis();
        KeyedWeakReference reference = new KeyedWeakReference(watchedObject, key, description, watchUptimeMillis, this.queue);
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            CharSequence charSequence = description;
            StringBuilder stringBuilder = new StringBuilder().append("Watching ").append(watchedObject instanceof Class ? watchedObject.toString() : "instance of " + watchedObject.getClass().getName());
            boolean bl2 = false;
            boolean bl3 = charSequence.length() > 0;
            String string2 = stringBuilder.append(bl3 ? " (" + description + ')' : "").append(" with key ").append(key).toString();
            logger2.d(string2);
        }
        this.watchedObjects.put(key, reference);
        this.checkRetainedExecutor.execute(new Runnable(this, key){
            final /* synthetic */ ObjectWatcher this$0;
            final /* synthetic */ String $key;

            public final void run() {
                ObjectWatcher.access$moveToRetained(this.this$0, this.$key);
            }
            {
                this.this$0 = objectWatcher;
                this.$key = string;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void clearObjectsWatchedBefore(long heapDumpUptimeMillis) {
        void $this$filterTo$iv$iv;
        Map<String, KeyedWeakReference> $this$filter$iv = this.watchedObjects;
        boolean $i$f$filter = false;
        Map<String, KeyedWeakReference> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((KeyedWeakReference)it.getValue()).getWatchUptimeMillis() <= heapDumpUptimeMillis)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map weakRefsToRemove = destination$iv$iv;
        Iterable $this$forEach$iv = weakRefsToRemove.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyedWeakReference it = (KeyedWeakReference)element$iv;
            boolean bl3 = false;
            it.clear();
        }
        this.watchedObjects.keySet().removeAll(weakRefsToRemove.keySet());
    }

    public final synchronized void clearWatchedObjects() {
        Iterable $this$forEach$iv = this.watchedObjects.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyedWeakReference it = (KeyedWeakReference)element$iv;
            boolean bl = false;
            it.clear();
        }
        this.watchedObjects.clear();
    }

    private final synchronized void moveToRetained(String key) {
        this.removeWeaklyReachableObjects();
        KeyedWeakReference retainedRef = this.watchedObjects.get(key);
        if (retainedRef != null) {
            retainedRef.setRetainedUptimeMillis(this.clock.uptimeMillis());
            Iterable $this$forEach$iv = this.onObjectRetainedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OnObjectRetainedListener it = (OnObjectRetainedListener)element$iv;
                boolean bl = false;
                it.onObjectRetained();
            }
        }
    }

    private final void removeWeaklyReachableObjects() {
        KeyedWeakReference ref = null;
        do {
            if ((ref = (KeyedWeakReference)this.queue.poll()) == null) continue;
            this.watchedObjects.remove(ref.getKey());
        } while (ref != null);
    }

    public ObjectWatcher(@NotNull Clock clock, @NotNull Executor checkRetainedExecutor, @NotNull Function0<Boolean> isEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)checkRetainedExecutor, (String)"checkRetainedExecutor");
        Intrinsics.checkParameterIsNotNull(isEnabled, (String)"isEnabled");
        this.clock = clock;
        this.checkRetainedExecutor = checkRetainedExecutor;
        this.isEnabled = isEnabled;
        ObjectWatcher objectWatcher = this;
        boolean bl = false;
        Object object = new LinkedHashSet();
        objectWatcher.onObjectRetainedListeners = object;
        objectWatcher = this;
        bl = false;
        objectWatcher.watchedObjects = object = (Map)new LinkedHashMap();
        this.queue = new ReferenceQueue();
    }

    public /* synthetic */ ObjectWatcher(Clock clock, Executor executor, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(clock, executor, (Function0<Boolean>)function0);
    }

    public static final /* synthetic */ void access$moveToRetained(ObjectWatcher $this, String key) {
        $this.moveToRetained(key);
    }
}

