/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import leakcanary.KeyedWeakReference;
import leakcanary.OnObjectRetainedListener;
import leakcanary.RetainedObjectTracker;
import leakcanary.TriggeredDeletableObjectReporter;
import leakcanary.UptimeClock;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010!\u001a\u00020\"H\u0016J\u001d\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020 H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00170\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lleakcanary/ReferenceQueueRetainedObjectTracker;", "Lleakcanary/RetainedObjectTracker;", "Lleakcanary/TriggeredDeletableObjectReporter;", "clock", "Lleakcanary/UptimeClock;", "onObjectRetainedListener", "Lleakcanary/OnObjectRetainedListener;", "(Lleakcanary/UptimeClock;Lleakcanary/OnObjectRetainedListener;)V", "hasRetainedObjects", "", "getHasRetainedObjects", "()Z", "hasTrackedObjects", "getHasTrackedObjects", "queue", "Ljava/lang/ref/ReferenceQueue;", "", "retainedObjectCount", "", "getRetainedObjectCount", "()I", "retainedWeakReferences", "", "Lleakcanary/KeyedWeakReference;", "getRetainedWeakReferences", "()Ljava/util/List;", "trackedObjectCount", "getTrackedObjectCount", "trackedWeakReferences", "getTrackedWeakReferences", "watchedObjects", "", "", "clearAllObjectsTracked", "", "clearObjectsTrackedBefore", "uptime", "Lkotlin/time/Duration;", "clearObjectsTrackedBefore-LRDsOJo", "(J)V", "expectDeletionOnTriggerFor", "Lleakcanary/TriggeredDeletableObjectReporter$RetainTrigger;", "target", "reason", "moveToRetained", "key", "removeWeaklyReachableObjects", "object-watcher"})
@SourceDebugExtension(value={"SMAP\nReferenceQueueRetainedObjectTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceQueueRetainedObjectTracker.kt\nleakcanary/ReferenceQueueRetainedObjectTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 SharkLog.kt\nshark/SharkLog\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n766#2:159\n857#2,2:160\n1855#2,2:179\n1855#2,2:181\n187#3,3:162\n204#3,4:165\n34#4,3:169\n515#5:172\n500#5,6:173\n*S KotlinDebug\n*F\n+ 1 ReferenceQueueRetainedObjectTracker.kt\nleakcanary/ReferenceQueueRetainedObjectTracker\n*L\n56#1:159\n56#1:160,2\n125#1:179,2\n133#1:181,2\n62#1:162,3\n68#1:165,4\n93#1:169,3\n124#1:172\n124#1:173,6\n*E\n"})
public final class ReferenceQueueRetainedObjectTracker
implements RetainedObjectTracker,
TriggeredDeletableObjectReporter {
    @NotNull
    private final UptimeClock clock;
    @NotNull
    private final OnObjectRetainedListener onObjectRetainedListener;
    @NotNull
    private final Map<String, KeyedWeakReference> watchedObjects;
    @NotNull
    private final ReferenceQueue<Object> queue;

    public ReferenceQueueRetainedObjectTracker(@NotNull UptimeClock clock, @NotNull OnObjectRetainedListener onObjectRetainedListener) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)onObjectRetainedListener, (String)"onObjectRetainedListener");
        this.clock = clock;
        this.onObjectRetainedListener = onObjectRetainedListener;
        this.watchedObjects = new ConcurrentHashMap();
        this.queue = new ReferenceQueue();
    }

    @NotNull
    public final List<KeyedWeakReference> getTrackedWeakReferences() {
        this.removeWeaklyReachableObjects();
        return CollectionsKt.toList((Iterable)this.watchedObjects.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KeyedWeakReference> getRetainedWeakReferences() {
        void $this$filterTo$iv$iv;
        this.removeWeaklyReachableObjects();
        Iterable $this$filter$iv = this.watchedObjects.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KeyedWeakReference it = (KeyedWeakReference)element$iv$iv;
            boolean bl = false;
            if (!it.getRetained()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    public boolean getHasRetainedObjects() {
        boolean bl;
        block3: {
            this.removeWeaklyReachableObjects();
            Map<String, KeyedWeakReference> $this$any$iv = this.watchedObjects;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, KeyedWeakReference>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KeyedWeakReference> element$iv;
                    Map.Entry<String, KeyedWeakReference> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!it.getValue().getRetained()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getRetainedObjectCount() {
        int n;
        this.removeWeaklyReachableObjects();
        Map<String, KeyedWeakReference> $this$count$iv = this.watchedObjects;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Iterator<Map.Entry<String, KeyedWeakReference>> iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, KeyedWeakReference> element$iv;
                Map.Entry<String, KeyedWeakReference> it = element$iv = iterator.next();
                boolean bl = false;
                if (!it.getValue().getRetained()) continue;
                ++count$iv;
            }
            n = var3_3;
        }
        return n;
    }

    @Override
    public boolean getHasTrackedObjects() {
        this.removeWeaklyReachableObjects();
        return !this.watchedObjects.isEmpty();
    }

    @Override
    public int getTrackedObjectCount() {
        this.removeWeaklyReachableObjects();
        return this.watchedObjects.size();
    }

    @Override
    @NotNull
    public TriggeredDeletableObjectReporter.RetainTrigger expectDeletionOnTriggerFor(@NotNull Object target, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.removeWeaklyReachableObjects();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID()\n      .toString()");
        String key = string;
        long watchUptime = this.clock.uptime-UwyO8pc();
        KeyedWeakReference reference = new KeyedWeakReference(target, key, reason, Duration.getInWholeMilliseconds-impl((long)watchUptime), this.queue);
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger != null) {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            logger2.d("Watching " + (target instanceof Class ? target.toString() : "instance of " + target.getClass().getName()) + (((CharSequence)reason).length() > 0 ? " (" + reason + ')' : "") + " with key " + key);
        }
        this.watchedObjects.put(key, reference);
        return new TriggeredDeletableObjectReporter.RetainTrigger(this, key){
            final /* synthetic */ ReferenceQueueRetainedObjectTracker this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
            }

            public boolean isStronglyReachable() {
                ReferenceQueueRetainedObjectTracker.access$removeWeaklyReachableObjects(this.this$0);
                KeyedWeakReference weakRef = (KeyedWeakReference)ReferenceQueueRetainedObjectTracker.access$getWatchedObjects$p(this.this$0).get(this.$key);
                return weakRef != null;
            }

            public boolean isRetained() {
                KeyedWeakReference weakRef;
                ReferenceQueueRetainedObjectTracker.access$removeWeaklyReachableObjects(this.this$0);
                KeyedWeakReference keyedWeakReference = weakRef = (KeyedWeakReference)ReferenceQueueRetainedObjectTracker.access$getWatchedObjects$p(this.this$0).get(this.$key);
                return keyedWeakReference != null ? keyedWeakReference.getRetained() : false;
            }

            public void markRetainedIfStronglyReachable() {
                ReferenceQueueRetainedObjectTracker.access$moveToRetained(this.this$0, this.$key);
            }

            public boolean isDeletable() {
                return TriggeredDeletableObjectReporter.RetainTrigger.DefaultImpls.isDeletable(this);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearObjectsTrackedBefore-LRDsOJo(long uptime) {
        void $this$filterTo$iv$iv;
        Map<String, KeyedWeakReference> $this$filter$iv = this.watchedObjects;
        boolean $i$f$filter = false;
        Map<String, KeyedWeakReference> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((KeyedWeakReference)it.getValue()).getWatchUptimeMillis() <= Duration.getInWholeMilliseconds-impl((long)uptime))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map weakRefsToRemove = destination$iv$iv;
        Iterable $this$forEach$iv = weakRefsToRemove.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyedWeakReference it = (KeyedWeakReference)element$iv;
            boolean bl = false;
            it.clear();
        }
        this.watchedObjects.keySet().removeAll(weakRefsToRemove.keySet());
    }

    @Override
    public void clearAllObjectsTracked() {
        Iterable $this$forEach$iv = this.watchedObjects.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyedWeakReference it = (KeyedWeakReference)element$iv;
            boolean bl = false;
            it.clear();
        }
        this.watchedObjects.clear();
    }

    private final void moveToRetained(String key) {
        this.removeWeaklyReachableObjects();
        KeyedWeakReference retainedRef = this.watchedObjects.get(key);
        if (retainedRef != null) {
            retainedRef.setRetainedUptimeMillis(Duration.getInWholeMilliseconds-impl((long)this.clock.uptime-UwyO8pc()));
            this.onObjectRetainedListener.onObjectRetained();
        }
    }

    private final void removeWeaklyReachableObjects() {
        KeyedWeakReference ref = null;
        do {
            if ((ref = (KeyedWeakReference)this.queue.poll()) == null) continue;
            this.watchedObjects.remove(ref.getKey());
        } while (ref != null);
    }

    public static final /* synthetic */ void access$removeWeaklyReachableObjects(ReferenceQueueRetainedObjectTracker $this) {
        $this.removeWeaklyReachableObjects();
    }

    public static final /* synthetic */ Map access$getWatchedObjects$p(ReferenceQueueRetainedObjectTracker $this) {
        return $this.watchedObjects;
    }

    public static final /* synthetic */ void access$moveToRetained(ReferenceQueueRetainedObjectTracker $this, String key) {
        $this.moveToRetained(key);
    }
}

