/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Exclusion;
import com.squareup.leakcanary.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ExcludedRefs
implements Serializable {
    public final Map<String, Map<String, Exclusion>> fieldNameByClassName;
    public final Map<String, Map<String, Exclusion>> staticFieldNameByClassName;
    public final Map<String, Exclusion> threadNames;
    public final Map<String, Exclusion> classNames;

    public static Builder builder() {
        return new BuilderWithParams();
    }

    ExcludedRefs(BuilderWithParams builder) {
        this.fieldNameByClassName = this.unmodifiableRefStringMap(builder.fieldNameByClassName);
        this.staticFieldNameByClassName = this.unmodifiableRefStringMap(builder.staticFieldNameByClassName);
        this.threadNames = this.unmodifiableRefMap(builder.threadNames);
        this.classNames = this.unmodifiableRefMap(builder.classNames);
    }

    private Map<String, Map<String, Exclusion>> unmodifiableRefStringMap(Map<String, Map<String, ParamsBuilder>> mapmap) {
        LinkedHashMap<String, Map<String, Exclusion>> fieldNameByClassName = new LinkedHashMap<String, Map<String, Exclusion>>();
        for (Map.Entry<String, Map<String, ParamsBuilder>> entry : mapmap.entrySet()) {
            fieldNameByClassName.put(entry.getKey(), this.unmodifiableRefMap(entry.getValue()));
        }
        return Collections.unmodifiableMap(fieldNameByClassName);
    }

    private Map<String, Exclusion> unmodifiableRefMap(Map<String, ParamsBuilder> fieldBuilderMap) {
        LinkedHashMap<String, Exclusion> fieldMap = new LinkedHashMap<String, Exclusion>();
        for (Map.Entry<String, ParamsBuilder> fieldEntry : fieldBuilderMap.entrySet()) {
            fieldMap.put(fieldEntry.getKey(), new Exclusion(fieldEntry.getValue()));
        }
        return Collections.unmodifiableMap(fieldMap);
    }

    public String toString() {
        String always;
        String clazz;
        String string = "";
        for (Map.Entry<String, Map<String, Exclusion>> entry : this.fieldNameByClassName.entrySet()) {
            clazz = entry.getKey();
            for (Map.Entry<String, Exclusion> field : entry.getValue().entrySet()) {
                String always2 = field.getValue().alwaysExclude ? " (always)" : "";
                string = string + "| Field: " + clazz + "." + field.getKey() + always2 + "\n";
            }
        }
        for (Map.Entry<String, Map<String, Exclusion>> entry : this.staticFieldNameByClassName.entrySet()) {
            clazz = entry.getKey();
            for (Map.Entry<String, Exclusion> field : entry.getValue().entrySet()) {
                String always2 = field.getValue().alwaysExclude ? " (always)" : "";
                string = string + "| Static field: " + clazz + "." + field.getKey() + always2 + "\n";
            }
        }
        for (Map.Entry<String, Object> entry : this.threadNames.entrySet()) {
            always = ((Exclusion)entry.getValue()).alwaysExclude ? " (always)" : "";
            string = string + "| Thread:" + entry.getKey() + always + "\n";
        }
        for (Map.Entry<String, Object> entry : this.classNames.entrySet()) {
            always = ((Exclusion)entry.getValue()).alwaysExclude ? " (always)" : "";
            string = string + "| Class:" + entry.getKey() + always + "\n";
        }
        return string;
    }

    public static final class BuilderWithParams
    implements Builder {
        private final Map<String, Map<String, ParamsBuilder>> fieldNameByClassName = new LinkedHashMap<String, Map<String, ParamsBuilder>>();
        private final Map<String, Map<String, ParamsBuilder>> staticFieldNameByClassName = new LinkedHashMap<String, Map<String, ParamsBuilder>>();
        private final Map<String, ParamsBuilder> threadNames = new LinkedHashMap<String, ParamsBuilder>();
        private final Map<String, ParamsBuilder> classNames = new LinkedHashMap<String, ParamsBuilder>();
        private ParamsBuilder lastParams;

        BuilderWithParams() {
        }

        @Override
        public BuilderWithParams instanceField(String className, String fieldName) {
            Preconditions.checkNotNull(className, "className");
            Preconditions.checkNotNull(fieldName, "fieldName");
            Map<String, ParamsBuilder> excludedFields = this.fieldNameByClassName.get(className);
            if (excludedFields == null) {
                excludedFields = new LinkedHashMap<String, ParamsBuilder>();
                this.fieldNameByClassName.put(className, excludedFields);
            }
            this.lastParams = new ParamsBuilder("field " + className + "#" + fieldName);
            excludedFields.put(fieldName, this.lastParams);
            return this;
        }

        @Override
        public BuilderWithParams staticField(String className, String fieldName) {
            Preconditions.checkNotNull(className, "className");
            Preconditions.checkNotNull(fieldName, "fieldName");
            Map<String, ParamsBuilder> excludedFields = this.staticFieldNameByClassName.get(className);
            if (excludedFields == null) {
                excludedFields = new LinkedHashMap<String, ParamsBuilder>();
                this.staticFieldNameByClassName.put(className, excludedFields);
            }
            this.lastParams = new ParamsBuilder("static field " + className + "#" + fieldName);
            excludedFields.put(fieldName, this.lastParams);
            return this;
        }

        @Override
        public BuilderWithParams thread(String threadName) {
            Preconditions.checkNotNull(threadName, "threadName");
            this.lastParams = new ParamsBuilder("any threads named " + threadName);
            this.threadNames.put(threadName, this.lastParams);
            return this;
        }

        @Override
        public BuilderWithParams clazz(String className) {
            Preconditions.checkNotNull(className, "className");
            this.lastParams = new ParamsBuilder("any subclass of " + className);
            this.classNames.put(className, this.lastParams);
            return this;
        }

        public BuilderWithParams named(String name) {
            this.lastParams.name = name;
            return this;
        }

        public BuilderWithParams reason(String reason) {
            this.lastParams.reason = reason;
            return this;
        }

        public BuilderWithParams alwaysExclude() {
            this.lastParams.alwaysExclude = true;
            return this;
        }

        @Override
        public ExcludedRefs build() {
            return new ExcludedRefs(this);
        }
    }

    public static interface Builder {
        public BuilderWithParams instanceField(String var1, String var2);

        public BuilderWithParams staticField(String var1, String var2);

        public BuilderWithParams thread(String var1);

        public BuilderWithParams clazz(String var1);

        public ExcludedRefs build();
    }

    static final class ParamsBuilder {
        String name;
        String reason;
        boolean alwaysExclude;
        final String matching;

        ParamsBuilder(String matching) {
            this.matching = matching;
        }
    }
}

