/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.WatchExecutor;

public class RefWatcherBuilder<T extends RefWatcherBuilder> {
    private ExcludedRefs excludedRefs;
    private HeapDump.Listener heapDumpListener;
    private DebuggerControl debuggerControl;
    private HeapDumper heapDumper;
    private WatchExecutor watchExecutor;
    private GcTrigger gcTrigger;

    public final T heapDumpListener(HeapDump.Listener heapDumpListener) {
        this.heapDumpListener = heapDumpListener;
        return this.self();
    }

    public final T excludedRefs(ExcludedRefs excludedRefs) {
        this.excludedRefs = excludedRefs;
        return this.self();
    }

    public final T heapDumper(HeapDumper heapDumper) {
        this.heapDumper = heapDumper;
        return this.self();
    }

    public final T debuggerControl(DebuggerControl debuggerControl) {
        this.debuggerControl = debuggerControl;
        return this.self();
    }

    public final T watchExecutor(WatchExecutor watchExecutor) {
        this.watchExecutor = watchExecutor;
        return this.self();
    }

    public final T gcTrigger(GcTrigger gcTrigger) {
        this.gcTrigger = gcTrigger;
        return this.self();
    }

    public final RefWatcher build() {
        GcTrigger gcTrigger;
        WatchExecutor watchExecutor;
        HeapDumper heapDumper;
        DebuggerControl debuggerControl;
        HeapDump.Listener heapDumpListener;
        if (this.isDisabled()) {
            return RefWatcher.DISABLED;
        }
        ExcludedRefs excludedRefs = this.excludedRefs;
        if (excludedRefs == null) {
            excludedRefs = this.defaultExcludedRefs();
        }
        if ((heapDumpListener = this.heapDumpListener) == null) {
            heapDumpListener = this.defaultHeapDumpListener();
        }
        if ((debuggerControl = this.debuggerControl) == null) {
            debuggerControl = this.defaultDebuggerControl();
        }
        if ((heapDumper = this.heapDumper) == null) {
            heapDumper = this.defaultHeapDumper();
        }
        if ((watchExecutor = this.watchExecutor) == null) {
            watchExecutor = this.defaultWatchExecutor();
        }
        if ((gcTrigger = this.gcTrigger) == null) {
            gcTrigger = this.defaultGcTrigger();
        }
        return new RefWatcher(watchExecutor, debuggerControl, gcTrigger, heapDumper, heapDumpListener, excludedRefs);
    }

    protected boolean isDisabled() {
        return false;
    }

    protected GcTrigger defaultGcTrigger() {
        return GcTrigger.DEFAULT;
    }

    protected DebuggerControl defaultDebuggerControl() {
        return DebuggerControl.NONE;
    }

    protected ExcludedRefs defaultExcludedRefs() {
        return ExcludedRefs.builder().build();
    }

    protected HeapDumper defaultHeapDumper() {
        return HeapDumper.NONE;
    }

    protected HeapDump.Listener defaultHeapDumpListener() {
        return HeapDump.Listener.NONE;
    }

    protected WatchExecutor defaultWatchExecutor() {
        return WatchExecutor.NONE;
    }

    protected final T self() {
        return (T)this;
    }
}

