/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.LeakTraceElement;
import java.io.Serializable;

public final class LeakReference
implements Serializable {
    public final LeakTraceElement.Type type;
    public final String name;
    public final String value;

    public LeakReference(LeakTraceElement.Type type, String name, String value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public String getDisplayName() {
        switch (this.type) {
            case ARRAY_ENTRY: {
                return "[" + this.name + "]";
            }
            case STATIC_FIELD: 
            case INSTANCE_FIELD: {
                return this.name;
            }
            case LOCAL: {
                return "<Java Local>";
            }
        }
        throw new IllegalStateException("Unexpected type " + (Object)((Object)this.type) + " name = " + this.name + " value = " + this.value);
    }

    public String toString() {
        switch (this.type) {
            case ARRAY_ENTRY: 
            case INSTANCE_FIELD: {
                return this.getDisplayName() + " = " + this.value;
            }
            case STATIC_FIELD: {
                return "static " + this.getDisplayName() + " = " + this.value;
            }
            case LOCAL: {
                return this.getDisplayName();
            }
        }
        throw new IllegalStateException("Unexpected type " + (Object)((Object)this.type) + " name = " + this.name + " value = " + this.value);
    }
}

