/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Exclusion;
import com.squareup.leakcanary.LeakReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class LeakTraceElement
implements Serializable {
    public final LeakReference reference;
    @Deprecated
    public final String referenceName;
    @Deprecated
    public final Type type;
    public final Holder holder;
    public final List<String> classHierarchy;
    public final String className;
    public final String extra;
    public final Exclusion exclusion;
    public final List<LeakReference> fieldReferences;
    @Deprecated
    public final List<String> fields;

    LeakTraceElement(LeakReference reference, Holder holder, List<String> classHierarchy, String extra, Exclusion exclusion, List<LeakReference> leakReferences) {
        this.reference = reference;
        this.referenceName = reference == null ? null : reference.getDisplayName();
        this.type = reference == null ? null : reference.type;
        this.holder = holder;
        this.classHierarchy = Collections.unmodifiableList(new ArrayList<String>(classHierarchy));
        this.className = classHierarchy.get(0);
        this.extra = extra;
        this.exclusion = exclusion;
        this.fieldReferences = Collections.unmodifiableList(new ArrayList<LeakReference>(leakReferences));
        ArrayList<String> stringFields = new ArrayList<String>();
        for (LeakReference leakReference : leakReferences) {
            stringFields.add(leakReference.toString());
        }
        this.fields = Collections.unmodifiableList(stringFields);
    }

    public String getFieldReferenceValue(String referenceName) {
        for (LeakReference fieldReference : this.fieldReferences) {
            if (!fieldReference.name.equals(referenceName)) continue;
            return fieldReference.value;
        }
        return null;
    }

    public boolean isInstanceOf(Class<?> expectedClass) {
        return this.isInstanceOf(expectedClass.getName());
    }

    public boolean isInstanceOf(String expectedClassName) {
        for (String className : this.classHierarchy) {
            if (!className.equals(expectedClassName)) continue;
            return true;
        }
        return false;
    }

    public String getSimpleClassName() {
        int separator = this.className.lastIndexOf(46);
        if (separator == -1) {
            return this.className;
        }
        return this.className.substring(separator + 1);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean maybeLeakCause) {
        String string = "";
        if (this.reference != null && this.reference.type == Type.STATIC_FIELD) {
            string = string + "static ";
        }
        if (this.holder == Holder.ARRAY || this.holder == Holder.THREAD) {
            string = string + this.holder.name().toLowerCase(Locale.US) + " ";
        }
        string = string + this.getSimpleClassName();
        if (this.reference != null) {
            String referenceName = this.reference.getDisplayName();
            if (maybeLeakCause) {
                referenceName = "!(" + referenceName + ")!";
            }
            string = string + "." + referenceName;
        }
        if (this.extra != null) {
            string = string + " " + this.extra;
        }
        if (this.exclusion != null) {
            string = string + " , matching exclusion " + this.exclusion.matching;
        }
        return string;
    }

    public String toDetailedString() {
        String string = "* ";
        string = this.holder == Holder.ARRAY ? string + "Array of" : (this.holder == Holder.CLASS ? string + "Class" : string + "Instance of");
        string = string + " " + this.className + "\n";
        for (LeakReference leakReference : this.fieldReferences) {
            string = string + "|   " + leakReference + "\n";
        }
        return string;
    }

    public static enum Holder {
        OBJECT,
        CLASS,
        THREAD,
        ARRAY;

    }

    public static enum Type {
        INSTANCE_FIELD,
        STATIC_FIELD,
        LOCAL,
        ARRAY_ENTRY;

    }
}

