/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.Reachability;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.WatchExecutor;
import java.util.Collections;
import java.util.List;

public class RefWatcherBuilder<T extends RefWatcherBuilder<T>> {
    private HeapDump.Listener heapDumpListener;
    private DebuggerControl debuggerControl;
    private HeapDumper heapDumper;
    private WatchExecutor watchExecutor;
    private GcTrigger gcTrigger;
    private final HeapDump.Builder heapDumpBuilder = new HeapDump.Builder();

    public final T heapDumpListener(HeapDump.Listener heapDumpListener) {
        this.heapDumpListener = heapDumpListener;
        return this.self();
    }

    public final T excludedRefs(ExcludedRefs excludedRefs) {
        this.heapDumpBuilder.excludedRefs(excludedRefs);
        return this.self();
    }

    public final T heapDumper(HeapDumper heapDumper) {
        this.heapDumper = heapDumper;
        return this.self();
    }

    public final T debuggerControl(DebuggerControl debuggerControl) {
        this.debuggerControl = debuggerControl;
        return this.self();
    }

    public final T watchExecutor(WatchExecutor watchExecutor) {
        this.watchExecutor = watchExecutor;
        return this.self();
    }

    public final T gcTrigger(GcTrigger gcTrigger) {
        this.gcTrigger = gcTrigger;
        return this.self();
    }

    public final T stethoscopeClasses(List<Class<? extends Reachability.Inspector>> stethoscopeClasses) {
        this.heapDumpBuilder.reachabilityInspectorClasses(stethoscopeClasses);
        return this.self();
    }

    public final T computeRetainedHeapSize(boolean computeRetainedHeapSize) {
        this.heapDumpBuilder.computeRetainedHeapSize(computeRetainedHeapSize);
        return this.self();
    }

    public final RefWatcher build() {
        GcTrigger gcTrigger;
        WatchExecutor watchExecutor;
        HeapDumper heapDumper;
        DebuggerControl debuggerControl;
        HeapDump.Listener heapDumpListener;
        if (this.isDisabled()) {
            return RefWatcher.DISABLED;
        }
        if (this.heapDumpBuilder.excludedRefs == null) {
            this.heapDumpBuilder.excludedRefs(this.defaultExcludedRefs());
        }
        if ((heapDumpListener = this.heapDumpListener) == null) {
            heapDumpListener = this.defaultHeapDumpListener();
        }
        if ((debuggerControl = this.debuggerControl) == null) {
            debuggerControl = this.defaultDebuggerControl();
        }
        if ((heapDumper = this.heapDumper) == null) {
            heapDumper = this.defaultHeapDumper();
        }
        if ((watchExecutor = this.watchExecutor) == null) {
            watchExecutor = this.defaultWatchExecutor();
        }
        if ((gcTrigger = this.gcTrigger) == null) {
            gcTrigger = this.defaultGcTrigger();
        }
        if (this.heapDumpBuilder.reachabilityInspectorClasses == null) {
            this.heapDumpBuilder.reachabilityInspectorClasses(this.defaultReachabilityInspectorClasses());
        }
        return new RefWatcher(watchExecutor, debuggerControl, gcTrigger, heapDumper, heapDumpListener, this.heapDumpBuilder);
    }

    protected boolean isDisabled() {
        return false;
    }

    protected GcTrigger defaultGcTrigger() {
        return GcTrigger.DEFAULT;
    }

    protected DebuggerControl defaultDebuggerControl() {
        return DebuggerControl.NONE;
    }

    protected ExcludedRefs defaultExcludedRefs() {
        return ExcludedRefs.builder().build();
    }

    protected HeapDumper defaultHeapDumper() {
        return HeapDumper.NONE;
    }

    protected HeapDump.Listener defaultHeapDumpListener() {
        return HeapDump.Listener.NONE;
    }

    protected WatchExecutor defaultWatchExecutor() {
        return WatchExecutor.NONE;
    }

    protected List<Class<? extends Reachability.Inspector>> defaultReachabilityInspectorClasses() {
        return Collections.emptyList();
    }

    protected final T self() {
        return (T)this;
    }
}

