/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.CanaryLog;
import leakcanary.Clock;
import leakcanary.LeakSentry;
import leakcanary.RefWatcher;
import leakcanary.internal.ActivityDestroyWatcher;
import leakcanary.internal.FragmentDestroyWatcher;
import leakcanary.internal.InternalLeakSentry;
import leakcanary.internal.LeakSentryListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lleakcanary/internal/InternalLeakSentry;", "", "()V", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "setApplication", "(Landroid/app/Application;)V", "checkRetainedExecutor", "Ljava/util/concurrent/Executor;", "clock", "leakcanary/internal/InternalLeakSentry$clock$1", "Lleakcanary/internal/InternalLeakSentry$clock$1;", "listener", "Lleakcanary/internal/LeakSentryListener;", "mainHandler", "Landroid/os/Handler;", "refWatcher", "Lleakcanary/RefWatcher;", "getRefWatcher", "()Lleakcanary/RefWatcher;", "checkMainThread", "", "install", "leakcanary-leaksentry_release"})
public final class InternalLeakSentry {
    private static final LeakSentryListener listener;
    @NotNull
    public static Application application;
    private static final clock.1 clock;
    private static final Handler mainHandler;
    private static final Executor checkRetainedExecutor;
    @NotNull
    private static final RefWatcher refWatcher;
    public static final InternalLeakSentry INSTANCE;

    @NotNull
    public final Application getApplication() {
        Application application = InternalLeakSentry.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        return application;
    }

    public final void setApplication(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"<set-?>");
        InternalLeakSentry.application = application;
    }

    @NotNull
    public final RefWatcher getRefWatcher() {
        return refWatcher;
    }

    public final void install(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        CanaryLog.INSTANCE.d("Installing LeakSentry", new Object[0]);
        this.checkMainThread();
        if (InternalLeakSentry.application != null) {
            return;
        }
        InternalLeakSentry.application = application;
        Function0 configProvider2 = install.configProvider.1.INSTANCE;
        ActivityDestroyWatcher.Companion.install(application, refWatcher, (Function0<LeakSentry.Config>)configProvider2);
        FragmentDestroyWatcher.Companion.install(application, refWatcher, (Function0<LeakSentry.Config>)configProvider2);
        listener.onLeakSentryInstalled(application);
    }

    private final void checkMainThread() {
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        if (looper.getThread() != Thread.currentThread()) {
            throw (Throwable)new UnsupportedOperationException("Should be called from the main thread, not " + Thread.currentThread());
        }
    }

    private InternalLeakSentry() {
    }

    static {
        LeakSentryListener leakSentryListener;
        InternalLeakSentry internalLeakSentry;
        INSTANCE = internalLeakSentry = new InternalLeakSentry();
        clock = new Clock(){

            public long uptimeMillis() {
                return SystemClock.uptimeMillis();
            }
        };
        mainHandler = new Handler(Looper.getMainLooper());
        try {
            Class<?> leakCanaryListener = Class.forName("leakcanary.internal.InternalLeakCanary");
            Object object = leakCanaryListener.getDeclaredField("INSTANCE").get(null);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type leakcanary.internal.LeakSentryListener");
            }
            leakSentryListener = (LeakSentryListener)object;
        }
        catch (Throwable ignored) {
            leakSentryListener = LeakSentryListener.None.INSTANCE;
        }
        listener = leakSentryListener;
        checkRetainedExecutor = checkRetainedExecutor.1.INSTANCE;
        refWatcher = new RefWatcher((Clock)clock, checkRetainedExecutor, (Function0)refWatcher.1.INSTANCE);
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(InternalLeakSentry $this) {
        InternalLeakSentry internalLeakSentry = $this;
        return mainHandler;
    }

    public static final /* synthetic */ LeakSentryListener access$getListener$p(InternalLeakSentry $this) {
        InternalLeakSentry internalLeakSentry = $this;
        return listener;
    }
}

