/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.UserManager;
import android.widget.TextView;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import leakcanary.AndroidLeakFixes;
import leakcanary.ViewLocationHolderLeakFix;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0087\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lleakcanary/AndroidLeakFixes;", "", "(Ljava/lang/String;I)V", "apply", "", "application", "Landroid/app/Application;", "MEDIA_SESSION_LEGACY_HELPER", "TEXT_LINE_POOL", "USER_MANAGER", "FLUSH_HANDLER_THREADS", "ACCESSIBILITY_NODE_INFO", "CONNECTIVITY_MANAGER", "SAMSUNG_CLIPBOARD_MANAGER", "BUBBLE_POPUP", "LAST_HOVERED_VIEW", "ACTIVITY_MANAGER", "VIEW_LOCATION_HOLDER", "Companion", "plumber-android_release"})
@SuppressLint(value={"NewApi"})
public abstract class AndroidLeakFixes
extends Enum<AndroidLeakFixes> {
    public static final /* enum */ AndroidLeakFixes MEDIA_SESSION_LEGACY_HELPER;
    public static final /* enum */ AndroidLeakFixes TEXT_LINE_POOL;
    public static final /* enum */ AndroidLeakFixes USER_MANAGER;
    public static final /* enum */ AndroidLeakFixes FLUSH_HANDLER_THREADS;
    public static final /* enum */ AndroidLeakFixes ACCESSIBILITY_NODE_INFO;
    public static final /* enum */ AndroidLeakFixes CONNECTIVITY_MANAGER;
    public static final /* enum */ AndroidLeakFixes SAMSUNG_CLIPBOARD_MANAGER;
    public static final /* enum */ AndroidLeakFixes BUBBLE_POPUP;
    public static final /* enum */ AndroidLeakFixes LAST_HOVERED_VIEW;
    public static final /* enum */ AndroidLeakFixes ACTIVITY_MANAGER;
    public static final /* enum */ AndroidLeakFixes VIEW_LOCATION_HOLDER;
    private static final /* synthetic */ AndroidLeakFixes[] $VALUES;
    private static final String SAMSUNG = "samsung";
    private static final String LG = "LGE";
    private static final ScheduledExecutorService backgroundExecutor;
    public static final Companion Companion;

    static {
        AndroidLeakFixes[] androidLeakFixesArray = new AndroidLeakFixes[11];
        AndroidLeakFixes[] androidLeakFixesArray2 = androidLeakFixesArray;
        androidLeakFixesArray[0] = MEDIA_SESSION_LEGACY_HELPER = new MEDIA_SESSION_LEGACY_HELPER("MEDIA_SESSION_LEGACY_HELPER", 0);
        androidLeakFixesArray[1] = TEXT_LINE_POOL = new TEXT_LINE_POOL("TEXT_LINE_POOL", 1);
        androidLeakFixesArray[2] = USER_MANAGER = new USER_MANAGER("USER_MANAGER", 2);
        androidLeakFixesArray[3] = FLUSH_HANDLER_THREADS = new FLUSH_HANDLER_THREADS("FLUSH_HANDLER_THREADS", 3);
        androidLeakFixesArray[4] = ACCESSIBILITY_NODE_INFO = new ACCESSIBILITY_NODE_INFO("ACCESSIBILITY_NODE_INFO", 4);
        androidLeakFixesArray[5] = CONNECTIVITY_MANAGER = new CONNECTIVITY_MANAGER("CONNECTIVITY_MANAGER", 5);
        androidLeakFixesArray[6] = SAMSUNG_CLIPBOARD_MANAGER = new SAMSUNG_CLIPBOARD_MANAGER("SAMSUNG_CLIPBOARD_MANAGER", 6);
        androidLeakFixesArray[7] = BUBBLE_POPUP = new BUBBLE_POPUP("BUBBLE_POPUP", 7);
        androidLeakFixesArray[8] = LAST_HOVERED_VIEW = new LAST_HOVERED_VIEW("LAST_HOVERED_VIEW", 8);
        androidLeakFixesArray[9] = ACTIVITY_MANAGER = new ACTIVITY_MANAGER("ACTIVITY_MANAGER", 9);
        androidLeakFixesArray[10] = VIEW_LOCATION_HOLDER = new VIEW_LOCATION_HOLDER("VIEW_LOCATION_HOLDER", 10);
        $VALUES = androidLeakFixesArray;
        Companion = new Companion(null);
        backgroundExecutor = Executors.newSingleThreadScheduledExecutor(Companion.backgroundExecutor.1.INSTANCE);
    }

    protected abstract void apply(@NotNull Application var1);

    private AndroidLeakFixes() {
    }

    public /* synthetic */ AndroidLeakFixes(String $enum_name_or_ordinal$0, int $enum_name_or_ordinal$1, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static AndroidLeakFixes[] values() {
        return (AndroidLeakFixes[])$VALUES.clone();
    }

    public static AndroidLeakFixes valueOf(String string) {
        return Enum.valueOf(AndroidLeakFixes.class, string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$MEDIA_SESSION_LEGACY_HELPER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class MEDIA_SESSION_LEGACY_HELPER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT != 21) {
                return;
            }
            backgroundExecutor.execute(new Runnable(application){
                final /* synthetic */ Application $application;

                public final void run() {
                    try {
                        Class<?> clazz = Class.forName("android.media.session.MediaSessionLegacyHelper");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.m\u2026ediaSessionLegacyHelper\")");
                        Class<?> clazz2 = clazz;
                        Method method = clazz2.getDeclaredMethod("getHelper", Context.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"clazz.getDeclaredMethod(\u2026er\", Context::class.java)");
                        Method getHelperMethod = method;
                        getHelperMethod.invoke(null, this.$application);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                {
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        MEDIA_SESSION_LEGACY_HELPER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$TEXT_LINE_POOL;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class TEXT_LINE_POOL
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT >= 28) {
                return;
            }
            backgroundExecutor.execute(new Runnable(application){
                final /* synthetic */ Application $application;

                public final void run() {
                    Object sCached = null;
                    try {
                        Class<?> clazz = Class.forName("android.text.TextLine");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.text.TextLine\")");
                        Class<?> textLineClass = clazz;
                        Field field = textLineClass.getDeclaredField("sCached");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"textLineClass.getDeclaredField(\"sCached\")");
                        Field sCachedField = field;
                        sCachedField.setAccessible(true);
                        sCached = sCachedField.get(null);
                        if (sCached == null || !sCached.getClass().isArray()) {
                            return;
                        }
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(sCached){
                        final /* synthetic */ Object $sCached;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Object object = this.$sCached;
                            boolean bl = false;
                            boolean bl2 = false;
                            synchronized (object) {
                                boolean bl3 = false;
                                int length = Array.getLength(this.$sCached);
                                int n = 0;
                                int n2 = length;
                                while (n < n2) {
                                    void i;
                                    Array.set(this.$sCached, (int)i, null);
                                    ++i;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        {
                            this.$sCached = object;
                            super(1);
                        }
                    }));
                }
                {
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        TEXT_LINE_POOL() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0015\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$USER_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class USER_MANAGER
    extends AndroidLeakFixes {
        @Override
        @SuppressLint(value={"NewApi"})
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            int n = Build.VERSION.SDK_INT;
            if (17 > n || 25 < n) {
                return;
            }
            try {
                Method method = UserManager.class.getDeclaredMethod("get", Context.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"UserManager::class.java.\u2026et\", Context::class.java)");
                Method getMethod = method;
                getMethod.invoke(null, application);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        USER_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$FLUSH_HANDLER_THREADS;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class FLUSH_HANDLER_THREADS
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            boolean bl = false;
            Set flushedThreadIds = new LinkedHashSet();
            backgroundExecutor.scheduleWithFixedDelay(new Runnable(flushedThreadIds){
                final /* synthetic */ Set $flushedThreadIds;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    void $this$mapTo$iv$iv;
                    Integer n;
                    Iterable<Integer> iterable;
                    void $this$mapTo$iv$iv2;
                    Object element$iv$iv$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = leakcanary.AndroidLeakFixes$Companion.access$findAllHandlerThreads(AndroidLeakFixes.Companion);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Iterable<Pair> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Pair pair;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        HandlerThread thread2 = (HandlerThread)element$iv$iv;
                        boolean bl2 = false;
                        int threadId = thread2.getThreadId();
                        if ((threadId == -1 || this.$flushedThreadIds.contains(threadId) ? null : TuplesKt.to((Object)threadId, (Object)thread2)) == null) continue;
                        pair = pair;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Pair it$iv$iv = pair;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List newHandlerThreadsById = (List)destination$iv$iv;
                    $this$mapNotNull$iv = this.$flushedThreadIds;
                    Iterable $this$map$iv = newHandlerThreadsById;
                    boolean $i$f$map22 = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        element$iv$iv$iv = (Pair)item$iv$iv2;
                        iterable = destination$iv$iv2;
                        boolean bl = false;
                        n = ((Number)it.getFirst()).intValue();
                        iterable.add(n);
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    $i$f$map22 = false;
                    CollectionsKt.addAll((Collection)$this$mapNotNull$iv, (Iterable)$this$map$iv);
                    Iterable $this$map$iv2 = newHandlerThreadsById;
                    boolean $i$f$map = false;
                    Iterable $i$f$map22 = $this$map$iv2;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = (Pair)item$iv$iv;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        n = (HandlerThread)it.getSecond();
                        iterable.add(n);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        void scheduleFlush;
                        HandlerThread handlerThread = (HandlerThread)element$iv;
                        boolean bl = false;
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        if (this_$iv.getLogger() == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger = logger$iv;
                            boolean bl6 = false;
                            String string = "Setting up flushing for " + handlerThread;
                            logger.d(string);
                        }
                        this_$iv = new Ref.BooleanRef();
                        this_$iv.element = true;
                        Handler flushHandler = new Handler(handlerThread.getLooper());
                        leakcanary.AndroidLeakFixes$Companion.access$onEachIdle(AndroidLeakFixes.Companion, flushHandler, (Function0)new Function0<Unit>((Ref.BooleanRef)scheduleFlush, flushHandler){
                            final /* synthetic */ Ref.BooleanRef $scheduleFlush;
                            final /* synthetic */ Handler $flushHandler;

                            public final void invoke() {
                                if (this.$scheduleFlush.element) {
                                    this.$scheduleFlush.element = false;
                                    try {
                                        this.$flushHandler.postDelayed(new Runnable(this){
                                            final /* synthetic */ apply.3.2 this$0;

                                            public final void run() {
                                                this.this$0.$scheduleFlush.element = true;
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        }, 1000L);
                                    }
                                    catch (RuntimeException runtimeException) {
                                        // empty catch block
                                    }
                                }
                            }
                            {
                                this.$scheduleFlush = booleanRef;
                                this.$flushHandler = handler;
                                super(0);
                            }
                        });
                    }
                }
                {
                    this.$flushedThreadIds = set;
                }
            }, 2L, 3L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        FLUSH_HANDLER_THREADS() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$ACCESSIBILITY_NODE_INFO;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class ACCESSIBILITY_NODE_INFO
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT >= 28) {
                return;
            }
            backgroundExecutor.scheduleAtFixedRate(apply.1.INSTANCE, 5L, 5L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        ACCESSIBILITY_NODE_INFO() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$CONNECTIVITY_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class CONNECTIVITY_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT > 23) {
                return;
            }
            try {
                application.getSystemService("connectivity");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        CONNECTIVITY_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$SAMSUNG_CLIPBOARD_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class SAMSUNG_CLIPBOARD_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            try {
                Class<?> clazz = Class.forName("android.sec.clipboard.ClipboardUIManager");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.s\u2026oard.ClipboardUIManager\")");
                Class<?> managerClass = clazz;
                Method method = managerClass.getDeclaredMethod("getInstance", Context.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"managerClass.getDeclared\u2026ce\", Context::class.java)");
                Method instanceMethod = method;
                instanceMethod.setAccessible(true);
                instanceMethod.invoke(null, application);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        SAMSUNG_CLIPBOARD_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$BUBBLE_POPUP;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class BUBBLE_POPUP
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.LG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            backgroundExecutor.execute(new Runnable(application){
                final /* synthetic */ Application $application;

                public final void run() {
                    Field helperField = null;
                    try {
                        Class<?> clazz = Class.forName("android.widget.BubblePopupHelper");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.widget.BubblePopupHelper\")");
                        Class<?> helperClass = clazz;
                        Field field = helperClass.getDeclaredField("sHelper");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"helperClass.getDeclaredField(\"sHelper\")");
                        helperField = field;
                        helperField.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(helperField){
                        final /* synthetic */ Field $helperField;

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            try {
                                this.$helperField.set(null, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        {
                            this.$helperField = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        BUBBLE_POPUP() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$LAST_HOVERED_VIEW;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class LAST_HOVERED_VIEW
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            backgroundExecutor.execute(new Runnable(application){
                final /* synthetic */ Application $application;

                public final void run() {
                    Field field = null;
                    try {
                        Field field2 = TextView.class.getDeclaredField("mLastHoveredView");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"TextView::class.java.get\u2026Field(\"mLastHoveredView\")");
                        field = field2;
                        field.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(field){
                        final /* synthetic */ Field $field;

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            try {
                                this.$field.set(null, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        {
                            this.$field = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        LAST_HOVERED_VIEW() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$ACTIVITY_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class ACTIVITY_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || Build.VERSION.SDK_INT != 22) {
                return;
            }
            backgroundExecutor.execute(new Runnable(application){
                final /* synthetic */ Application $application;

                public final void run() {
                    Field contextField = null;
                    try {
                        Field field = this.$application.getSystemService("activity").getClass().getDeclaredField("mContext");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"application\n            \u2026DeclaredField(\"mContext\")");
                        contextField = field;
                        contextField.setAccessible(true);
                        if ((contextField.getModifiers() | 8) != contextField.getModifiers()) {
                            return;
                        }
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(contextField){
                        final /* synthetic */ Field $contextField;

                        public final void invoke(@NotNull Activity activity) {
                            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                            try {
                                if (Intrinsics.areEqual((Object)this.$contextField.get(null), (Object)activity)) {
                                    this.$contextField.set(null, null);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        {
                            this.$contextField = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        ACTIVITY_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$VIEW_LOCATION_HOLDER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class VIEW_LOCATION_HOLDER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            ViewLocationHolderLeakFix.INSTANCE.applyFix$plumber_android_release(application);
        }

        /*
         * WARNING - void declaration
         */
        VIEW_LOCATION_HOLDER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\r\u0010\u0010\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001c\u0010\u0015\u001a\u0002H\u0016\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0001H\u0080\b\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\n*\u00020\f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ\u001a\u0010\u001e\u001a\u00020\n*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lleakcanary/AndroidLeakFixes$Companion;", "", "()V", "LG", "", "SAMSUNG", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "applyFixes", "", "application", "Landroid/app/Application;", "fixes", "", "Lleakcanary/AndroidLeakFixes;", "checkMainThread", "checkMainThread$plumber_android_release", "findAllHandlerThreads", "", "Landroid/os/HandlerThread;", "noOpDelegate", "T", "noOpDelegate$plumber_android_release", "()Ljava/lang/Object;", "onActivityDestroyed", "block", "Lkotlin/Function1;", "Landroid/app/Activity;", "onActivityDestroyed$plumber_android_release", "onEachIdle", "Landroid/os/Handler;", "onIdle", "Lkotlin/Function0;", "plumber-android_release"})
    public static final class Companion {
        public final void applyFixes(@NotNull Application application, @NotNull Set<? extends AndroidLeakFixes> fixes) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull(fixes, (String)"fixes");
            this.checkMainThread$plumber_android_release();
            Iterable $this$forEach$iv = fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AndroidLeakFixes it = (AndroidLeakFixes)((Object)element$iv);
                boolean bl = false;
                it.apply(application);
            }
        }

        public static /* synthetic */ void applyFixes$default(Companion companion, Application application, Set set, int n, Object object) {
            if ((n & 2) != 0) {
                EnumSet<AndroidLeakFixes> enumSet = EnumSet.allOf(AndroidLeakFixes.class);
                Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.allOf(AndroidLeakFixes::class.java)");
                set = enumSet;
            }
            companion.applyFixes(application, set);
        }

        private final void onEachIdle(@NotNull Handler $this$onEachIdle, Function0<Unit> onIdle) {
            try {
                $this$onEachIdle.post(new Runnable(onIdle){
                    final /* synthetic */ Function0 $onIdle;

                    public final void run() {
                        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(this){
                            final /* synthetic */ onEachIdle.1 this$0;

                            public final boolean queueIdle() {
                                this.this$0.$onIdle.invoke();
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$onIdle = function0;
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<HandlerThread> findAllHandlerThreads() {
            void $this$mapNotNullTo$iv$iv;
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
            ThreadGroup threadGroup = thread2.getThreadGroup();
            if (threadGroup == null) {
                Intrinsics.throwNpe();
            }
            ThreadGroup rootGroup = threadGroup;
            while (rootGroup.getParent() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)rootGroup.getParent(), (String)"rootGroup.parent");
            }
            Thread[] threads = new Thread[rootGroup.activeCount()];
            while (rootGroup.enumerate(threads, true) == threads.length) {
                threads = new Thread[threads.length * 2];
            }
            Thread[] $this$mapNotNull$iv = threads;
            boolean $i$f$mapNotNull = false;
            Thread[] threadArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var10_10 = $this$forEach$iv$iv$iv;
            int n = ((void)var10_10).length;
            for (int i = 0; i < n; ++i) {
                HandlerThread handlerThread;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var10_10[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof HandlerThread ? (HandlerThread)it : null) == null) continue;
                handlerThread = handlerThread;
                boolean bl3 = false;
                boolean bl4 = false;
                HandlerThread it$iv$iv = handlerThread;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final void onActivityDestroyed$plumber_android_release(@NotNull Application $this$onActivityDestroyed, @NotNull Function1<? super Activity, Unit> block) {
            Intrinsics.checkParameterIsNotNull((Object)$this$onActivityDestroyed, (String)"$this$onActivityDestroyed");
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            $this$onActivityDestroyed.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(this, block){
                private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
                final /* synthetic */ Companion this$0;
                final /* synthetic */ Function1 $block;

                public void onActivityDestroyed(@NotNull Activity activity) {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    this.$block.invoke((Object)activity);
                }
                {
                    Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
                    this.this$0 = $outer;
                    this.$block = $captured_local_variable$1;
                    Companion companion = AndroidLeakFixes.Companion;
                    onActivityDestroyed.1 var7_4 = this;
                    boolean $i$f$noOpDelegate$plumber_android_release = false;
                    Class<Application.ActivityLifecycleCallbacks> javaClass$iv = Application.ActivityLifecycleCallbacks.class;
                    InvocationHandler noOpHandler$iv = noOpDelegate.noOpHandler.1.INSTANCE;
                    Object object = Proxy.newProxyInstance(javaClass$iv.getClassLoader(), new Class[]{javaClass$iv}, noOpHandler$iv);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                    }
                    var7_4.$$delegate_0 = activityLifecycleCallbacks = (Application.ActivityLifecycleCallbacks)object;
                }

                public void onActivityCreated(@RecentlyNonNull Activity p0, @RecentlyNullable Bundle p1) {
                    this.$$delegate_0.onActivityCreated(p0, p1);
                }

                public void onActivityPaused(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityPaused(p0);
                }

                public void onActivityResumed(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityResumed(p0);
                }

                public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                    this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
                }

                public void onActivityStarted(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStarted(p0);
                }

                public void onActivityStopped(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStopped(p0);
                }
            });
        }

        @NotNull
        public final /* synthetic */ <T> T noOpDelegate$plumber_android_release() {
            int $i$f$noOpDelegate$plumber_android_release = 0;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Class<Object> javaClass = Object.class;
            InvocationHandler noOpHandler2 = noOpDelegate.noOpHandler.1.INSTANCE;
            Object object = Proxy.newProxyInstance(javaClass.getClassLoader(), new Class[]{javaClass}, noOpHandler2);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)object;
        }

        public final void checkMainThread$plumber_android_release() {
            Looper looper = Looper.getMainLooper();
            Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
            if (looper.getThread() != Thread.currentThread()) {
                throw (Throwable)new UnsupportedOperationException("Should be called from the main thread, not " + Thread.currentThread());
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$findAllHandlerThreads(Companion $this) {
            return $this.findAllHandlerThreads();
        }

        public static final /* synthetic */ void access$onEachIdle(Companion $this, Handler $this$access_u24onEachIdle, Function0 onIdle) {
            $this.onEachIdle($this$access_u24onEachIdle, (Function0<Unit>)onIdle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

