/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.UserManager;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import leakcanary.AndroidLeakFixes;
import leakcanary.ViewLocationHolderLeakFix;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.ObjectsKt;
import leakcanary.internal.ReferenceCleaner;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0087\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Lleakcanary/AndroidLeakFixes;", "", "(Ljava/lang/String;I)V", "applied", "", "apply", "", "application", "Landroid/app/Application;", "MEDIA_SESSION_LEGACY_HELPER", "TEXT_LINE_POOL", "USER_MANAGER", "FLUSH_HANDLER_THREADS", "ACCESSIBILITY_NODE_INFO", "CONNECTIVITY_MANAGER", "SAMSUNG_CLIPBOARD_MANAGER", "BUBBLE_POPUP", "LAST_HOVERED_VIEW", "ACTIVITY_MANAGER", "VIEW_LOCATION_HOLDER", "IMM_FOCUSED_VIEW", "IMM_CUR_ROOT_VIEW", "SPELL_CHECKER", "Companion", "plumber-android_release"})
@SuppressLint(value={"NewApi"})
public abstract class AndroidLeakFixes
extends Enum<AndroidLeakFixes> {
    public static final /* enum */ AndroidLeakFixes MEDIA_SESSION_LEGACY_HELPER;
    public static final /* enum */ AndroidLeakFixes TEXT_LINE_POOL;
    public static final /* enum */ AndroidLeakFixes USER_MANAGER;
    public static final /* enum */ AndroidLeakFixes FLUSH_HANDLER_THREADS;
    public static final /* enum */ AndroidLeakFixes ACCESSIBILITY_NODE_INFO;
    public static final /* enum */ AndroidLeakFixes CONNECTIVITY_MANAGER;
    public static final /* enum */ AndroidLeakFixes SAMSUNG_CLIPBOARD_MANAGER;
    public static final /* enum */ AndroidLeakFixes BUBBLE_POPUP;
    public static final /* enum */ AndroidLeakFixes LAST_HOVERED_VIEW;
    public static final /* enum */ AndroidLeakFixes ACTIVITY_MANAGER;
    public static final /* enum */ AndroidLeakFixes VIEW_LOCATION_HOLDER;
    public static final /* enum */ AndroidLeakFixes IMM_FOCUSED_VIEW;
    public static final /* enum */ AndroidLeakFixes IMM_CUR_ROOT_VIEW;
    public static final /* enum */ AndroidLeakFixes SPELL_CHECKER;
    private static final /* synthetic */ AndroidLeakFixes[] $VALUES;
    private boolean applied;
    private static final String SAMSUNG = "samsung";
    private static final String LG = "LGE";
    private static final ScheduledExecutorService backgroundExecutor;
    @NotNull
    public static final Companion Companion;

    static {
        AndroidLeakFixes[] androidLeakFixesArray = new AndroidLeakFixes[14];
        AndroidLeakFixes[] androidLeakFixesArray2 = androidLeakFixesArray;
        androidLeakFixesArray[0] = MEDIA_SESSION_LEGACY_HELPER = new MEDIA_SESSION_LEGACY_HELPER("MEDIA_SESSION_LEGACY_HELPER", 0);
        androidLeakFixesArray[1] = TEXT_LINE_POOL = new TEXT_LINE_POOL("TEXT_LINE_POOL", 1);
        androidLeakFixesArray[2] = USER_MANAGER = new USER_MANAGER("USER_MANAGER", 2);
        androidLeakFixesArray[3] = FLUSH_HANDLER_THREADS = new FLUSH_HANDLER_THREADS("FLUSH_HANDLER_THREADS", 3);
        androidLeakFixesArray[4] = ACCESSIBILITY_NODE_INFO = new ACCESSIBILITY_NODE_INFO("ACCESSIBILITY_NODE_INFO", 4);
        androidLeakFixesArray[5] = CONNECTIVITY_MANAGER = new CONNECTIVITY_MANAGER("CONNECTIVITY_MANAGER", 5);
        androidLeakFixesArray[6] = SAMSUNG_CLIPBOARD_MANAGER = new SAMSUNG_CLIPBOARD_MANAGER("SAMSUNG_CLIPBOARD_MANAGER", 6);
        androidLeakFixesArray[7] = BUBBLE_POPUP = new BUBBLE_POPUP("BUBBLE_POPUP", 7);
        androidLeakFixesArray[8] = LAST_HOVERED_VIEW = new LAST_HOVERED_VIEW("LAST_HOVERED_VIEW", 8);
        androidLeakFixesArray[9] = ACTIVITY_MANAGER = new ACTIVITY_MANAGER("ACTIVITY_MANAGER", 9);
        androidLeakFixesArray[10] = VIEW_LOCATION_HOLDER = new VIEW_LOCATION_HOLDER("VIEW_LOCATION_HOLDER", 10);
        androidLeakFixesArray[11] = IMM_FOCUSED_VIEW = new IMM_FOCUSED_VIEW("IMM_FOCUSED_VIEW", 11);
        androidLeakFixesArray[12] = IMM_CUR_ROOT_VIEW = new IMM_CUR_ROOT_VIEW("IMM_CUR_ROOT_VIEW", 12);
        androidLeakFixesArray[13] = SPELL_CHECKER = new SPELL_CHECKER("SPELL_CHECKER", 13);
        $VALUES = androidLeakFixesArray;
        Companion = new Companion(null);
        backgroundExecutor = Executors.newSingleThreadScheduledExecutor(Companion.backgroundExecutor.1.INSTANCE);
    }

    protected abstract void apply(@NotNull Application var1);

    private AndroidLeakFixes() {
    }

    public /* synthetic */ AndroidLeakFixes(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static AndroidLeakFixes[] values() {
        return (AndroidLeakFixes[])$VALUES.clone();
    }

    public static AndroidLeakFixes valueOf(String string) {
        return Enum.valueOf(AndroidLeakFixes.class, string);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$MEDIA_SESSION_LEGACY_HELPER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class MEDIA_SESSION_LEGACY_HELPER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT != 21) {
                return;
            }
            backgroundExecutor.execute(new Runnable(this, application){
                final /* synthetic */ MEDIA_SESSION_LEGACY_HELPER this$0;
                final /* synthetic */ Application $application;

                public final void run() {
                    try {
                        Class<?> clazz = Class.forName("android.media.session.MediaSessionLegacyHelper");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.m\u2026ediaSessionLegacyHelper\")");
                        Class<?> clazz2 = clazz;
                        Method method = clazz2.getDeclaredMethod("getHelper", Context.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"clazz.getDeclaredMethod(\u2026er\", Context::class.java)");
                        Method getHelperMethod = method;
                        getHelperMethod.invoke(null, this.$application);
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        }
                        SharkLog.Logger logger$iv = logger;
                        Throwable throwable = ignored;
                        SharkLog.Logger logger2 = logger$iv;
                        boolean bl = false;
                        String string = "Could not fix the " + this.this$0.name() + " leak";
                        logger2.d(throwable, string);
                    }
                }
                {
                    this.this$0 = mEDIA_SESSION_LEGACY_HELPER;
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        MEDIA_SESSION_LEGACY_HELPER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$TEXT_LINE_POOL;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class TEXT_LINE_POOL
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT >= 28) {
                return;
            }
            backgroundExecutor.execute(new Runnable(this, application){
                final /* synthetic */ TEXT_LINE_POOL this$0;
                final /* synthetic */ Application $application;

                public final void run() {
                    Object sCached = null;
                    try {
                        Class<?> clazz = Class.forName("android.text.TextLine");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.text.TextLine\")");
                        Class<?> textLineClass = clazz;
                        Field field = textLineClass.getDeclaredField("sCached");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"textLineClass.getDeclaredField(\"sCached\")");
                        Field sCachedField = field;
                        sCachedField.setAccessible(true);
                        sCached = sCachedField.get(null);
                        if (sCached == null || !sCached.getClass().isArray()) {
                            SharkLog this_$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            SharkLog.Logger logger = this_$iv.getLogger();
                            if (logger == null) {
                            } else {
                                SharkLog.Logger logger$iv;
                                SharkLog.Logger logger2 = logger$iv = logger;
                                boolean bl = false;
                                String string = "Could not fix the " + this.this$0.name() + " leak, sCached=" + sCached;
                                logger2.d(string);
                            }
                            return;
                        }
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv = logger;
                            Throwable throwable = ignored;
                            SharkLog.Logger logger3 = logger$iv;
                            boolean bl = false;
                            String string = "Could not fix the " + this.this$0.name() + " leak";
                            logger3.d(throwable, string);
                        }
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(sCached){
                        final /* synthetic */ Object $sCached;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Object object = this.$sCached;
                            boolean bl = false;
                            boolean bl2 = false;
                            synchronized (object) {
                                boolean bl3 = false;
                                int length = Array.getLength(this.$sCached);
                                int n = 0;
                                int n2 = length;
                                while (n < n2) {
                                    void i;
                                    Array.set(this.$sCached, (int)i, null);
                                    ++i;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        {
                            this.$sCached = object;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = tEXT_LINE_POOL;
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        TEXT_LINE_POOL() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0015\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$USER_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class USER_MANAGER
    extends AndroidLeakFixes {
        @Override
        @SuppressLint(value={"NewApi"})
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            int n = Build.VERSION.SDK_INT;
            if (17 > n || 25 < n) {
                return;
            }
            try {
                Method method = UserManager.class.getDeclaredMethod("get", Context.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"UserManager::class.java.\u2026et\", Context::class.java)");
                Method getMethod = method;
                getMethod.invoke(null, application);
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                }
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = ignored;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Could not fix the " + this.name() + " leak";
                logger2.d(throwable, string);
            }
        }

        /*
         * WARNING - void declaration
         */
        USER_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$FLUSH_HANDLER_THREADS;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class FLUSH_HANDLER_THREADS
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            boolean bl = false;
            Set flushedThreadIds = new LinkedHashSet();
            backgroundExecutor.scheduleWithFixedDelay(new Runnable(flushedThreadIds){
                final /* synthetic */ Set $flushedThreadIds;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    void $this$mapTo$iv$iv;
                    Integer n;
                    Iterable<Integer> iterable;
                    void $this$mapTo$iv$iv2;
                    Object element$iv$iv$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = leakcanary.AndroidLeakFixes$Companion.access$findAllHandlerThreads(AndroidLeakFixes.Companion);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Iterable<Pair> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Pair pair;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        HandlerThread thread2 = (HandlerThread)element$iv$iv;
                        boolean bl2 = false;
                        int threadId = thread2.getThreadId();
                        if ((threadId == -1 || this.$flushedThreadIds.contains(threadId) ? null : TuplesKt.to((Object)threadId, (Object)thread2)) == null) continue;
                        pair = pair;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Pair it$iv$iv = pair;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List newHandlerThreadsById = (List)destination$iv$iv;
                    $this$mapNotNull$iv = this.$flushedThreadIds;
                    Iterable $this$map$iv = newHandlerThreadsById;
                    boolean $i$f$map22 = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        element$iv$iv$iv = (Pair)item$iv$iv2;
                        iterable = destination$iv$iv2;
                        boolean bl = false;
                        n = ((Number)it.getFirst()).intValue();
                        iterable.add(n);
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    $i$f$map22 = false;
                    CollectionsKt.addAll((Collection)$this$mapNotNull$iv, (Iterable)$this$map$iv);
                    Iterable $this$map$iv2 = newHandlerThreadsById;
                    boolean $i$f$map = false;
                    Iterable $i$f$map22 = $this$map$iv2;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = (Pair)item$iv$iv;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        n = (HandlerThread)it.getSecond();
                        iterable.add(n);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        void scheduleFlush;
                        HandlerThread handlerThread = (HandlerThread)element$iv;
                        boolean bl = false;
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        if (this_$iv.getLogger() == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger = logger$iv;
                            boolean bl6 = false;
                            String string = "Setting up flushing for " + handlerThread;
                            logger.d(string);
                        }
                        this_$iv = new Ref.BooleanRef();
                        this_$iv.element = true;
                        Handler flushHandler = new Handler(handlerThread.getLooper());
                        leakcanary.AndroidLeakFixes$Companion.access$onEachIdle(AndroidLeakFixes.Companion, flushHandler, (Function0)new Function0<Unit>(handlerThread, (Ref.BooleanRef)scheduleFlush, flushHandler){
                            final /* synthetic */ HandlerThread $handlerThread;
                            final /* synthetic */ Ref.BooleanRef $scheduleFlush;
                            final /* synthetic */ Handler $flushHandler;

                            public final void invoke() {
                                if (this.$handlerThread.isAlive() && this.$scheduleFlush.element) {
                                    this.$scheduleFlush.element = false;
                                    try {
                                        boolean posted2 = this.$flushHandler.postDelayed(new Runnable(this){
                                            final /* synthetic */ apply.3.2 this$0;

                                            public final void run() {
                                                this.this$0.$scheduleFlush.element = true;
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        }, 1000L);
                                        if (!posted2) {
                                            SharkLog this_$iv = SharkLog.INSTANCE;
                                            boolean $i$f$d = false;
                                            SharkLog.Logger logger = this_$iv.getLogger();
                                            if (logger == null) {
                                            } else {
                                                SharkLog.Logger logger$iv;
                                                SharkLog.Logger logger2 = logger$iv = logger;
                                                boolean bl = false;
                                                String string = "Failed to post to " + this.$handlerThread.getName();
                                                logger2.d(string);
                                            }
                                        }
                                    }
                                    catch (RuntimeException ignored) {
                                        SharkLog this_$iv = SharkLog.INSTANCE;
                                        boolean $i$f$d = false;
                                        SharkLog.Logger logger = this_$iv.getLogger();
                                        if (logger == null) {
                                        }
                                        SharkLog.Logger logger$iv = logger;
                                        Throwable throwable = ignored;
                                        SharkLog.Logger logger3 = logger$iv;
                                        boolean bl = false;
                                        String string = "Failed to post to " + this.$handlerThread.getName();
                                        logger3.d(throwable, string);
                                    }
                                }
                            }
                            {
                                this.$handlerThread = handlerThread;
                                this.$scheduleFlush = booleanRef;
                                this.$flushHandler = handler;
                                super(0);
                            }
                        });
                    }
                }
                {
                    this.$flushedThreadIds = set;
                }
            }, 2L, 3L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        FLUSH_HANDLER_THREADS() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$ACCESSIBILITY_NODE_INFO;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class ACCESSIBILITY_NODE_INFO
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT >= 28) {
                return;
            }
            backgroundExecutor.scheduleAtFixedRate(apply.1.INSTANCE, 5L, 5L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        ACCESSIBILITY_NODE_INFO() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$CONNECTIVITY_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class CONNECTIVITY_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT > 23) {
                return;
            }
            try {
                application.getSystemService("connectivity");
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                }
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = ignored;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Could not fix the " + this.name() + " leak";
                logger2.d(throwable, string);
            }
        }

        /*
         * WARNING - void declaration
         */
        CONNECTIVITY_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$SAMSUNG_CLIPBOARD_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class SAMSUNG_CLIPBOARD_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            try {
                Class<?> clazz = Class.forName("android.sec.clipboard.ClipboardUIManager");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.s\u2026oard.ClipboardUIManager\")");
                Class<?> managerClass = clazz;
                Method method = managerClass.getDeclaredMethod("getInstance", Context.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"managerClass.getDeclared\u2026ce\", Context::class.java)");
                Method instanceMethod = method;
                instanceMethod.setAccessible(true);
                instanceMethod.invoke(null, application);
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                }
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = ignored;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Could not fix the " + this.name() + " leak";
                logger2.d(throwable, string);
            }
        }

        /*
         * WARNING - void declaration
         */
        SAMSUNG_CLIPBOARD_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$BUBBLE_POPUP;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class BUBBLE_POPUP
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.LG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            backgroundExecutor.execute(new Runnable(this, application){
                final /* synthetic */ BUBBLE_POPUP this$0;
                final /* synthetic */ Application $application;

                public final void run() {
                    Field helperField = null;
                    try {
                        Class<?> clazz = Class.forName("android.widget.BubblePopupHelper");
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.widget.BubblePopupHelper\")");
                        Class<?> helperClass = clazz;
                        Field field = helperClass.getDeclaredField("sHelper");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"helperClass.getDeclaredField(\"sHelper\")");
                        helperField = field;
                        helperField.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv = logger;
                            Throwable throwable = ignored;
                            SharkLog.Logger logger2 = logger$iv;
                            boolean bl = false;
                            String string = "Could not fix the " + this.this$0.name() + " leak";
                            logger2.d(throwable, string);
                        }
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(this, helperField){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ Field $helperField;

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            try {
                                this.$helperField.set(null, null);
                            }
                            catch (Exception ignored) {
                                SharkLog this_$iv = SharkLog.INSTANCE;
                                boolean $i$f$d = false;
                                SharkLog.Logger logger = this_$iv.getLogger();
                                if (logger == null) {
                                }
                                SharkLog.Logger logger$iv = logger;
                                Throwable throwable = ignored;
                                SharkLog.Logger logger2 = logger$iv;
                                boolean bl = false;
                                String string = "Could not fix the " + this.this$0.this$0.name() + " leak";
                                logger2.d(throwable, string);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$helperField = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = bUBBLE_POPUP;
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        BUBBLE_POPUP() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$LAST_HOVERED_VIEW;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class LAST_HOVERED_VIEW
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || 19 > (n = Build.VERSION.SDK_INT) || 21 < n) {
                return;
            }
            backgroundExecutor.execute(new Runnable(this, application){
                final /* synthetic */ LAST_HOVERED_VIEW this$0;
                final /* synthetic */ Application $application;

                public final void run() {
                    Field field = null;
                    try {
                        Field field2 = TextView.class.getDeclaredField("mLastHoveredView");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"TextView::class.java.get\u2026Field(\"mLastHoveredView\")");
                        field = field2;
                        field.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv = logger;
                            Throwable throwable = ignored;
                            SharkLog.Logger logger2 = logger$iv;
                            boolean bl = false;
                            String string = "Could not fix the " + this.this$0.name() + " leak";
                            logger2.d(throwable, string);
                        }
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(this, field){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ Field $field;

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            try {
                                this.$field.set(null, null);
                            }
                            catch (Exception ignored) {
                                SharkLog this_$iv = SharkLog.INSTANCE;
                                boolean $i$f$d = false;
                                SharkLog.Logger logger = this_$iv.getLogger();
                                if (logger == null) {
                                }
                                SharkLog.Logger logger$iv = logger;
                                Throwable throwable = ignored;
                                SharkLog.Logger logger2 = logger$iv;
                                boolean bl = false;
                                String string = "Could not fix the " + this.this$0.this$0.name() + " leak";
                                logger2.d(throwable, string);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$field = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = lAST_HOVERED_VIEW;
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        LAST_HOVERED_VIEW() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$ACTIVITY_MANAGER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class ACTIVITY_MANAGER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)AndroidLeakFixes.SAMSUNG) ^ true || Build.VERSION.SDK_INT != 22) {
                return;
            }
            backgroundExecutor.execute(new Runnable(this, application){
                final /* synthetic */ ACTIVITY_MANAGER this$0;
                final /* synthetic */ Application $application;

                public final void run() {
                    Field contextField = null;
                    try {
                        Field field = this.$application.getSystemService("activity").getClass().getDeclaredField("mContext");
                        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"application\n            \u2026DeclaredField(\"mContext\")");
                        contextField = field;
                        contextField.setAccessible(true);
                        if ((contextField.getModifiers() | 8) != contextField.getModifiers()) {
                            SharkLog this_$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            SharkLog.Logger logger = this_$iv.getLogger();
                            if (logger == null) {
                            } else {
                                SharkLog.Logger logger$iv;
                                SharkLog.Logger logger2 = logger$iv = logger;
                                boolean bl = false;
                                String string = "Could not fix the " + this.this$0.name() + " leak, contextField=" + contextField;
                                logger2.d(string);
                            }
                            return;
                        }
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv = logger;
                            Throwable throwable = ignored;
                            SharkLog.Logger logger3 = logger$iv;
                            boolean bl = false;
                            String string = "Could not fix the " + this.this$0.name() + " leak";
                            logger3.d(throwable, string);
                        }
                        return;
                    }
                    AndroidLeakFixes.Companion.onActivityDestroyed$plumber_android_release(this.$application, (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(this, contextField){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ Field $contextField;

                        public final void invoke(@NotNull Activity activity) {
                            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                            try {
                                if (Intrinsics.areEqual((Object)this.$contextField.get(null), (Object)activity)) {
                                    this.$contextField.set(null, null);
                                }
                            }
                            catch (Exception ignored) {
                                SharkLog this_$iv = SharkLog.INSTANCE;
                                boolean $i$f$d = false;
                                SharkLog.Logger logger = this_$iv.getLogger();
                                if (logger == null) {
                                }
                                SharkLog.Logger logger$iv = logger;
                                Throwable throwable = ignored;
                                SharkLog.Logger logger2 = logger$iv;
                                boolean bl = false;
                                String string = "Could not fix the " + this.this$0.this$0.name() + " leak";
                                logger2.d(throwable, string);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$contextField = field;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = aCTIVITY_MANAGER;
                    this.$application = application;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        ACTIVITY_MANAGER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$VIEW_LOCATION_HOLDER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class VIEW_LOCATION_HOLDER
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            ViewLocationHolderLeakFix.INSTANCE.applyFix$plumber_android_release(application);
        }

        /*
         * WARNING - void declaration
         */
        VIEW_LOCATION_HOLDER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0015\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$IMM_FOCUSED_VIEW;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class IMM_FOCUSED_VIEW
    extends AndroidLeakFixes {
        @Override
        @TargetApi(value=23)
        @SuppressLint(value={"PrivateApi"})
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT > 23) {
                return;
            }
            Object object = application.getSystemService("input_method");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            Field mServedViewField = null;
            Field mHField = null;
            Method finishInputLockedMethod = null;
            Method focusInMethod = null;
            try {
                Field field = InputMethodManager.class.getDeclaredField("mServedView");
                Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"InputMethodManager::clas\u2026laredField(\"mServedView\")");
                mServedViewField = field;
                mServedViewField.setAccessible(true);
                Field field2 = InputMethodManager.class.getDeclaredField("mH");
                Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"InputMethodManager::clas\u2026va.getDeclaredField(\"mH\")");
                mHField = field2;
                mHField.setAccessible(true);
                Method method = InputMethodManager.class.getDeclaredMethod("finishInputLocked", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"InputMethodManager::clas\u2026thod(\"finishInputLocked\")");
                finishInputLockedMethod = method;
                finishInputLockedMethod.setAccessible(true);
                Method method2 = InputMethodManager.class.getDeclaredMethod("focusIn", View.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"InputMethodManager::clas\u2026iew::class.java\n        )");
                focusInMethod = method2;
                focusInMethod.setAccessible(true);
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv = logger;
                    Throwable throwable = ignored;
                    SharkLog.Logger logger2 = logger$iv;
                    boolean bl = false;
                    String string = "Could not fix the " + this.name() + " leak";
                    logger2.d(throwable, string);
                }
                return;
            }
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(inputMethodManager, mHField, mServedViewField, finishInputLockedMethod){
                private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
                final /* synthetic */ InputMethodManager $inputMethodManager;
                final /* synthetic */ Field $mHField;
                final /* synthetic */ Field $mServedViewField;
                final /* synthetic */ Method $finishInputLockedMethod;

                public void onActivityCreated(@NotNull Activity activity, @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    Window window = activity.getWindow();
                    Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
                    leakcanary.AndroidLeakFixes$Companion.access$onDecorViewReady(AndroidLeakFixes.Companion, window, (Function0)new Function0<Unit>(this, activity){
                        final /* synthetic */ apply.2 this$0;
                        final /* synthetic */ Activity $activity;

                        public final void invoke() {
                            View rootView;
                            ReferenceCleaner cleaner = new ReferenceCleaner(this.this$0.$inputMethodManager, this.this$0.$mHField, this.this$0.$mServedViewField, this.this$0.$finishInputLockedMethod);
                            Window window = this.$activity.getWindow();
                            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
                            View view = window.getDecorView();
                            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"activity.window.decorView");
                            View view2 = rootView = view.getRootView();
                            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"rootView");
                            ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                            viewTreeObserver.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)cleaner);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$activity = activity;
                            super(0);
                        }
                    });
                }
                {
                    this.$inputMethodManager = $captured_local_variable$0;
                    this.$mHField = $captured_local_variable$1;
                    this.$mServedViewField = $captured_local_variable$2;
                    this.$finishInputLockedMethod = $captured_local_variable$3;
                    boolean $i$f$noOpDelegate = false;
                    boolean $i$f$noOpDelegate2 = false;
                    Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
                    Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                    }
                    this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
                }

                public void onActivityDestroyed(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityDestroyed(p0);
                }

                public void onActivityPaused(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityPaused(p0);
                }

                public void onActivityResumed(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityResumed(p0);
                }

                public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                    this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
                }

                public void onActivityStarted(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStarted(p0);
                }

                public void onActivityStopped(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStopped(p0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        IMM_FOCUSED_VIEW() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$IMM_CUR_ROOT_VIEW;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class IMM_CUR_ROOT_VIEW
    extends AndroidLeakFixes {
        @Override
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT >= 29) {
                return;
            }
            Object object = application.getSystemService("input_method");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            Field mCurRootViewField = null;
            try {
                Field field = InputMethodManager.class.getDeclaredField("mCurRootView");
                Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"InputMethodManager::clas\u2026aredField(\"mCurRootView\")");
                mCurRootViewField = field;
                mCurRootViewField.setAccessible(true);
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv = logger;
                    Throwable throwable = ignored;
                    SharkLog.Logger logger2 = logger$iv;
                    boolean bl = false;
                    String string = "Could not read InputMethodManager.mCurRootView field";
                    logger2.d(throwable, string);
                }
                return;
            }
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(mCurRootViewField, inputMethodManager){
                private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
                final /* synthetic */ Field $mCurRootViewField;
                final /* synthetic */ InputMethodManager $inputMethodManager;

                public void onActivityDestroyed(@NotNull Activity activity) {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    try {
                        View rootView = (View)this.$mCurRootViewField.get(this.$inputMethodManager);
                        if (rootView != null && activity.getWindow() != null) {
                            Window window = activity.getWindow();
                            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
                            if (window.getDecorView() == rootView) {
                                this.$mCurRootViewField.set(this.$inputMethodManager, null);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        }
                        SharkLog.Logger logger$iv = logger;
                        Throwable throwable = ignored;
                        SharkLog.Logger logger2 = logger$iv;
                        boolean bl = false;
                        String string = "Could not update InputMethodManager.mCurRootView field";
                        logger2.d(throwable, string);
                    }
                }
                {
                    this.$mCurRootViewField = $captured_local_variable$0;
                    this.$inputMethodManager = $captured_local_variable$1;
                    boolean $i$f$noOpDelegate = false;
                    boolean $i$f$noOpDelegate2 = false;
                    Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
                    Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                    }
                    this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
                }

                public void onActivityCreated(@RecentlyNonNull Activity p0, @RecentlyNullable Bundle p1) {
                    this.$$delegate_0.onActivityCreated(p0, p1);
                }

                public void onActivityPaused(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityPaused(p0);
                }

                public void onActivityResumed(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityResumed(p0);
                }

                public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                    this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
                }

                public void onActivityStarted(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStarted(p0);
                }

                public void onActivityStopped(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStopped(p0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        IMM_CUR_ROOT_VIEW() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0015\u00a8\u0006\u0006"}, d2={"Lleakcanary/AndroidLeakFixes$SPELL_CHECKER;", "Lleakcanary/AndroidLeakFixes;", "apply", "", "application", "Landroid/app/Application;", "plumber-android_release"})
    static final class SPELL_CHECKER
    extends AndroidLeakFixes {
        @Override
        @TargetApi(value=23)
        @SuppressLint(value={"PrivateApi"})
        protected void apply(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (Build.VERSION.SDK_INT != 23) {
                return;
            }
            try {
                Class<TextServicesManager> textServiceClass = TextServicesManager.class;
                Method method = textServiceClass.getDeclaredMethod("getInstance", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"textServiceClass.getDeclaredMethod(\"getInstance\")");
                Method getInstanceMethod = method;
                Field field = textServiceClass.getDeclaredField("sService");
                Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"textServiceClass.getDeclaredField(\"sService\")");
                Field sServiceField = field;
                sServiceField.setAccessible(true);
                Class<?> clazz = Class.forName("com.android.internal.textservice.ITextServicesManager");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"com.andro\u2026ce.ITextServicesManager\")");
                Class<?> serviceStubInterface = clazz;
                Class<?> clazz2 = Class.forName("android.view.textservice.SpellCheckerSession");
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(\"android.v\u2026ice.SpellCheckerSession\")");
                Class<?> spellCheckSessionClass = clazz2;
                Field field2 = spellCheckSessionClass.getDeclaredField("mSpellCheckerSessionListener");
                Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"spellCheckSessionClass.g\u2026lCheckerSessionListener\")");
                Field mSpellCheckerSessionListenerField = field2;
                mSpellCheckerSessionListenerField.setAccessible(true);
                Class<?> clazz3 = Class.forName("android.view.textservice.SpellCheckerSession$SpellCheckerSessionListenerImpl");
                Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"Class.forName(\n         \u2026ListenerImpl\"\n          )");
                Class<?> spellCheckerSessionListenerImplClass = clazz3;
                Field field3 = spellCheckerSessionListenerImplClass.getDeclaredField("mHandler");
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"spellCheckerSessionListe\u2026DeclaredField(\"mHandler\")");
                Field listenerImplHandlerField = field3;
                listenerImplHandlerField.setAccessible(true);
                Class<?> clazz4 = Class.forName("android.view.textservice.SpellCheckerSession$1");
                Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"Class.forName(\"android.v\u2026.SpellCheckerSession\\$1\")");
                Class<?> spellCheckSessionHandlerClass = clazz4;
                Field field4 = spellCheckSessionHandlerClass.getDeclaredField("this$0");
                Intrinsics.checkExpressionValueIsNotNull((Object)field4, (String)"spellCheckSessionHandler\u2026etDeclaredField(\"this$0\")");
                Field outerInstanceField = field4;
                outerInstanceField.setAccessible(true);
                Class<?> clazz5 = Class.forName("android.view.textservice.SpellCheckerSession$SpellCheckerSessionListener");
                Intrinsics.checkExpressionValueIsNotNull(clazz5, (String)"Class.forName(\"android.v\u2026lCheckerSessionListener\")");
                Class<?> listenerInterface = clazz5;
                Object object = Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)apply.noOpListener.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Proxy.newProxyInstance(\n\u2026ssion closed\" }\n        }");
                Object noOpListener2 = object;
                getInstanceMethod.invoke(null, new Object[0]);
                Object object2 = sServiceField.get(null);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                Object realService = object2;
                boolean bl = false;
                Map spellCheckerListenerToSession = new LinkedHashMap();
                Object object3 = Proxy.newProxyInstance(serviceStubInterface.getClassLoader(), new Class[]{serviceStubInterface}, new InvocationHandler(listenerImplHandlerField, outerInstanceField, spellCheckerListenerToSession, noOpListener2, mSpellCheckerSessionListenerField, realService){
                    final /* synthetic */ Field $listenerImplHandlerField;
                    final /* synthetic */ Field $outerInstanceField;
                    final /* synthetic */ Map $spellCheckerListenerToSession;
                    final /* synthetic */ Object $noOpListener;
                    final /* synthetic */ Field $mSpellCheckerSessionListenerField;
                    final /* synthetic */ Object $realService;

                    public final Object invoke(@NotNull Object $noName_0, @NotNull Method method, @org.jetbrains.annotations.Nullable Object[] args) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                        try {
                            if (Intrinsics.areEqual((Object)method.getName(), (Object)"getSpellCheckerService")) {
                                if (args == null) {
                                    Intrinsics.throwNpe();
                                }
                                Object spellCheckerSessionListener = args[3];
                                Object object = this.$listenerImplHandlerField.get(spellCheckerSessionListener);
                                if (object == null) {
                                    Intrinsics.throwNpe();
                                }
                                Object handler = object;
                                Object object2 = this.$outerInstanceField.get(handler);
                                if (object2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Object spellCheckerSession = object2;
                                this.$spellCheckerListenerToSession.put(spellCheckerSessionListener, spellCheckerSession);
                            } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"finishSpellCheckerService")) {
                                if (args == null) {
                                    Intrinsics.throwNpe();
                                }
                                Object spellCheckerSessionListener = args[0];
                                V v = this.$spellCheckerListenerToSession.remove(spellCheckerSessionListener);
                                if (v == null) {
                                    Intrinsics.throwNpe();
                                }
                                V spellCheckerSession = v;
                                this.$mSpellCheckerSessionListenerField.set(spellCheckerSession, this.$noOpListener);
                            }
                        }
                        catch (Exception ignored) {
                            SharkLog this_$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            SharkLog.Logger logger = this_$iv.getLogger();
                            if (logger == null) {
                            }
                            SharkLog.Logger logger$iv = logger;
                            Throwable throwable = ignored;
                            SharkLog.Logger logger2 = logger$iv;
                            boolean bl = false;
                            String string = "Unable to fix SpellChecker leak";
                            logger2.d(throwable, string);
                        }
                        try {
                            return args != null ? method.invoke(this.$realService, Arrays.copyOf(args, args.length)) : method.invoke(this.$realService, new Object[0]);
                        }
                        catch (InvocationTargetException invocationException) {
                            Throwable throwable = invocationException.getTargetException();
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"invocationException.targetException");
                            throw throwable;
                        }
                    }
                    {
                        this.$listenerImplHandlerField = field;
                        this.$outerInstanceField = field2;
                        this.$spellCheckerListenerToSession = map;
                        this.$noOpListener = object;
                        this.$mSpellCheckerSessionListenerField = field3;
                        this.$realService = object2;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"Proxy.newProxyInstance(\n\u2026ion\n          }\n        }");
                Object proxyService2 = object3;
                sServiceField.set(null, proxyService2);
            }
            catch (Exception ignored) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                }
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = ignored;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Unable to fix SpellChecker leak";
                logger2.d(throwable, string);
            }
        }

        /*
         * WARNING - void declaration
         */
        SPELL_CHECKER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J%\u0010\u0013\u001a\u00020\n*\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015H\u0000\u00a2\u0006\u0002\b\u0017J\u001a\u0010\u0018\u001a\u00020\n*\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001a\u0010\u001c\u001a\u00020\n*\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\u001a\u0010\u001e\u001a\u00020\n*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\f\u0010!\u001a\u00020\"*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lleakcanary/AndroidLeakFixes$Companion;", "", "()V", "LG", "", "SAMSUNG", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "applyFixes", "", "application", "Landroid/app/Application;", "fixes", "", "Lleakcanary/AndroidLeakFixes;", "findAllHandlerThreads", "", "Landroid/os/HandlerThread;", "onActivityDestroyed", "block", "Lkotlin/Function1;", "Landroid/app/Activity;", "onActivityDestroyed$plumber_android_release", "onContentChanged", "Landroid/view/Window;", "Lkotlin/Function0;", "", "onDecorViewReady", "callback", "onEachIdle", "Landroid/os/Handler;", "onIdle", "wrapCallback", "Lleakcanary/AndroidLeakFixes$Companion$WindowDelegateCallback;", "WindowDelegateCallback", "plumber-android_release"})
    public static final class Companion {
        public final void applyFixes(@NotNull Application application, @NotNull Set<? extends AndroidLeakFixes> fixes) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull(fixes, (String)"fixes");
            boolean $i$f$checkMainThread = false;
            HandlersKt.checkMainThread();
            Iterable $this$forEach$iv = fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SharkLog.Logger logger$iv;
                AndroidLeakFixes fix = (AndroidLeakFixes)((Object)element$iv);
                boolean bl = false;
                if (!fix.applied) {
                    fix.apply(application);
                    fix.applied = true;
                    continue;
                }
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                if (this_$iv.getLogger() == null) {
                    continue;
                }
                SharkLog.Logger logger = logger$iv;
                boolean bl2 = false;
                String string = fix.name() + " leak fix already applied.";
                logger.d(string);
            }
        }

        public static /* synthetic */ void applyFixes$default(Companion companion, Application application, Set set, int n, Object object) {
            if ((n & 2) != 0) {
                EnumSet<AndroidLeakFixes> enumSet = EnumSet.allOf(AndroidLeakFixes.class);
                Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.allOf(AndroidLeakFixes::class.java)");
                set = enumSet;
            }
            companion.applyFixes(application, set);
        }

        private final void onEachIdle(Handler $this$onEachIdle, Function0<Unit> onIdle) {
            try {
                $this$onEachIdle.post(new Runnable(onIdle){
                    final /* synthetic */ Function0 $onIdle;

                    public final void run() {
                        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(this){
                            final /* synthetic */ onEachIdle.1 this$0;

                            public final boolean queueIdle() {
                                this.this$0.$onIdle.invoke();
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$onIdle = function0;
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<HandlerThread> findAllHandlerThreads() {
            void $this$mapNotNullTo$iv$iv;
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
            ThreadGroup threadGroup = thread2.getThreadGroup();
            if (threadGroup == null) {
                Intrinsics.throwNpe();
            }
            ThreadGroup rootGroup = threadGroup;
            while (rootGroup.getParent() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)rootGroup.getParent(), (String)"rootGroup.parent");
            }
            Thread[] threads = new Thread[rootGroup.activeCount()];
            while (rootGroup.enumerate(threads, true) == threads.length) {
                threads = new Thread[threads.length * 2];
            }
            Thread[] $this$mapNotNull$iv = threads;
            boolean $i$f$mapNotNull = false;
            Thread[] threadArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var10_10 = $this$forEach$iv$iv$iv;
            int n = ((void)var10_10).length;
            for (int i = 0; i < n; ++i) {
                HandlerThread handlerThread;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var10_10[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof HandlerThread ? (HandlerThread)it : null) == null) continue;
                handlerThread = handlerThread;
                boolean bl3 = false;
                boolean bl4 = false;
                HandlerThread it$iv$iv = handlerThread;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final void onActivityDestroyed$plumber_android_release(@NotNull Application $this$onActivityDestroyed, @NotNull Function1<? super Activity, Unit> block) {
            Intrinsics.checkParameterIsNotNull((Object)$this$onActivityDestroyed, (String)"$this$onActivityDestroyed");
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            $this$onActivityDestroyed.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(block){
                private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
                final /* synthetic */ Function1 $block;

                public void onActivityDestroyed(@NotNull Activity activity) {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    this.$block.invoke((Object)activity);
                }
                {
                    this.$block = $captured_local_variable$0;
                    boolean $i$f$noOpDelegate = false;
                    boolean $i$f$noOpDelegate2 = false;
                    Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
                    Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                    }
                    this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
                }

                public void onActivityCreated(@RecentlyNonNull Activity p0, @RecentlyNullable Bundle p1) {
                    this.$$delegate_0.onActivityCreated(p0, p1);
                }

                public void onActivityPaused(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityPaused(p0);
                }

                public void onActivityResumed(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityResumed(p0);
                }

                public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                    this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
                }

                public void onActivityStarted(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStarted(p0);
                }

                public void onActivityStopped(@RecentlyNonNull Activity p0) {
                    this.$$delegate_0.onActivityStopped(p0);
                }
            });
        }

        private final void onDecorViewReady(Window $this$onDecorViewReady, Function0<Unit> callback) {
            if ($this$onDecorViewReady.peekDecorView() == null) {
                this.onContentChanged($this$onDecorViewReady, (Function0<Boolean>)((Function0)new Function0<Boolean>(callback){
                    final /* synthetic */ Function0 $callback;

                    public final boolean invoke() {
                        this.$callback.invoke();
                        return false;
                    }
                    {
                        this.$callback = function0;
                        super(0);
                    }
                }));
            } else {
                callback.invoke();
            }
        }

        private final void onContentChanged(Window $this$onContentChanged, Function0<Boolean> block) {
            WindowDelegateCallback callback = this.wrapCallback($this$onContentChanged);
            Collection collection = callback.getOnContentChangedCallbacks();
            boolean bl = false;
            collection.add(block);
        }

        /*
         * WARNING - void declaration
         */
        private final WindowDelegateCallback wrapCallback(Window $this$wrapCallback) {
            WindowDelegateCallback windowDelegateCallback;
            Window.Callback currentCallback = $this$wrapCallback.getCallback();
            if (currentCallback instanceof WindowDelegateCallback) {
                windowDelegateCallback = (WindowDelegateCallback)currentCallback;
            } else {
                void var3_3;
                Window.Callback callback = currentCallback;
                Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"currentCallback");
                WindowDelegateCallback newCallback = new WindowDelegateCallback(callback);
                $this$wrapCallback.setCallback((Window.Callback)newCallback);
                windowDelegateCallback = var3_3;
            }
            return windowDelegateCallback;
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$findAllHandlerThreads(Companion $this) {
            return $this.findAllHandlerThreads();
        }

        public static final /* synthetic */ void access$onEachIdle(Companion $this, Handler $this$access_u24onEachIdle, Function0 onIdle) {
            $this.onEachIdle($this$access_u24onEachIdle, (Function0<Unit>)onIdle);
        }

        public static final /* synthetic */ void access$onDecorViewReady(Companion $this, Window $this$access_u24onDecorViewReady, Function0 callback) {
            $this.onDecorViewReady($this$access_u24onDecorViewReady, (Function0<Unit>)callback);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0019\u0010\u000e\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fH\u0096\u0001J\u0019\u0010\u0010\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fH\u0096\u0001J\u0019\u0010\u0011\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\u00120\u0012H\u0096\u0001J\u0019\u0010\u0013\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0019\u0010\u0014\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\u0019\u0010\u0018\u001a\u00020\u00162\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\t\u0010\u0019\u001a\u00020\u0016H\u0096\u0001J\b\u0010\u001a\u001a\u00020\u0016H\u0016J#\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001c2\u0010\b\u0001\u0010\u001d\u001a\n \r*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J\u0013\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\u001cH\u0097\u0001J\t\u0010!\u001a\u00020\u0016H\u0096\u0001J#\u0010\"\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001c2\u0010\b\u0001\u0010\u001d\u001a\n \r*\u0004\u0018\u00010#0#H\u0096\u0001J#\u0010$\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001c2\u0010\b\u0001\u0010\u001d\u001a\n \r*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J#\u0010%\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u001c2\u0010\b\u0001\u0010\u001d\u001a\n \r*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J5\u0010&\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001c2\u0010\b\u0001\u0010\u001d\u001a\n \r*\u0004\u0018\u00010 0 2\u0010\b\u0001\u0010'\u001a\n \r*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J\t\u0010(\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010(\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010)0)H\u0096\u0001J\u0019\u0010*\u001a\u00020\u00162\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010+0+H\u0096\u0001J\u0011\u0010,\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010-\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010.0.H\u0097\u0001J#\u0010-\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010.0.2\u0006\u0010\u001d\u001a\u00020\u001cH\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lleakcanary/AndroidLeakFixes$Companion$WindowDelegateCallback;", "Landroid/view/Window$Callback;", "delegate", "(Landroid/view/Window$Callback;)V", "onContentChangedCallbacks", "", "Lkotlin/Function0;", "", "getOnContentChangedCallbacks", "()Ljava/util/List;", "dispatchGenericMotionEvent", "p0", "Landroid/view/MotionEvent;", "kotlin.jvm.PlatformType", "dispatchKeyEvent", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "dispatchTrackballEvent", "onActionModeFinished", "", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "plumber-android_release"})
        private static final class WindowDelegateCallback
        implements Window.Callback {
            @NotNull
            private final List<Function0<Boolean>> onContentChangedCallbacks;
            private final Window.Callback delegate;

            @NotNull
            public final List<Function0<Boolean>> getOnContentChangedCallbacks() {
                return this.onContentChangedCallbacks;
            }

            public void onContentChanged() {
                CollectionsKt.removeAll(this.onContentChangedCallbacks, (Function1)onContentChanged.1.INSTANCE);
                this.delegate.onContentChanged();
            }

            public WindowDelegateCallback(@NotNull Window.Callback delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                this.delegate = delegate;
                boolean bl = false;
                this.onContentChangedCallbacks = new ArrayList();
            }

            public boolean dispatchGenericMotionEvent(MotionEvent p0) {
                return this.delegate.dispatchGenericMotionEvent(p0);
            }

            public boolean dispatchKeyEvent(KeyEvent p0) {
                return this.delegate.dispatchKeyEvent(p0);
            }

            public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
                return this.delegate.dispatchKeyShortcutEvent(p0);
            }

            public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
                return this.delegate.dispatchPopulateAccessibilityEvent(p0);
            }

            public boolean dispatchTouchEvent(MotionEvent p0) {
                return this.delegate.dispatchTouchEvent(p0);
            }

            public boolean dispatchTrackballEvent(MotionEvent p0) {
                return this.delegate.dispatchTrackballEvent(p0);
            }

            public void onActionModeFinished(ActionMode p0) {
                this.delegate.onActionModeFinished(p0);
            }

            public void onActionModeStarted(ActionMode p0) {
                this.delegate.onActionModeStarted(p0);
            }

            public void onAttachedToWindow() {
                this.delegate.onAttachedToWindow();
            }

            public boolean onCreatePanelMenu(int p0, @RecentlyNonNull Menu p1) {
                return this.delegate.onCreatePanelMenu(p0, p1);
            }

            @Nullable
            @org.jetbrains.annotations.Nullable
            public View onCreatePanelView(int p0) {
                return this.delegate.onCreatePanelView(p0);
            }

            public void onDetachedFromWindow() {
                this.delegate.onDetachedFromWindow();
            }

            public boolean onMenuItemSelected(int p0, @RecentlyNonNull MenuItem p1) {
                return this.delegate.onMenuItemSelected(p0, p1);
            }

            public boolean onMenuOpened(int p0, @RecentlyNonNull Menu p1) {
                return this.delegate.onMenuOpened(p0, p1);
            }

            public void onPanelClosed(int p0, @RecentlyNonNull Menu p1) {
                this.delegate.onPanelClosed(p0, p1);
            }

            public boolean onPreparePanel(int p0, @RecentlyNullable View p1, @RecentlyNonNull Menu p2) {
                return this.delegate.onPreparePanel(p0, p1, p2);
            }

            public boolean onSearchRequested() {
                return this.delegate.onSearchRequested();
            }

            public boolean onSearchRequested(SearchEvent p0) {
                return this.delegate.onSearchRequested(p0);
            }

            public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
                this.delegate.onWindowAttributesChanged(p0);
            }

            public void onWindowFocusChanged(boolean p0) {
                this.delegate.onWindowFocusChanged(p0);
            }

            @Nullable
            @org.jetbrains.annotations.Nullable
            public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
                return this.delegate.onWindowStartingActionMode(p0);
            }

            @Nullable
            @org.jetbrains.annotations.Nullable
            public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
                return this.delegate.onWindowStartingActionMode(p0, p1);
            }
        }
    }
}

