/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import shark.AndroidBuildMirror;
import shark.AndroidMetadataExtractor;
import shark.AndroidNativeSizeMapper;
import shark.GcRoot;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.MetadataExtractor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lshark/AndroidMetadataExtractor;", "Lshark/MetadataExtractor;", "()V", "extractMetadata", "", "", "graph", "Lshark/HeapGraph;", "readHeapTotalBytes", "", "readLeakCanaryVersion", "readProcessName", "readThreadCount", "putBitmaps", "", "", "putDbLabels", "shark-android"})
@SourceDebugExtension(value={"SMAP\nAndroidMetadataExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidMetadataExtractor.kt\nshark/AndroidMetadataExtractor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Friendly.kt\nshark/internal/friendly/shark-android_Friendly\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n2438#2,5:129\n1295#2,2:135\n1306#2,3:152\n10#3:134\n800#4,11:137\n1549#4:148\n1620#4,3:149\n*S KotlinDebug\n*F\n+ 1 AndroidMetadataExtractor.kt\nshark/AndroidMetadataExtractor\n*L\n32#1:129,5\n66#1:135,2\n123#1:152,3\n60#1:134\n85#1:137,11\n85#1:148\n85#1:149,3\n*E\n"})
public final class AndroidMetadataExtractor
implements MetadataExtractor {
    @NotNull
    public static final AndroidMetadataExtractor INSTANCE = new AndroidMetadataExtractor();

    private AndroidMetadataExtractor() {
    }

    @NotNull
    public Map<String, String> extractMetadata(@NotNull HeapGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Map metadata = new LinkedHashMap();
        AndroidBuildMirror build = AndroidBuildMirror.Companion.fromHeapGraph(graph);
        metadata.put("Build.VERSION.SDK_INT", String.valueOf(build.getSdkInt()));
        metadata.put("Build.MANUFACTURER", build.getManufacturer());
        metadata.put("LeakCanary version", this.readLeakCanaryVersion(graph));
        metadata.put("App process name", this.readProcessName(graph));
        metadata.put("Class count", String.valueOf(graph.getClassCount()));
        metadata.put("Instance count", String.valueOf(graph.getInstanceCount()));
        metadata.put("Primitive array count", String.valueOf(graph.getPrimitiveArrayCount()));
        metadata.put("Object array count", String.valueOf(graph.getObjectArrayCount()));
        metadata.put("Thread count", String.valueOf(this.readThreadCount(graph)));
        metadata.put("Heap total bytes", String.valueOf(this.readHeapTotalBytes(graph)));
        this.putBitmaps(metadata, graph);
        this.putDbLabels(metadata, graph);
        return metadata;
    }

    /*
     * WARNING - void declaration
     */
    private final int readHeapTotalBytes(HeapGraph graph) {
        Sequence $this$sumBy$iv = graph.getObjects();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            int n;
            void heapObject;
            HeapObject heapObject2 = (HeapObject)element$iv;
            int n2 = sum$iv;
            boolean bl = false;
            void var9_9 = heapObject;
            if (var9_9 instanceof HeapObject.HeapInstance) {
                n = ((HeapObject.HeapInstance)heapObject).getByteSize();
            } else if (var9_9 instanceof HeapObject.HeapClass) {
                n = heapObject.getRecordSize();
            } else if (var9_9 instanceof HeapObject.HeapObjectArray) {
                n = ((HeapObject.HeapObjectArray)heapObject).getByteSize();
            } else if (var9_9 instanceof HeapObject.HeapPrimitiveArray) {
                n = ((HeapObject.HeapPrimitiveArray)heapObject).getByteSize();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int n3 = n;
            sum$iv = n2 + n3;
        }
        return sum$iv;
    }

    private final void putBitmaps(Map<String, String> $this$putBitmaps, HeapGraph graph) {
        Sequence sequence;
        Sequence sequence2;
        HeapObject.HeapClass heapClass = graph.findClassByName("android.graphics.Bitmap");
        if (heapClass == null) {
            return;
        }
        HeapObject.HeapClass bitmapClass = heapClass;
        HeapObject.HeapClass heapClass2 = graph.findClassByName("android.util.DisplayMetrics");
        int maxDisplayPixels2 = heapClass2 != null && (sequence2 = heapClass2.getDirectInstances()) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)putBitmaps.maxDisplayPixels.1.INSTANCE)) != null ? ((Number)((Object)SequencesKt.maxOrThrow((Sequence)sequence))).intValue() : 0;
        int maxDisplayPixelsWithThreshold = (int)((double)maxDisplayPixels2 * 1.1);
        HeapGraph $this$mapNativeSizes$iv = graph;
        boolean $i$f$mapNativeSizes = false;
        Map sizeMap = AndroidNativeSizeMapper.Companion.mapNativeSizes($this$mapNativeSizes$iv);
        int sizeSum = 0;
        int count = 0;
        int largeBitmapCount = 0;
        int largeBitmapSizeSum = 0;
        Sequence $this$forEach$iv = bitmapClass.getInstances();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapInstance bitmap = (HeapObject.HeapInstance)element$iv;
            boolean bl = false;
            Object object = bitmap.get("android.graphics.Bitmap", "mWidth");
            int width = object != null && (object = object.getValue()) != null && (object = object.getAsInt()) != null ? (Integer)object : 0;
            Object object2 = bitmap.get("android.graphics.Bitmap", "mHeight");
            int height = object2 != null && (object2 = object2.getValue()) != null && (object2 = object2.getAsInt()) != null ? (Integer)object2 : 0;
            Integer n = (Integer)sizeMap.get(bitmap.getObjectId());
            int size = n != null ? n : 0;
            ++count;
            sizeSum += size;
            if (maxDisplayPixelsWithThreshold <= 0 || width * height <= maxDisplayPixelsWithThreshold) continue;
            ++largeBitmapCount;
            largeBitmapSizeSum += size;
        }
        $this$putBitmaps.put("Bitmap count", String.valueOf(count));
        $this$putBitmaps.put("Bitmap total bytes", String.valueOf(sizeSum));
        $this$putBitmaps.put("Large bitmap count", String.valueOf(largeBitmapCount));
        $this$putBitmaps.put("Large bitmap total bytes", String.valueOf(largeBitmapSizeSum));
    }

    /*
     * WARNING - void declaration
     */
    private final int readThreadCount(HeapGraph graph) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = graph.getGcRoots();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GcRoot.ThreadObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GcRoot.ThreadObject threadObject = (GcRoot.ThreadObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size();
    }

    private final String readLeakCanaryVersion(HeapGraph graph) {
        HeapObject.HeapClass versionHolderClass = graph.findClassByName("leakcanary.internal.InternalLeakCanary");
        Object object = versionHolderClass;
        if (object == null || (object = object.get("version")) == null || (object = object.getValue()) == null || (object = object.readAsJavaString()) == null) {
            object = "Unknown";
        }
        return object;
    }

    private final String readProcessName(HeapGraph graph) {
        String string;
        HeapObject.HeapInstance heapInstance;
        HeapField heapField;
        HeapField heapField2;
        HeapObject.HeapClass heapClass = graph.findClassByName("android.app.ActivityThread");
        HeapObject.HeapInstance activityThread = heapClass != null && (heapField2 = heapClass.get("sCurrentActivityThread")) != null ? heapField2.getValueAsInstance() : null;
        HeapObject.HeapInstance appBindData = activityThread != null && (heapField2 = activityThread.get("android.app.ActivityThread", "mBoundApplication")) != null ? heapField2.getValueAsInstance() : null;
        HeapObject.HeapInstance appInfo = appBindData != null && (heapField = appBindData.get("android.app.ActivityThread$AppBindData", "appInfo")) != null ? heapField.getValueAsInstance() : null;
        return appInfo != null && (heapField = appInfo.get("android.content.pm.ApplicationInfo", "processName")) != null && (heapInstance = heapField.getValueAsInstance()) != null && (string = heapInstance.readAsJavaString()) != null ? string : "Unknown";
    }

    private final void putDbLabels(Map<String, String> $this$putDbLabels, HeapGraph graph) {
        Sequence openDbLabels2;
        HeapObject.HeapClass heapClass = graph.findClassByName("android.database.sqlite.SQLiteDatabase");
        if (heapClass == null) {
            return;
        }
        HeapObject.HeapClass dbClass = heapClass;
        Sequence $this$forEachIndexed$iv = openDbLabels2 = SequencesKt.mapNotNull((Sequence)dbClass.getInstances(), (Function1)putDbLabels.openDbLabels.1.INSTANCE);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            String label = (String)pair.component1();
            boolean open = (Boolean)pair.component2();
            $this$putDbLabels.put("Db " + (index + 1), (open ? "open " : "closed ") + label);
        }
    }
}

