/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import shark.HprofRecord;
import shark.PrimitiveType;
import shark.ValueHolder;
import shark.internal.ByteSubArrayKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lshark/internal/FieldValuesReader;", "", "record", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;", "identifierByteSize", "", "(Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;I)V", "position", "readBoolean", "", "readByte", "", "readChar", "", "readDouble", "", "readFloat", "", "readId", "", "readInt", "readLong", "readShort", "", "readValue", "Lshark/ValueHolder;", "field", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$FieldRecord;", "Companion", "shark-graph"})
public final class FieldValuesReader {
    private int position;
    private final HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord record;
    private final int identifierByteSize;
    private static final int BOOLEAN_TYPE;
    private static final int CHAR_TYPE;
    private static final int FLOAT_TYPE;
    private static final int DOUBLE_TYPE;
    private static final int BYTE_TYPE;
    private static final int SHORT_TYPE;
    private static final int INT_TYPE;
    private static final int LONG_TYPE;
    public static final Companion Companion;

    @NotNull
    public final ValueHolder readValue(@NotNull HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord field) {
        ValueHolder valueHolder;
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        int n = field.getType();
        if (n == 2) {
            valueHolder = (ValueHolder)new ValueHolder.ReferenceHolder(this.readId());
        } else if (n == BOOLEAN_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.BooleanHolder(this.readBoolean());
        } else if (n == CHAR_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.CharHolder(this.readChar());
        } else if (n == FLOAT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.FloatHolder(this.readFloat());
        } else if (n == DOUBLE_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.DoubleHolder(this.readDouble());
        } else if (n == BYTE_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.ByteHolder(this.readByte());
        } else if (n == SHORT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.ShortHolder(this.readShort());
        } else if (n == INT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.IntHolder(this.readInt());
        } else if (n == LONG_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.LongHolder(this.readLong());
        } else {
            throw (Throwable)new IllegalStateException("Unknown type " + field.getType());
        }
        return valueHolder;
    }

    private final long readId() {
        long l;
        switch (this.identifierByteSize) {
            case 1: {
                l = this.readByte();
                break;
            }
            case 2: {
                l = this.readShort();
                break;
            }
            case 4: {
                l = this.readInt();
                break;
            }
            case 8: {
                l = this.readLong();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
            }
        }
        return l;
    }

    private final boolean readBoolean() {
        byte value = this.record.getFieldValues()[this.position];
        int n = this.position;
        this.position = n + 1;
        return value != (byte)0;
    }

    private final byte readByte() {
        byte value = this.record.getFieldValues()[this.position];
        int n = this.position;
        this.position = n + 1;
        return value;
    }

    private final int readInt() {
        int value = ByteSubArrayKt.readInt(this.record.getFieldValues(), this.position);
        this.position += 4;
        return value;
    }

    private final short readShort() {
        short value = ByteSubArrayKt.readShort(this.record.getFieldValues(), this.position);
        this.position += 2;
        return value;
    }

    private final long readLong() {
        long value = ByteSubArrayKt.readLong(this.record.getFieldValues(), this.position);
        this.position += 8;
        return value;
    }

    private final float readFloat() {
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = this.readInt();
        boolean bl = false;
        return Float.intBitsToFloat(n);
    }

    private final double readDouble() {
        DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
        long l = this.readLong();
        boolean bl = false;
        return Double.longBitsToDouble(l);
    }

    private final char readChar() {
        byte[] byArray = this.record.getFieldValues();
        int n = this.position;
        int n2 = 2;
        Charset charset = Charsets.UTF_16BE;
        boolean bl = false;
        String string = new String(byArray, n, n2, charset);
        this.position += 2;
        return string.charAt(0);
    }

    public FieldValuesReader(@NotNull HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord record, int identifierByteSize) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        this.record = record;
        this.identifierByteSize = identifierByteSize;
    }

    static {
        Companion = new Companion(null);
        BOOLEAN_TYPE = PrimitiveType.BOOLEAN.getHprofType();
        CHAR_TYPE = PrimitiveType.CHAR.getHprofType();
        FLOAT_TYPE = PrimitiveType.FLOAT.getHprofType();
        DOUBLE_TYPE = PrimitiveType.DOUBLE.getHprofType();
        BYTE_TYPE = PrimitiveType.BYTE.getHprofType();
        SHORT_TYPE = PrimitiveType.SHORT.getHprofType();
        INT_TYPE = PrimitiveType.INT.getHprofType();
        LONG_TYPE = PrimitiveType.LONG.getHprofType();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lshark/internal/FieldValuesReader$Companion;", "", "()V", "BOOLEAN_TYPE", "", "BYTE_TYPE", "CHAR_TYPE", "DOUBLE_TYPE", "FLOAT_TYPE", "INT_TYPE", "LONG_TYPE", "SHORT_TYPE", "shark-graph"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

